/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.LockOptions;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.AliasCollector;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.PluralTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.jboss.logging.Logger;

public class LoaderSelectBuilder {
    private static final Logger log = Logger.getLogger(LoaderSelectBuilder.class);
    private final SqlAstCreationContext creationContext;
    private final Loadable loadable;
    private final List<? extends ModelPart> partsToSelect;
    private final List<ModelPart> restrictedParts;
    private final DomainResult<?> cachedDomainResult;
    private final int numberOfKeysToLoad;
    private final boolean forceIdentifierSelection;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockOptions lockOptions;
    private final Consumer<JdbcParameter> jdbcParameterConsumer;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private RowCardinality rowCardinality = RowCardinality.SINGLE;

    public static SelectStatement createSelectByUniqueKey(Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult<?> cachedDomainResult, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder(sessionFactory, loadable, partsToSelect, Collections.singletonList(restrictedPart), cachedDomainResult, 1, loadQueryInfluencers, lockOptions, LoaderSelectBuilder.determineGraphTraversalState(loadQueryInfluencers, sessionFactory), true, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSelectBySingleArrayParameter(Loadable loadable, ValuedModelPart restrictedPart, LoadQueryInfluencers influencers, LockOptions lockOptions, JdbcParameter jdbcArrayParameter, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder builder = new LoaderSelectBuilder(sessionFactory, loadable, null, Collections.singletonList(restrictedPart), null, -1, influencers, lockOptions, LoaderSelectBuilder.determineGraphTraversalState(influencers, sessionFactory), true, null);
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = builder.createSqlAstCreationState(rootQuerySpec);
        NavigablePath rootNavigablePath = new NavigablePath(loadable.getRootPathName());
        TableGroup rootTableGroup = builder.buildRootTableGroup(rootNavigablePath, rootQuerySpec, sqlAstCreationState);
        DomainResult domainResult = loadable.createDomainResult(rootNavigablePath, rootTableGroup, null, sqlAstCreationState);
        List<DomainResult<?>> domainResults = Collections.singletonList(domainResult);
        LoaderSelectBuilder.applyArrayParamRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, restrictedPart, jdbcArrayParameter, sqlAstCreationState);
        if (loadable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)loadable;
            builder.applyFiltering(rootQuerySpec, rootTableGroup, pluralAttributeMapping, (SqlAstCreationState)sqlAstCreationState);
            builder.applyOrdering(rootQuerySpec, rootTableGroup, pluralAttributeMapping, (SqlAstCreationState)sqlAstCreationState);
        } else {
            builder.applyFiltering((PredicateContainer)rootQuerySpec, rootTableGroup, (Restrictable)((Object)loadable), (SqlAstCreationState)sqlAstCreationState);
        }
        return new SelectStatement(rootQuerySpec, domainResults);
    }

    private static void applyArrayParamRestriction(QuerySpec rootQuerySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, ValuedModelPart restrictedPart, JdbcParameter jdbcArrayParameter, LoaderSqlAstCreationState sqlAstCreationState) {
        assert (restrictedPart.getJdbcTypeCount() == 1);
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        SelectableMapping restrictedPartMapping = restrictedPart.getSelectable(0);
        NavigablePath restrictionPath = rootNavigablePath.append(restrictedPart.getNavigableRole().getNavigableName());
        TableReference tableReference = rootTableGroup.resolveTableReference(restrictionPath, restrictedPartMapping.getContainingTableExpression());
        ColumnReference columnRef = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(tableReference, restrictedPartMapping);
        rootQuerySpec.applyPredicate(new InArrayPredicate(columnRef, jdbcArrayParameter));
    }

    public static SelectStatement createSelect(Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, loadable, partsToSelect, restrictedPart, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSelect(Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, loadable, partsToSelect, restrictedParts, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect();
    }

    static SelectStatement createSelect(Loadable loadable, List<ModelPart> partsToSelect, boolean forceIdentifierSelection, List<ModelPart> restrictedParts, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder(sessionFactory, loadable, partsToSelect, restrictedParts, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, LoaderSelectBuilder.determineGraphTraversalState(loadQueryInfluencers, sessionFactory), forceIdentifierSelection, jdbcParameterConsumer);
        return process.generateSelect();
    }

    public static SelectStatement createSubSelectFetchSelect(PluralAttributeMapping attributeMapping, SubselectFetch subselect, DomainResult<?> cachedDomainResult, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer, SessionFactoryImplementor sessionFactory) {
        LoaderSelectBuilder process = new LoaderSelectBuilder((SqlAstCreationContext)sessionFactory, (Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), cachedDomainResult, -1, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
        return process.generateSelect(subselect);
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, EntityGraphTraversalState entityGraphTraversalState, boolean forceIdentifierSelection, Consumer<JdbcParameter> jdbcParameterConsumer) {
        PluralAttributeMapping pluralAttributeMapping;
        this.creationContext = creationContext;
        this.loadable = loadable;
        this.partsToSelect = partsToSelect;
        this.restrictedParts = restrictedParts;
        this.cachedDomainResult = cachedDomainResult;
        this.numberOfKeysToLoad = numberOfKeysToLoad;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockOptions = lockOptions;
        this.entityGraphTraversalState = entityGraphTraversalState;
        this.forceIdentifierSelection = forceIdentifierSelection;
        this.jdbcParameterConsumer = jdbcParameterConsumer;
        if (loadable instanceof PluralAttributeMapping && (pluralAttributeMapping = (PluralAttributeMapping)loadable).getMappedType().getCollectionSemantics().getCollectionClassification() == CollectionClassification.BAG) {
            this.rowCardinality = RowCardinality.BAG;
        }
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, List<ModelPart> restrictedParts, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this(creationContext, loadable, partsToSelect, restrictedParts, cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions != null ? lockOptions : LockOptions.NONE, LoaderSelectBuilder.determineGraphTraversalState(loadQueryInfluencers, creationContext.getSessionFactory()), LoaderSelectBuilder.determineWhetherToForceIdSelection(numberOfKeysToLoad, restrictedParts), jdbcParameterConsumer);
    }

    private LoaderSelectBuilder(SqlAstCreationContext creationContext, Loadable loadable, List<? extends ModelPart> partsToSelect, ModelPart restrictedPart, DomainResult<?> cachedDomainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, Consumer<JdbcParameter> jdbcParameterConsumer) {
        this(creationContext, loadable, partsToSelect, Collections.singletonList(restrictedPart), cachedDomainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions, jdbcParameterConsumer);
    }

    private static boolean determineWhetherToForceIdSelection(int numberOfKeysToLoad, List<ModelPart> restrictedParts) {
        ModelPart restrictedPart;
        if (numberOfKeysToLoad > 1) {
            return true;
        }
        if (restrictedParts.size() == 1 && Objects.equals((restrictedPart = restrictedParts.get(0)).getPartName(), "{natural-id}")) {
            return true;
        }
        for (ModelPart restrictedPart2 : restrictedParts) {
            if (!(restrictedPart2 instanceof ForeignKeyDescriptor) && !(restrictedPart2 instanceof NonAggregatedIdentifierMapping)) continue;
            return true;
        }
        return false;
    }

    private static EntityGraphTraversalState determineGraphTraversalState(LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        EffectiveEntityGraph effectiveEntityGraph;
        if (loadQueryInfluencers != null && (effectiveEntityGraph = loadQueryInfluencers.getEffectiveEntityGraph()) != null) {
            GraphSemantic graphSemantic = effectiveEntityGraph.getSemantic();
            RootGraphImplementor<?> rootGraphImplementor = effectiveEntityGraph.getGraph();
            if (graphSemantic != null && rootGraphImplementor != null) {
                return new StandardEntityGraphTraversalStateImpl(graphSemantic, rootGraphImplementor, sessionFactory.getJpaMetamodel());
            }
        }
        return null;
    }

    private SelectStatement generateSelect() {
        List<Object> domainResults;
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        LoaderSqlAstCreationState sqlAstCreationState = this.createSqlAstCreationState(rootQuerySpec);
        TableGroup rootTableGroup = this.buildRootTableGroup(rootNavigablePath, rootQuerySpec, sqlAstCreationState);
        if (this.partsToSelect != null && !this.partsToSelect.isEmpty()) {
            domainResults = this.buildRequestedDomainResults(rootNavigablePath, sqlAstCreationState, rootTableGroup);
        } else if (this.cachedDomainResult != null) {
            domainResults = Collections.singletonList(this.cachedDomainResult);
        } else {
            DomainResult domainResult = this.loadable.createDomainResult(rootNavigablePath, rootTableGroup, null, sqlAstCreationState);
            domainResults = Collections.singletonList(domainResult);
        }
        for (ModelPart restrictedPart : this.restrictedParts) {
            int numberOfRestrictionColumns = restrictedPart.getJdbcTypeCount();
            this.applyRestriction(rootQuerySpec, rootNavigablePath, rootTableGroup, restrictedPart, numberOfRestrictionColumns, this.jdbcParameterConsumer, sqlAstCreationState);
        }
        if (this.loadable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)this.loadable;
            this.applyFiltering(rootQuerySpec, rootTableGroup, pluralAttributeMapping, (SqlAstCreationState)sqlAstCreationState);
            this.applyOrdering(rootQuerySpec, rootTableGroup, pluralAttributeMapping, (SqlAstCreationState)sqlAstCreationState);
        } else {
            this.applyFiltering((PredicateContainer)rootQuerySpec, rootTableGroup, (Restrictable)((Object)this.loadable), (SqlAstCreationState)sqlAstCreationState);
        }
        return new SelectStatement(rootQuerySpec, domainResults);
    }

    private List<DomainResult<?>> buildRequestedDomainResults(NavigablePath rootNavigablePath, LoaderSqlAstCreationState sqlAstCreationState, TableGroup rootTableGroup) {
        ArrayList domainResults = new ArrayList(this.partsToSelect.size());
        for (ModelPart modelPart : this.partsToSelect) {
            TableGroup tableGroup;
            NavigablePath navigablePath = rootNavigablePath.append(modelPart.getPartName());
            if (modelPart instanceof TableGroupJoinProducer) {
                TableGroupJoinProducer tableGroupJoinProducer = (TableGroupJoinProducer)modelPart;
                TableGroupJoin tableGroupJoin = tableGroupJoinProducer.createTableGroupJoin(navigablePath, rootTableGroup, null, null, SqlAstJoinType.LEFT, true, false, sqlAstCreationState);
                rootTableGroup.addTableGroupJoin(tableGroupJoin);
                tableGroup = tableGroupJoin.getJoinedGroup();
                sqlAstCreationState.getFromClauseAccess().registerTableGroup(navigablePath, tableGroup);
                this.registerPluralTableGroupParts(sqlAstCreationState.getFromClauseAccess(), tableGroup);
            } else {
                tableGroup = rootTableGroup;
            }
            domainResults.add(modelPart.createDomainResult(navigablePath, tableGroup, null, sqlAstCreationState));
        }
        return domainResults;
    }

    private TableGroup buildRootTableGroup(NavigablePath rootNavigablePath, QuerySpec rootQuerySpec, LoaderSqlAstCreationState sqlAstCreationState) {
        TableGroup rootTableGroup = this.loadable.createRootTableGroup(true, rootNavigablePath, null, null, () -> rootQuerySpec::applyPredicate, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        this.registerPluralTableGroupParts(sqlAstCreationState.getFromClauseAccess(), rootTableGroup);
        return rootTableGroup;
    }

    private LoaderSqlAstCreationState createSqlAstCreationState(QuerySpec rootQuerySpec) {
        return new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.forceIdentifierSelection, this.loadQueryInfluencers, this.creationContext);
    }

    private void applyRestriction(QuerySpec rootQuerySpec, NavigablePath rootNavigablePath, TableGroup rootTableGroup, ModelPart restrictedPart, int numberColumns, Consumer<JdbcParameter> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState) {
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        NavigablePath navigablePath = rootNavigablePath.append(restrictedPart.getNavigableRole().getNavigableName());
        if (numberColumns == 1) {
            restrictedPart.forEachSelectable((columnIndex, selection) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                ColumnReference columnRef = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(tableReference, selection);
                if (this.numberOfKeysToLoad == 1) {
                    SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(selection);
                    jdbcParameterConsumer.accept(jdbcParameter);
                    rootQuerySpec.applyPredicate(new ComparisonPredicate(columnRef, ComparisonOperator.EQUAL, jdbcParameter));
                } else {
                    InListPredicate predicate = new InListPredicate(columnRef);
                    for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                        SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(selection);
                        jdbcParameterConsumer.accept(jdbcParameter);
                        predicate.addExpression(jdbcParameter);
                    }
                    rootQuerySpec.applyPredicate(predicate);
                }
            });
        } else {
            ArrayList columnReferences = new ArrayList(numberColumns);
            restrictedPart.forEachSelectable((columnIndex, selection) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
                columnReferences.add((ColumnReference)sqlExpressionResolver.resolveSqlExpression(tableReference, selection));
            });
            SqlTuple tuple = new SqlTuple(columnReferences, restrictedPart);
            InListPredicate predicate = new InListPredicate(tuple);
            for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                ArrayList tupleParams = new ArrayList(numberColumns);
                restrictedPart.forEachSelectable((columnIndex, selection) -> {
                    SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(selection);
                    jdbcParameterConsumer.accept(jdbcParameter);
                    tupleParams.add(jdbcParameter);
                });
                SqlTuple paramTuple = new SqlTuple(tupleParams, restrictedPart);
                predicate.addExpression(paramTuple);
            }
            rootQuerySpec.applyPredicate(predicate);
        }
    }

    private void applyFiltering(QuerySpec querySpec, TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping, SqlAstCreationState astCreationState) {
        assert (tableGroup.getNavigablePath().getParent() == null);
        pluralAttributeMapping.applyBaseRestrictions(querySpec::applyPredicate, tableGroup, true, this.loadQueryInfluencers.getEnabledFilters(), false, null, astCreationState);
        pluralAttributeMapping.applyBaseManyToManyRestrictions(querySpec::applyPredicate, tableGroup, true, this.loadQueryInfluencers.getEnabledFilters(), null, astCreationState);
    }

    private void applyFiltering(PredicateContainer predicateContainer, TableGroup tableGroup, Restrictable restrictable, SqlAstCreationState astCreationState) {
        restrictable.applyBaseRestrictions(predicateContainer::applyPredicate, tableGroup, true, this.loadQueryInfluencers.getEnabledFilters(), true, null, astCreationState);
    }

    private void applyOrdering(QuerySpec querySpec, TableGroup tableGroup, PluralAttributeMapping pluralAttributeMapping, SqlAstCreationState astCreationState) {
        if (pluralAttributeMapping.getOrderByFragment() != null) {
            this.applyOrdering(querySpec, tableGroup, pluralAttributeMapping.getOrderByFragment(), astCreationState);
        }
        if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
            this.applyOrdering(querySpec, tableGroup, pluralAttributeMapping.getManyToManyOrderByFragment(), astCreationState);
        }
    }

    private void applyOrdering(QuerySpec querySpec, TableGroup tableGroup, OrderByFragment orderByFragment, SqlAstCreationState astCreationState) {
        orderByFragment.apply(querySpec, tableGroup, astCreationState);
    }

    private ImmutableFetchList visitFetches(FetchParent fetchParent, LoaderSqlAstCreationState creationState) {
        int size;
        if (log.isTraceEnabled()) {
            log.tracef("Starting visitation of FetchParent's Fetchables : %s", (Object)fetchParent.getNavigablePath());
        }
        ImmutableFetchList.Builder fetches = new ImmutableFetchList.Builder(fetchParent.getReferencedMappingContainer());
        FetchableConsumer processor = this.createFetchableConsumer(fetchParent, creationState, fetches);
        FetchableContainer referencedMappingContainer = fetchParent.getReferencedMappingContainer();
        if (fetchParent.getNavigablePath().getParent() != null) {
            size = referencedMappingContainer.getNumberOfKeyFetchables();
            for (int i = 0; i < size; ++i) {
                processor.accept(referencedMappingContainer.getKeyFetchable(i), true, false);
            }
        }
        size = referencedMappingContainer.getNumberOfFetchables();
        ArrayList<Fetchable> bagFetchables = null;
        for (int i = 0; i < size; ++i) {
            Fetchable fetchable = referencedMappingContainer.getFetchable(i);
            if (this.isBag(fetchable)) {
                if (bagFetchables == null) {
                    bagFetchables = new ArrayList<Fetchable>();
                }
                bagFetchables.add(fetchable);
                continue;
            }
            processor.accept(fetchable, false, false);
        }
        if (bagFetchables != null) {
            for (Fetchable fetchable : bagFetchables) {
                processor.accept(fetchable, false, true);
            }
        }
        return fetches.build();
    }

    private boolean isBag(Fetchable fetchable) {
        return this.isPluralAttributeMapping(fetchable) && ((PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification() == CollectionClassification.BAG;
    }

    private boolean isPluralAttributeMapping(Fetchable fetchable) {
        AttributeMapping attributeMapping = fetchable.asAttributeMapping();
        return attributeMapping != null && attributeMapping.isPluralAttributeMapping();
    }

    private FetchableConsumer createFetchableConsumer(FetchParent fetchParent, LoaderSqlAstCreationState creationState, ImmutableFetchList.Builder fetches) {
        return (fetchable, isKeyFetchable, isABag) -> {
            NavigablePath fetchablePath;
            if (!fetchable.isSelectable()) {
                return;
            }
            if (isKeyFetchable) {
                EntityIdentifierMapping identifierMapping;
                if (fetchParent instanceof BiDirectionalFetch) {
                    BiDirectionalFetch parentAsBiDirectionalFetch = (BiDirectionalFetch)((Object)fetchParent);
                    Fetchable biDirectionalFetchedMapping = parentAsBiDirectionalFetch.getFetchedMapping();
                    identifierMapping = biDirectionalFetchedMapping instanceof EntityValuedFetchable ? ((EntityValuedFetchable)biDirectionalFetchedMapping).getEntityMappingType().getIdentifierMapping() : null;
                } else {
                    FetchableContainer fetchableContainer = fetchParent.getReferencedMappingContainer();
                    if (fetchableContainer instanceof EntityValuedModelPart) {
                        EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)fetchableContainer;
                        identifierMapping = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
                    } else {
                        identifierMapping = null;
                    }
                }
                fetchablePath = identifierMapping != null ? new EntityIdentifierNavigablePath(fetchParent.getNavigablePath(), ResultsHelper.attributeName(identifierMapping)) : fetchParent.resolveNavigablePath(fetchable);
            } else {
                fetchablePath = fetchParent.resolveNavigablePath(fetchable);
            }
            FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
            boolean joined = fetchable.getMappedFetchOptions().getStyle() == FetchStyle.JOIN;
            boolean explicitFetch = false;
            EntityGraphTraversalState.TraversalResult traversalResult = null;
            boolean isFetchablePluralAttributeMapping = isABag || this.isPluralAttributeMapping(fetchable);
            Integer maximumFetchDepth = this.creationContext.getMaximumFetchDepth();
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    EntityGraphTraversalState.FetchStrategy fetchStrategy = traversalResult.getFetchStrategy();
                    if (fetchStrategy != null) {
                        fetchTiming = fetchStrategy.getFetchTiming();
                        joined = fetchStrategy.isJoined();
                        explicitFetch = this.shouldExplicitFetch(maximumFetchDepth, fetchable, creationState);
                    }
                } else if (this.loadQueryInfluencers.hasEnabledFetchProfiles()) {
                    if (fetchTiming != FetchTiming.IMMEDIATE || fetchable.incrementFetchDepth()) {
                        String fetchableRole = fetchable.getNavigableRole().getFullPath();
                        for (String enabledFetchProfileName : this.loadQueryInfluencers.getEnabledFetchProfileNames()) {
                            FetchProfile enabledFetchProfile = this.creationContext.getSessionFactory().getFetchProfile(enabledFetchProfileName);
                            org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                            if (profileFetch == null) continue;
                            fetchTiming = profileFetch.getTiming();
                            joined = joined || profileFetch.getMethod() == FetchStyle.JOIN;
                            explicitFetch = this.shouldExplicitFetch(maximumFetchDepth, fetchable, creationState);
                        }
                    }
                } else if (this.loadQueryInfluencers.getEnabledCascadingFetchProfile() != null) {
                    CascadeStyle cascadeStyle = fetchable.asAttributeMapping() != null ? fetchable.asAttributeMapping().getAttributeMetadata().getCascadeStyle() : null;
                    CascadingAction cascadingAction = this.loadQueryInfluencers.getEnabledCascadingFetchProfile().getCascadingAction();
                    if (cascadeStyle == null || cascadeStyle.doCascade(cascadingAction)) {
                        fetchTiming = FetchTiming.IMMEDIATE;
                        boolean bl = joined = !isFetchablePluralAttributeMapping || this.rowCardinality == RowCardinality.SINGLE;
                    }
                }
            }
            if (joined && isFetchablePluralAttributeMapping) {
                switch (this.rowCardinality) {
                    case SET: {
                        joined = !isABag;
                        break;
                    }
                    case BAG: {
                        joined = false;
                    }
                }
            }
            try {
                Fetch biDirectionalFetch;
                if (fetchable.incrementFetchDepth()) {
                    ++this.fetchDepth;
                }
                if (!explicitFetch && !creationState.isResolvingCircularFetch() && (biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, fetchTiming, creationState)) != null) {
                    fetches.add(biDirectionalFetch);
                    return;
                }
                if (maximumFetchDepth != null) {
                    if (this.fetchDepth == maximumFetchDepth + 1) {
                        joined = false;
                    } else if (this.fetchDepth > maximumFetchDepth + 1 && fetchable.asBasicValuedModelPart() == null && !(fetchable instanceof EmbeddedAttributeMapping)) {
                        joined = false;
                    }
                }
                if (joined && isFetchablePluralAttributeMapping) {
                    this.rowCardinality = isABag ? RowCardinality.BAG : RowCardinality.SET;
                }
                Fetch fetch = fetchParent.generateFetchableFetch(fetchable, fetchablePath, fetchTiming, joined, null, creationState);
                fetches.add(fetch);
            }
            finally {
                if (fetchable.incrementFetchDepth()) {
                    --this.fetchDepth;
                }
                if (this.entityGraphTraversalState != null && traversalResult != null) {
                    this.entityGraphTraversalState.backtrack(traversalResult);
                }
            }
        };
    }

    private boolean shouldExplicitFetch(Integer maxFetchDepth, Fetchable fetchable, LoaderSqlAstCreationState creationState) {
        if (maxFetchDepth == null) {
            if (fetchable instanceof ToOneAttributeMapping) {
                return !creationState.isAssociationKeyVisited(((ToOneAttributeMapping)fetchable).getForeignKeyDescriptor().getAssociationKey());
            }
            if (fetchable instanceof PluralAttributeMapping) {
                return !creationState.isAssociationKeyVisited(((PluralAttributeMapping)fetchable).getKeyDescriptor().getAssociationKey());
            }
        }
        return true;
    }

    private SelectStatement generateSelect(SubselectFetch subselect) {
        assert (this.loadable instanceof PluralAttributeMapping);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        QuerySpec rootQuerySpec = new QuerySpec(true);
        NavigablePath rootNavigablePath = new NavigablePath(this.loadable.getRootPathName());
        Map<String, TableReference> tableReferences = AliasCollector.getTableReferences(subselect.getLoadingSqlAst());
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(tableReferences.keySet()), new SimpleFromClauseAccessImpl(), this.lockOptions, this::visitFetches, this.numberOfKeysToLoad > 1, this.loadQueryInfluencers, this.creationContext);
        TableGroup rootTableGroup = this.buildRootTableGroup(rootNavigablePath, rootQuerySpec, sqlAstCreationState);
        this.applySubSelectRestriction(rootQuerySpec, rootTableGroup, subselect, sqlAstCreationState);
        this.applyFiltering(rootQuerySpec, rootTableGroup, attributeMapping, (SqlAstCreationState)sqlAstCreationState);
        this.applyOrdering(rootQuerySpec, rootTableGroup, attributeMapping, (SqlAstCreationState)sqlAstCreationState);
        return new SelectStatement(rootQuerySpec, Collections.singletonList(new CollectionDomainResult(rootNavigablePath, attributeMapping, null, rootTableGroup, sqlAstCreationState)));
    }

    private void applySubSelectRestriction(QuerySpec querySpec, TableGroup rootTableGroup, SubselectFetch subselect, LoaderSqlAstCreationState sqlAstCreationState) {
        Expression fkExpression;
        assert (this.loadable instanceof PluralAttributeMapping);
        PluralAttributeMapping attributeMapping = (PluralAttributeMapping)this.loadable;
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        if (!fkDescriptor.isEmbedded()) {
            assert (fkDescriptor instanceof SimpleForeignKeyDescriptor);
            SimpleForeignKeyDescriptor simpleFkDescriptor = (SimpleForeignKeyDescriptor)fkDescriptor;
            TableReference tableReference = rootTableGroup.resolveTableReference(null, fkDescriptor, simpleFkDescriptor.getContainingTableExpression());
            fkExpression = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, simpleFkDescriptor);
        } else {
            ArrayList columnReferences = new ArrayList(fkDescriptor.getJdbcTypeCount());
            fkDescriptor.forEachSelectable((columnIndex, selection) -> {
                TableReference tableReference = rootTableGroup.resolveTableReference(null, fkDescriptor, selection.getContainingTableExpression());
                columnReferences.add((ColumnReference)sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(tableReference, selection));
            });
            fkExpression = new SqlTuple(columnReferences, fkDescriptor);
        }
        querySpec.applyPredicate(new InSubQueryPredicate(fkExpression, this.generateSubSelect(attributeMapping, subselect, sqlAstCreationState), false));
    }

    private QueryPart generateSubSelect(PluralAttributeMapping attributeMapping, SubselectFetch subselect, LoaderSqlAstCreationState creationState) {
        ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
        QuerySpec subQuery = new QuerySpec(false);
        QuerySpec loadingSqlAst = subselect.getLoadingSqlAst();
        TableGroup ownerTableGroup = subselect.getOwnerTableGroup();
        loadingSqlAst.getFromClause().visitRoots(subQuery.getFromClause()::addRoot);
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        fkDescriptor.visitTargetSelectables((valuesPosition, selection) -> {
            TableReference tableReference = ownerTableGroup.resolveTableReference(null, fkDescriptor, selection.getContainingTableExpression());
            Expression expression = sqlExpressionResolver.resolveSqlExpression(tableReference, selection);
            subQuery.getSelectClause().addSqlSelection(new SqlSelectionImpl(valuesPosition, expression));
        });
        subQuery.applyPredicate(loadingSqlAst.getWhereClauseRestrictions());
        return subQuery;
    }

    private void registerPluralTableGroupParts(FromClauseAccess fromClauseAccess, TableGroup tableGroup) {
        if (tableGroup instanceof PluralTableGroup) {
            PluralTableGroup pluralTableGroup = (PluralTableGroup)tableGroup;
            if (pluralTableGroup.getElementTableGroup() != null) {
                fromClauseAccess.registerTableGroup(pluralTableGroup.getElementTableGroup().getNavigablePath(), pluralTableGroup.getElementTableGroup());
            }
            if (pluralTableGroup.getIndexTableGroup() != null) {
                fromClauseAccess.registerTableGroup(pluralTableGroup.getIndexTableGroup().getNavigablePath(), pluralTableGroup.getIndexTableGroup());
            }
        }
    }

    private static enum RowCardinality {
        SINGLE,
        SET,
        BAG;

    }

    @FunctionalInterface
    private static interface FetchableConsumer {
        public void accept(Fetchable var1, boolean var2, boolean var3);
    }
}

