/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.EnumMarshallerDelegate;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.containers.ElementContainerAdapter;
import org.infinispan.protostream.containers.IndexedElementContainerAdapter;
import org.infinispan.protostream.containers.IterableElementContainerAdapter;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.TagWriterImpl;

public final class WrappedMessage {
    private static final Collection<Class<?>> WRAPPED_KNOWN_TYPES = List.of(Instant.class, Date.class);
    public static final String PROTOBUF_TYPE_NAME = "org.infinispan.protostream.WrappedMessage";
    public static final int PROTOBUF_TYPE_ID = 0;
    public static final String PROTO_FILE = "org/infinispan/protostream/message-wrapping.proto";
    public static final int WRAPPED_DOUBLE = 1;
    public static final int WRAPPED_FLOAT = 2;
    public static final int WRAPPED_INT64 = 3;
    public static final int WRAPPED_UINT64 = 4;
    public static final int WRAPPED_INT32 = 5;
    public static final int WRAPPED_FIXED64 = 6;
    public static final int WRAPPED_FIXED32 = 7;
    public static final int WRAPPED_BOOL = 8;
    public static final int WRAPPED_STRING = 9;
    public static final int WRAPPED_CHAR = 20;
    public static final int WRAPPED_SHORT = 21;
    public static final int WRAPPED_BYTE = 22;
    public static final int WRAPPED_DATE_MILLIS = 23;
    public static final int WRAPPED_INSTANT_SECONDS = 24;
    public static final int WRAPPED_INSTANT_NANOS = 25;
    public static final int WRAPPED_BYTES = 10;
    public static final int WRAPPED_UINT32 = 11;
    public static final int WRAPPED_SFIXED32 = 12;
    public static final int WRAPPED_SFIXED64 = 13;
    public static final int WRAPPED_SINT32 = 14;
    public static final int WRAPPED_SINT64 = 15;
    public static final int WRAPPED_TYPE_NAME = 16;
    @Deprecated
    public static final int WRAPPED_DESCRIPTOR_FULL_NAME = 16;
    public static final int WRAPPED_MESSAGE = 17;
    public static final int WRAPPED_ENUM = 18;
    public static final int WRAPPED_TYPE_ID = 19;
    @Deprecated
    public static final int WRAPPED_DESCRIPTOR_TYPE_ID = 19;
    @Deprecated
    public static final int WRAPPED_DESCRIPTOR_ID = 19;
    public static final int WRAPPED_EMPTY = 26;
    public static final int WRAPPED_CONTAINER_SIZE = 27;
    public static final int WRAPPED_CONTAINER_TYPE_NAME = 28;
    public static final int WRAPPED_CONTAINER_TYPE_ID = 29;
    public static final int WRAPPED_CONTAINER_MESSAGE = 30;
    public static final String CONTAINER_SIZE_CONTEXT_PARAM = "containerSize";
    private final Object value;
    static final BaseMarshaller<WrappedMessage> MARSHALLER = new ProtobufTagMarshaller<WrappedMessage>(){

        @Override
        public Class<WrappedMessage> getJavaClass() {
            return WrappedMessage.class;
        }

        @Override
        public String getTypeName() {
            return WrappedMessage.PROTOBUF_TYPE_NAME;
        }

        @Override
        public WrappedMessage read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            return new WrappedMessage(WrappedMessage.readMessage(ctx.getSerializationContext(), ctx.getReader(), false));
        }

        @Override
        public void write(ProtobufTagMarshaller.WriteContext ctx, WrappedMessage wrappedMessage) throws IOException {
            WrappedMessage.writeMessage(ctx.getSerializationContext(), ctx.getWriter(), wrappedMessage.value, false);
        }
    };

    public WrappedMessage(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    static void write(ImmutableSerializationContext ctx, TagWriter out, Object t) throws IOException {
        WrappedMessage.writeMessage(ctx, out, t, false);
    }

    private static void writeMessage(ImmutableSerializationContext ctx, TagWriter out, Object t, boolean nulls) throws IOException {
        if (WrappedMessage.tryWritePrimitive(out, t, nulls)) {
            return;
        }
        WrappedMessage.writeCustomObject(ctx, out, t);
    }

    private static boolean tryWritePrimitive(TagWriter out, Object t, boolean nulls) throws IOException {
        if (t == null) {
            if (nulls) {
                out.writeBool(26, true);
                out.flush();
            }
            return true;
        }
        if (t instanceof String) {
            out.writeString(9, (String)t);
        } else if (t instanceof Character) {
            out.writeInt32(20, ((Character)t).charValue());
        } else if (t instanceof Byte) {
            out.writeInt32(22, ((Byte)t).byteValue());
        } else if (t instanceof Short) {
            out.writeInt32(21, ((Short)t).shortValue());
        } else if (t instanceof Date) {
            out.writeInt64(23, ((Date)t).getTime());
        } else if (t instanceof Long) {
            out.writeInt64(3, (Long)t);
        } else if (t instanceof Integer) {
            out.writeInt32(5, (Integer)t);
        } else if (t instanceof Double) {
            out.writeDouble(1, (Double)t);
        } else if (t instanceof Float) {
            out.writeFloat(2, ((Float)t).floatValue());
        } else if (t instanceof Boolean) {
            out.writeBool(8, (Boolean)t);
        } else if (t instanceof byte[]) {
            out.writeBytes(10, (byte[])t);
        } else {
            return false;
        }
        out.flush();
        return true;
    }

    private static <T> void writeCustomObject(ImmutableSerializationContext ctx, TagWriter out, T t) throws IOException {
        if (t instanceof Instant) {
            Instant instant = (Instant)t;
            out.writeInt64(24, instant.getEpochSecond());
            out.writeInt32(25, instant.getNano());
            out.flush();
            return;
        }
        BaseMarshallerDelegate<T> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t);
        BaseMarshaller<T> marshaller = marshallerDelegate.getMarshaller();
        if (marshaller instanceof ElementContainerAdapter) {
            WrappedMessage.writeContainer(ctx, out, marshallerDelegate, t);
        } else {
            String typeName = marshaller.getTypeName();
            int typeId = WrappedMessage.mapTypeIdOut(typeName, ctx);
            if (typeId < 0) {
                out.writeString(16, typeName);
            } else {
                out.writeUInt32(19, typeId);
            }
            if (t.getClass().isEnum()) {
                ((EnumMarshallerDelegate)marshallerDelegate).encode(18, (Enum)t, out);
            } else {
                try (TagWriter nestedWriter = out.subWriter(17, false);){
                    marshallerDelegate.marshall((ProtobufTagMarshaller.WriteContext)((Object)nestedWriter), null, t);
                }
            }
        }
        out.flush();
    }

    private static void writeContainer(ImmutableSerializationContext ctx, TagWriter out, BaseMarshallerDelegate marshallerDelegate, Object container) throws IOException {
        BaseMarshaller containerMarshaller = marshallerDelegate.getMarshaller();
        String typeName = containerMarshaller.getTypeName();
        int typeId = WrappedMessage.mapTypeIdOut(typeName, ctx);
        if (typeId < 0) {
            out.writeString(28, typeName);
        } else {
            out.writeUInt32(29, typeId);
        }
        int containerSize = ((ElementContainerAdapter)((Object)containerMarshaller)).getNumElements(container);
        out.writeUInt32(27, containerSize);
        try (TagWriterImpl nestedCtx = (TagWriterImpl)out.subWriter(30, false);){
            marshallerDelegate.marshall(nestedCtx, null, container);
        }
        if (ctx.getConfiguration().wrapCollectionElements()) {
            WrappedMessage.writeContainerWrappingElements(containerMarshaller, containerSize, container, ctx, out);
        } else {
            WrappedMessage.writeContainerWithoutWrappingElements(containerMarshaller, containerSize, container, ctx, out);
        }
    }

    private static void writeContainerWrappingElements(BaseMarshaller containerMarshaller, int containerSize, Object container, ImmutableSerializationContext ctx, TagWriter out) throws IOException {
        if (containerMarshaller instanceof IterableElementContainerAdapter) {
            Iterator elements = ((IterableElementContainerAdapter)((Object)containerMarshaller)).getElements(container);
            for (int i = 0; i < containerSize; ++i) {
                WrappedMessage.writeContainerElementWrapped(ctx, out, elements.next());
            }
            if (elements.hasNext()) {
                throw new IllegalStateException("Container number of elements mismatch");
            }
        } else if (containerMarshaller instanceof IndexedElementContainerAdapter) {
            IndexedElementContainerAdapter adapter = (IndexedElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                WrappedMessage.writeContainerElementWrapped(ctx, out, adapter.getElement(container, i));
            }
        } else {
            throw new IllegalStateException("Unknown container adapter kind : " + containerMarshaller.getJavaClass().getName());
        }
    }

    private static void writeContainerWithoutWrappingElements(BaseMarshaller containerMarshaller, int containerSize, Object container, ImmutableSerializationContext ctx, TagWriter out) throws IOException {
        if (containerMarshaller instanceof IterableElementContainerAdapter) {
            Iterator elements = ((IterableElementContainerAdapter)((Object)containerMarshaller)).getElements(container);
            for (int i = 0; i < containerSize; ++i) {
                WrappedMessage.writeMessage(ctx, out, elements.next(), true);
            }
            if (elements.hasNext()) {
                throw new IllegalStateException("Container number of elements mismatch");
            }
        } else if (containerMarshaller instanceof IndexedElementContainerAdapter) {
            IndexedElementContainerAdapter adapter = (IndexedElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                WrappedMessage.writeMessage(ctx, out, adapter.getElement(container, i), true);
            }
        } else {
            throw new IllegalStateException("Unknown container adapter kind : " + containerMarshaller.getJavaClass().getName());
        }
    }

    private static void writeContainerElementWrapped(ImmutableSerializationContext ctx, TagWriter out, Object e) throws IOException {
        if (WrappedMessage.tryWritePrimitive(out, e, true)) {
            return;
        }
        try (TagWriter elementWriter = out.subWriter(17, false);){
            WrappedMessage.writeMessage(ctx, elementWriter, e, true);
        }
    }

    static <T> T read(ImmutableSerializationContext ctx, TagReader in) throws IOException {
        return WrappedMessage.readMessage(ctx, in, false);
    }

    private static <T> T readMessage(ImmutableSerializationContext ctx, TagReader in, boolean nulls) throws IOException {
        ValueOrTag<T> primitiveValue = WrappedMessage.tryReadPrimitive(in, nulls);
        if (primitiveValue.hasValue()) {
            return primitiveValue.getValue();
        }
        assert (primitiveValue.hasTag());
        return WrappedMessage.readCustomObject(primitiveValue.getTag(), ctx, in);
    }

    private static <T> ValueOrTag<T> tryReadPrimitive(TagReader in, boolean nulls) throws IOException {
        int tag = in.readTag();
        Object value = null;
        switch (tag) {
            case 208: {
                if (!nulls) {
                    throw new IllegalStateException("Encountered a null message but nulls are not accepted");
                }
                in.readBool();
                break;
            }
            case 74: {
                value = in.readString();
                break;
            }
            case 160: {
                value = Character.valueOf((char)in.readInt32());
                break;
            }
            case 168: {
                value = (short)in.readInt32();
                break;
            }
            case 176: {
                value = (byte)in.readInt32();
                break;
            }
            case 184: {
                value = new Date(in.readInt64());
                break;
            }
            case 82: {
                value = in.readByteArray();
                break;
            }
            case 64: {
                value = in.readBool();
                break;
            }
            case 9: {
                value = in.readDouble();
                break;
            }
            case 21: {
                value = Float.valueOf(in.readFloat());
                break;
            }
            case 61: {
                value = in.readFixed32();
                break;
            }
            case 101: {
                value = in.readSFixed32();
                break;
            }
            case 49: {
                value = in.readFixed64();
                break;
            }
            case 105: {
                value = in.readSFixed64();
                break;
            }
            case 24: {
                value = in.readInt64();
                break;
            }
            case 32: {
                value = in.readUInt64();
                break;
            }
            case 120: {
                value = in.readSInt64();
                break;
            }
            case 40: {
                value = in.readInt32();
                break;
            }
            case 88: {
                value = in.readUInt32();
                break;
            }
            case 112: {
                value = in.readSInt32();
                break;
            }
            case 0: {
                return new Value<Object>(null);
            }
            default: {
                return new Tag(tag);
            }
        }
        return new Value<Object>(value);
    }

    private static <T> T readCustomObject(int tag, ImmutableSerializationContext ctx, TagReader in) throws IOException {
        int expectedFieldCount;
        String typeName = null;
        int typeId = -1;
        int enumValue = -1;
        ByteBuffer messageBytes = null;
        boolean valueProvided = false;
        Object value = null;
        int fieldCount = 0;
        do {
            ++fieldCount;
            switch (tag) {
                case 216: 
                case 226: 
                case 232: 
                case 242: {
                    expectedFieldCount = 1;
                    value = WrappedMessage.readContainer(ctx, in, tag);
                    break;
                }
                case 130: {
                    expectedFieldCount = 2;
                    typeName = in.readString();
                    break;
                }
                case 152: {
                    expectedFieldCount = 2;
                    typeId = WrappedMessage.mapTypeIdIn(in.readInt32(), ctx);
                    break;
                }
                case 144: {
                    expectedFieldCount = 2;
                    enumValue = in.readEnum();
                    break;
                }
                case 138: {
                    expectedFieldCount = 2;
                    if (typeId > 0 || typeName != null) {
                        int length = in.readInt32();
                        int oldLimit = in.pushLimit(length);
                        BaseMarshallerDelegate<T> marshallerDelegate = WrappedMessage.delegateForType((SerializationContextImpl)ctx, typeId, typeName);
                        value = marshallerDelegate.unmarshall((ProtobufTagMarshaller.ReadContext)((Object)in), null);
                        in.popLimit(oldLimit);
                        valueProvided = true;
                        break;
                    }
                    messageBytes = in.readByteBuffer();
                    break;
                }
                case 192: {
                    expectedFieldCount = 2;
                    long seconds = in.readInt64();
                    value = value == null ? Instant.ofEpochSecond(seconds, 0L) : Instant.ofEpochSecond(seconds, ((Instant)value).getNano());
                    break;
                }
                case 200: {
                    expectedFieldCount = 2;
                    int nanos = in.readInt32();
                    value = value == null ? Instant.ofEpochSecond(0L, nanos) : Instant.ofEpochSecond(((Instant)value).getEpochSecond(), nanos);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tag : " + tag + " (Field number : " + WireType.getTagFieldNumber(tag) + ", Wire type : " + WireType.getTagWireType(tag) + ")");
                }
            }
        } while ((tag = in.readTag()) != 0);
        if (value == null && typeName == null && typeId == -1 && messageBytes == null) {
            return null;
        }
        if (valueProvided || value != null) {
            if (fieldCount != expectedFieldCount) {
                throw new IOException("Invalid WrappedMessage encoding.");
            }
            return (T)value;
        }
        if (typeName == null && typeId == -1 || typeName != null && typeId >= 0 || fieldCount != 2) {
            throw new IOException("Invalid WrappedMessage encoding.");
        }
        BaseMarshallerDelegate<T> marshallerDelegate = WrappedMessage.delegateForType((SerializationContextImpl)ctx, typeId, typeName);
        if (messageBytes != null) {
            TagReaderImpl nestedInput = TagReaderImpl.newInstance(ctx, messageBytes);
            return marshallerDelegate.unmarshall(nestedInput, null);
        }
        EnumMarshaller marshaller = (EnumMarshaller)marshallerDelegate.getMarshaller();
        Object e = marshaller.decode(enumValue);
        if (e == null) {
            throw new IOException("Unknown enum value " + enumValue + " for Protobuf enum type " + marshaller.getTypeName());
        }
        return (T)e;
    }

    private static <T> BaseMarshallerDelegate<T> delegateForType(SerializationContextImpl ctx, int typeId, String typeName) {
        return typeId >= 0 ? ctx.getMarshallerDelegate(typeId) : ctx.getMarshallerDelegate(typeName);
    }

    private static Object readContainer(ImmutableSerializationContext ctx, TagReader in, int tag) throws IOException {
        int containerSize = -1;
        String containerTypeName = null;
        int containerTypeId = -1;
        ByteBuffer containerMessage = null;
        int fieldCount = 0;
        while (tag != 0) {
            switch (tag) {
                case 216: {
                    containerSize = in.readInt32();
                    break;
                }
                case 226: {
                    containerTypeName = in.readString();
                    break;
                }
                case 232: {
                    containerTypeId = WrappedMessage.mapTypeIdIn(in.readInt32(), ctx);
                    break;
                }
                case 242: {
                    containerMessage = in.readByteBuffer();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tag : " + tag + " (Field number : " + WireType.getTagFieldNumber(tag) + ", Wire type : " + WireType.getTagWireType(tag) + ")");
                }
            }
            if (++fieldCount == 3) break;
            tag = in.readTag();
        }
        if (fieldCount != 3 || containerSize < 0 || containerMessage == null || containerTypeId == -1 && containerTypeName == null || containerTypeId >= 0 && containerTypeName != null) {
            throw new IOException("Invalid WrappedMessage encoding.");
        }
        BaseMarshallerDelegate<Object> marshallerDelegate = containerTypeId >= 0 ? ctx.getMarshallerDelegate(containerTypeId) : ((SerializationContextImpl)ctx).getMarshallerDelegate(containerTypeName);
        BaseMarshaller<Object> containerMarshaller = marshallerDelegate.getMarshaller();
        if (!(containerMarshaller instanceof ElementContainerAdapter)) {
            throw new IllegalStateException("The unmarshaller is not a container adapter : " + containerMarshaller.getJavaClass().getName());
        }
        TagReaderImpl nestedInput = TagReaderImpl.newNestedInstance((ProtobufTagMarshaller.ReadContext)((Object)in), containerMessage);
        nestedInput.setParam(CONTAINER_SIZE_CONTEXT_PARAM, containerSize);
        Object container = marshallerDelegate.unmarshall(nestedInput, null);
        if (container == null) {
            throw new IllegalStateException("The unmarshalled container must not be null");
        }
        if (ctx.getConfiguration().wrapCollectionElements()) {
            WrappedMessage.readContainerWithWrappedElements(containerMarshaller, containerSize, container, ctx, in);
        } else {
            WrappedMessage.readContainerWithoutWrappedElements(containerMarshaller, containerSize, container, ctx, in);
        }
        return container;
    }

    private static void readContainerWithWrappedElements(BaseMarshaller<?> containerMarshaller, int containerSize, Object container, ImmutableSerializationContext ctx, TagReader in) throws IOException {
        if (containerMarshaller instanceof IterableElementContainerAdapter) {
            IterableElementContainerAdapter adapter = (IterableElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                adapter.appendElement(container, WrappedMessage.readContainerElementWrapped(ctx, in));
            }
        } else if (containerMarshaller instanceof IndexedElementContainerAdapter) {
            IndexedElementContainerAdapter adapter = (IndexedElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                adapter.setElement(container, i, WrappedMessage.readContainerElementWrapped(ctx, in));
            }
        } else {
            throw new IllegalStateException("Unknown container adapter kind : " + containerMarshaller.getJavaClass().getName());
        }
    }

    private static void readContainerWithoutWrappedElements(BaseMarshaller<?> containerMarshaller, int containerSize, Object container, ImmutableSerializationContext ctx, TagReader in) throws IOException {
        if (containerMarshaller instanceof IterableElementContainerAdapter) {
            IterableElementContainerAdapter adapter = (IterableElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                adapter.appendElement(container, WrappedMessage.readMessage(ctx, in, true));
            }
        } else if (containerMarshaller instanceof IndexedElementContainerAdapter) {
            IndexedElementContainerAdapter adapter = (IndexedElementContainerAdapter)((Object)containerMarshaller);
            for (int i = 0; i < containerSize; ++i) {
                adapter.setElement(container, i, WrappedMessage.readMessage(ctx, in, true));
            }
        } else {
            throw new IllegalStateException("Unknown container adapter kind : " + containerMarshaller.getJavaClass().getName());
        }
    }

    private static <E> E readContainerElementWrapped(ImmutableSerializationContext ctx, TagReader in) throws IOException {
        ValueOrTag primitiveValue = WrappedMessage.tryReadPrimitive(in, true);
        if (primitiveValue.hasValue()) {
            return (E)primitiveValue.getValue();
        }
        assert (primitiveValue.hasTag());
        int tag = primitiveValue.getTag();
        if (tag != 138) {
            throw new IllegalStateException("Unexpected tag : " + tag + " (Field number : " + WireType.getTagFieldNumber(tag) + ", Wire type : " + WireType.getTagWireType(tag) + ")");
        }
        TagReaderImpl elementReader = TagReaderImpl.newInstance(ctx, in.readByteBuffer());
        return (E)WrappedMessage.readMessage(ctx, elementReader, true);
    }

    public static boolean knownWrappedDescriptor(ImmutableSerializationContext ctx, GenericDescriptor descriptor) {
        return WRAPPED_KNOWN_TYPES.stream().filter(ctx::canMarshall).map(ctx::getMarshaller).filter(Objects::nonNull).anyMatch(m -> ctx.getDescriptorByName(m.getTypeName()) == descriptor);
    }

    public static boolean isWrappedMessageField(FieldDescriptor descriptor) {
        Descriptor cm = descriptor.getContainingMessage();
        if (cm == null || cm.getTypeId() == null || cm.getTypeId() != 0 || !cm.getFullName().equals(PROTOBUF_TYPE_NAME)) {
            return false;
        }
        int number = descriptor.getNumber();
        return number == 1 || number == 2 || number == 3 || number == 4 || number == 5 || number == 8 || number == 9 || number == 20 || number == 21 || number == 22 || number == 23 || number == 24 || number == 25 || number == 10 || number == 11 || number == 12 || number == 13 || number == 14 || number == 15 || number == 16 || number == 17 || number == 18 || number == 19 || number == 26 || number == 27 || number == 28 || number == 29 || number == 30;
    }

    private static int mapTypeIdIn(int typeId, ImmutableSerializationContext ctx) {
        return typeId;
    }

    private static int mapTypeIdOut(String typeName, ImmutableSerializationContext ctx) {
        Integer typeId = ctx.getDescriptorByName(typeName).getTypeId();
        if (typeId == null) {
            return -1;
        }
        return typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrappedMessage other = (WrappedMessage)o;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "WrappedMessage{value=" + String.valueOf(this.value) + "}";
    }

    private static interface ValueOrTag<T> {
        default public boolean hasValue() {
            return false;
        }

        default public boolean hasTag() {
            return false;
        }

        default public T getValue() {
            throw new UnsupportedOperationException();
        }

        default public int getTag() {
            throw new UnsupportedOperationException();
        }
    }

    private record Value<T>(T value) implements ValueOrTag<T>
    {
        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean hasValue() {
            return true;
        }
    }

    private record Tag<T>(int tag) implements ValueOrTag<T>
    {
        @Override
        public boolean hasTag() {
            return true;
        }

        @Override
        public int getTag() {
            return this.tag;
        }
    }
}

