/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.infinispan.protostream.RandomAccessOutputStream;
import org.infinispan.protostream.impl.VarHandlesUtil;

public class RandomAccessOutputStreamImpl
extends OutputStream
implements RandomAccessOutputStream {
    static final int MIN_SIZE = 32;
    static final int DEFAULT_DOUBLING_SIZE = 0x400000;
    protected byte[] buf;
    protected int pos = 0;

    public RandomAccessOutputStreamImpl() {
    }

    public RandomAccessOutputStreamImpl(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative initial capacity: " + capacity);
        }
        this.buf = new byte[capacity];
    }

    @Override
    public byte get(int position) {
        return this.buf[position];
    }

    @Override
    public void write(int b) {
        int newpos = this.pos + 1;
        this.ensureCapacity(newpos);
        this.buf[this.pos] = (byte)b;
        this.pos = newpos;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.pos + len;
        this.ensureCapacity(newcount);
        this.write(this.pos, b, off, len);
        this.pos = newcount;
    }

    @Override
    public void write(int position, int b) {
        this.buf[position] = (byte)b;
    }

    @Override
    public void write(int position, byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, position, len);
    }

    @Override
    public void move(int startPos, int length, int newPos) {
        assert (startPos < newPos);
        this.ensureCapacity(newPos + length);
        System.arraycopy(this.buf, startPos, this.buf, newPos, length);
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (this.buf == null) {
            this.buf = new byte[Math.max(32, capacity)];
        } else if (capacity > this.buf.length) {
            byte[] newbuf = new byte[RandomAccessOutputStreamImpl.getNewBufferSize(this.buf.length, capacity)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
            this.buf = newbuf;
        }
    }

    private static int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= 0x400000) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(int position) {
        this.pos = position;
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.buf == null ? ByteBuffer.wrap(new byte[0]) : ByteBuffer.wrap(this.buf, 0, this.pos);
    }

    @Override
    public void copyTo(DataOutput output) throws IOException {
        output.write(this.buf, 0, this.pos);
    }

    @Override
    public void writeFixed32Direct(int position, int value) {
        VarHandlesUtil.INT.set(this.buf, position, value);
    }

    @Override
    public void writeFixed64Direct(int position, long value) {
        VarHandlesUtil.LONG.set(this.buf, position, value);
    }
}

