/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Objects;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RandomAccessOutputStream;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.MapDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.RandomAccessOutputStreamImpl;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.infinispan.protostream.impl.json.JsonHelper;

public final class JsonReader {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    private JsonReader() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] fromJson(ImmutableSerializationContext ctx, Reader reader) throws IOException {
        try (Reader reader2 = reader;){
            byte[] byArray;
            JsonParser parser = JSON_FACTORY.createParser(reader);
            JsonToken token = parser.nextToken();
            if (token == null || token == JsonToken.VALUE_NULL) {
                byte[] byArray2 = JsonHelper.EMPTY_ARRAY;
                return byArray2;
            }
            if (token != JsonToken.START_OBJECT) {
                throw new IllegalStateException("Invalid top level object! Found token: " + String.valueOf(token));
            }
            try (RandomAccessOutputStreamImpl raos = new RandomAccessOutputStreamImpl(512);){
                TagWriterImpl writer = TagWriterImpl.newInstance(ctx, raos);
                JsonReader.processDocument(ctx, parser, writer, null, null);
                writer.flush();
                byArray = raos.toByteArray();
            }
            return byArray;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Invalid JSON", e);
        }
    }

    private static void processDocument(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, Descriptor descriptor, Integer fieldNumber) throws IOException {
        boolean keepParsing = true;
        while (keepParsing) {
            keepParsing = JsonReader.processSingleDocument(ctx, parser, writer, descriptor, fieldNumber);
        }
    }

    private static boolean processSingleDocument(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, Descriptor messageDescriptor, Integer fieldNumber) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_ARRAY: 
                case END_OBJECT: {
                    return false;
                }
                case FIELD_NAME: {
                    String currentField = parser.currentName();
                    JsonReader.readSingleField(ctx, parser, writer, messageDescriptor, currentField, fieldNumber);
                    break;
                }
                case VALUE_STRING: {
                    String topLevelTypeName = parser.getText();
                    Type type = Type.primitiveFromString(topLevelTypeName);
                    if (type != null) {
                        JsonReader.processPrimitive(parser, writer, type, fieldNumber);
                        break;
                    }
                    GenericDescriptor descriptorByName = ctx.getDescriptorByName(topLevelTypeName);
                    if (descriptorByName instanceof EnumDescriptor) {
                        EnumDescriptor d = (EnumDescriptor)descriptorByName;
                        JsonReader.processEnum(parser, writer, d);
                        return true;
                    }
                    JsonReader.processObject(ctx, parser, writer, (Descriptor)descriptorByName, fieldNumber, messageDescriptor == null);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processObject(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, Descriptor messageDescriptor, Integer fieldNumber, boolean topLevel) throws IOException {
        JsonToken token;
        JsonReader.assertDescriptorField(messageDescriptor);
        RandomAccessOutputStreamImpl raos = new RandomAccessOutputStreamImpl(512);
        TagWriterImpl nestedWriter = TagWriterImpl.newInstance(ctx, raos);
        boolean isContainerAdapter = JsonHelper.isContainerAdapter(ctx, messageDescriptor);
        String currentField = null;
        block7: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    break block7;
                }
                case FIELD_NAME: {
                    currentField = parser.currentName();
                    break;
                }
                case START_ARRAY: {
                    FieldDescriptor fd;
                    if (!isContainerAdapter) {
                        fd = messageDescriptor.findFieldByName(currentField);
                        if (fd.isMap()) {
                            JsonReader.processMap(ctx, (MapDescriptor)fd, parser, nestedWriter);
                            break;
                        }
                        JsonReader.processArray(ctx, parser, nestedWriter, messageDescriptor.getFullName(), currentField, fd.getNumber());
                        break;
                    }
                    JsonReader.expectField("_value", currentField);
                    JsonReader.processArray(ctx, parser, nestedWriter, messageDescriptor.getFullName(), currentField, 17);
                    break;
                }
                case START_OBJECT: {
                    Integer nestedFieldNumber;
                    FieldDescriptor fd = messageDescriptor.findFieldByName(currentField);
                    if (fd.isMap()) {
                        JsonReader.processMap(ctx, (MapDescriptor)fd, parser, nestedWriter);
                        break;
                    }
                    Descriptor messageType = fd.getMessageType();
                    if (messageType == null && !JsonReader.isInternalFieldAndObject(fd.getNumber())) {
                        throw new IllegalStateException("Field '" + currentField + "' is not an object");
                    }
                    Integer n = nestedFieldNumber = fd.getLabel() == Label.ONE_OF ? null : Integer.valueOf(fd.getNumber());
                    if (messageType == null) {
                        JsonReader.processSingleDocument(ctx, parser, nestedWriter, messageType, nestedFieldNumber);
                        break;
                    }
                    JsonReader.processObject(ctx, parser, nestedWriter, messageType, nestedFieldNumber, false);
                    break;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    FieldDescriptor fd;
                    FieldDescriptor fieldDescriptor = fd = isContainerAdapter ? ((Descriptor)ctx.getDescriptorByTypeId(0)).findFieldByName(currentField) : messageDescriptor.findFieldByName(currentField);
                    if (fd == null) {
                        if ("_type".equals(currentField)) break;
                        throw new IllegalStateException("The field '" + currentField + "' was not found in the Protobuf schema");
                    }
                    if (fd.getType() == Type.ENUM) {
                        JsonReader.writeEnumField(parser, nestedWriter, fd, fd.getNumber());
                        break;
                    }
                    JsonReader.writeField(parser, nestedWriter, fd.getType(), fd.getNumber());
                }
            }
        }
        if (WrappedMessage.knownWrappedDescriptor(ctx, messageDescriptor)) {
            nestedWriter.flush();
            byte[] serialized = raos.toByteArray();
            writer.writeRawBytes(serialized, 0, serialized.length);
        } else if (topLevel) {
            Integer topLevelTypeId;
            nestedWriter.flush();
            byte[] nestedData = raos.toByteArray();
            RandomAccessOutputStreamImpl extraBuffer = null;
            TagWriter out = writer;
            if (fieldNumber != null) {
                extraBuffer = new RandomAccessOutputStreamImpl(nestedData.length + 128);
                out = TagWriterImpl.newInstance(ctx, extraBuffer);
            }
            if ((topLevelTypeId = messageDescriptor.getTypeId()) == null) {
                int tag = isContainerAdapter ? 28 : 16;
                out.writeString(tag, messageDescriptor.getFullName());
            } else {
                int tag = isContainerAdapter ? 29 : 19;
                out.writeUInt32(tag, topLevelTypeId);
            }
            if (isContainerAdapter) {
                out.writeRawBytes(nestedData, 0, nestedData.length);
            } else {
                out.writeBytes(17, nestedData);
            }
            if (fieldNumber != null) {
                out.flush();
                writer.writeBytes((int)fieldNumber, ((RandomAccessOutputStream)Objects.requireNonNull(extraBuffer)).toByteArray());
            }
        } else {
            nestedWriter.flush();
            writer.writeBytes((int)Objects.requireNonNull(fieldNumber), raos.toByteArray());
        }
        writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processArray(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, String type, String field, Integer fieldNumber) throws IOException {
        JsonToken token;
        while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_ARRAY: {
                    return;
                }
                case START_ARRAY: {
                    JsonReader.processArray(ctx, parser, writer, type, field, fieldNumber);
                    break;
                }
                case START_OBJECT: {
                    Descriptor d = (Descriptor)ctx.getDescriptorByName(type);
                    RandomAccessOutputStreamImpl raos = new RandomAccessOutputStreamImpl(512);
                    TagWriterImpl nestedWriter = TagWriterImpl.newInstance(ctx, raos);
                    JsonReader.processSingleDocument(ctx, parser, nestedWriter, d, fieldNumber);
                    nestedWriter.flush();
                    byte[] value = raos.toByteArray();
                    writer.writeRawBytes(value, 0, value.length);
                    break;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    Descriptor d = (Descriptor)ctx.getDescriptorByName(type);
                    FieldDescriptor fd = d.findFieldByName(field);
                    if (!fd.isRepeated()) {
                        if (token != JsonToken.VALUE_NUMBER_INT) throw new IllegalStateException("Field '" + fd.getName() + "' is not an array");
                        if (!Type.BYTES.equals((Object)fd.getType())) throw new IllegalStateException("Field '" + fd.getName() + "' is not an array");
                        ArrayList<Byte> result = new ArrayList<Byte>();
                        while (token == JsonToken.VALUE_NUMBER_INT) {
                            byte value = parser.getByteValue();
                            result.add(value);
                            token = parser.nextToken();
                        }
                        byte[] binary = new byte[result.size()];
                        int i = 0;
                        while (true) {
                            if (i >= result.size()) {
                                writer.writeBytes(fd.getNumber(), binary);
                                if (token != JsonToken.END_ARRAY) throw new IllegalStateException("Field '" + fd.getName() + "' is not an array");
                                return;
                            }
                            binary[i] = (Byte)result.get(i);
                            ++i;
                        }
                    }
                    if (fd.getType() == Type.ENUM) {
                        JsonReader.writeEnumField(parser, writer, fd, fd.getNumber());
                        break;
                    }
                    JsonReader.writeField(parser, writer, fd.getType(), fd.getNumber());
                }
            }
        }
        return;
    }

    private static void processEnum(JsonParser parser, TagWriter writer, EnumDescriptor enumDescriptor) throws IOException {
        JsonToken token;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case END_OBJECT: {
                    return;
                }
                case FIELD_NAME: {
                    continue block8;
                }
                case VALUE_STRING: {
                    String enumValueName = parser.getText();
                    EnumValueDescriptor enumValueDescriptor = enumDescriptor.findValueByName(enumValueName);
                    if (enumValueDescriptor == null) {
                        throw new IllegalStateException("Invalid enum value : '" + enumValueName + "'");
                    }
                    Integer topLevelTypeId = enumDescriptor.getTypeId();
                    if (topLevelTypeId == null) {
                        writer.writeString(16, enumDescriptor.getFullName());
                    } else {
                        writer.writeUInt32(19, topLevelTypeId);
                    }
                    writer.writeEnum(18, enumValueDescriptor.getNumber());
                    continue block8;
                }
                case VALUE_NUMBER_INT: {
                    int enumValueNumber = parser.getIntValue();
                    EnumValueDescriptor enumValueDescriptor = enumDescriptor.findValueByNumber(enumValueNumber);
                    if (enumValueDescriptor == null) {
                        throw new IllegalStateException("Invalid enum value : " + enumValueNumber);
                    }
                    Integer topLevelTypeId = enumDescriptor.getTypeId();
                    if (topLevelTypeId == null) {
                        writer.writeString(16, enumDescriptor.getFullName());
                    } else {
                        writer.writeUInt32(19, topLevelTypeId);
                    }
                    writer.writeEnum(18, enumValueDescriptor.getNumber());
                    continue block8;
                }
                case VALUE_NULL: {
                    throw new IllegalStateException("Invalid enum value 'null'");
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    throw new IllegalStateException("Invalid enum value '" + parser.getText() + "'");
                }
            }
            throw new IllegalStateException("Unexpected token : " + String.valueOf(token));
        }
    }

    private static void processMap(ImmutableSerializationContext ctx, MapDescriptor md, JsonParser parser, TagWriter writer) throws IOException {
        block17: while (true) {
            JsonToken token;
            if ((token = parser.nextToken()) == null) {
                return;
            }
            switch (token) {
                case END_OBJECT: {
                    break block17;
                }
                case FIELD_NAME: {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                    TagWriterImpl nestedWriter = TagWriterImpl.newInstance(ctx, baos);
                    String key = parser.currentName();
                    switch (md.getKeyType()) {
                        case STRING: {
                            nestedWriter.writeString(1, key);
                            break;
                        }
                        case INT32: {
                            nestedWriter.writeInt32(1, Integer.parseInt(key));
                            break;
                        }
                        case INT64: {
                            nestedWriter.writeInt64(1, Long.parseLong(key));
                            break;
                        }
                        case FIXED32: {
                            nestedWriter.writeFixed32(1, Integer.parseInt(key));
                            break;
                        }
                        case FIXED64: {
                            nestedWriter.writeFixed64(1, Long.parseLong(key));
                            break;
                        }
                        case SINT32: {
                            nestedWriter.writeSInt32(1, Integer.parseInt(key));
                            break;
                        }
                        case SINT64: {
                            nestedWriter.writeSInt64(1, Long.parseLong(key));
                            break;
                        }
                        case SFIXED32: {
                            nestedWriter.writeSFixed32(1, Integer.parseInt(key));
                            break;
                        }
                        case SFIXED64: {
                            nestedWriter.writeSFixed64(1, Long.parseLong(key));
                            break;
                        }
                        case UINT32: {
                            nestedWriter.writeUInt32(1, Integer.parseInt(key));
                            break;
                        }
                        case UINT64: {
                            nestedWriter.writeUInt64(1, Long.parseLong(key));
                        }
                    }
                    JsonReader.processMapValue(ctx, parser, nestedWriter, md);
                    writer.writeBytes(md.getNumber(), baos.toByteArray());
                    writer.flush();
                }
                default: {
                    continue block17;
                }
            }
            break;
        }
    }

    private static void processMapValue(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, MapDescriptor md) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == null) {
            return;
        }
        block0 : switch (token) {
            case START_OBJECT: {
                Descriptor descriptor = md.getMessageType();
                if (descriptor == null) {
                    JsonReader.processSingleDocument(ctx, parser, writer, null, 2);
                    break;
                }
                JsonReader.processObject(ctx, parser, writer, descriptor, 2, false);
                break;
            }
            case VALUE_STRING: {
                if (md.getType() == Type.ENUM) {
                    JsonReader.writeEnumField(parser, writer, md, 2);
                    break;
                }
                writer.writeString(2, parser.getValueAsString());
                break;
            }
            case VALUE_NUMBER_INT: {
                switch (md.getType()) {
                    case INT32: {
                        writer.writeInt32(2, parser.getIntValue());
                        break;
                    }
                    case INT64: {
                        writer.writeInt64(2, parser.getLongValue());
                        break;
                    }
                    case FIXED32: {
                        writer.writeFixed32(2, parser.getIntValue());
                        break;
                    }
                    case FIXED64: {
                        writer.writeFixed64(2, parser.getLongValue());
                        break;
                    }
                    case SINT32: {
                        writer.writeSInt32(2, parser.getIntValue());
                        break;
                    }
                    case SINT64: {
                        writer.writeSInt64(2, parser.getLongValue());
                        break;
                    }
                    case SFIXED32: {
                        writer.writeSFixed32(2, parser.getIntValue());
                        break;
                    }
                    case SFIXED64: {
                        writer.writeSFixed64(2, parser.getLongValue());
                        break;
                    }
                    case UINT32: {
                        writer.writeUInt32(2, parser.getIntValue());
                        break;
                    }
                    case UINT64: {
                        writer.writeUInt64(2, parser.getLongValue());
                    }
                }
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (md.getType()) {
                    case FLOAT: {
                        writer.writeFloat(2, parser.getFloatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        writer.writeDouble(2, parser.getDoubleValue());
                    }
                }
            }
        }
        writer.flush();
    }

    private static void readSingleField(ImmutableSerializationContext ctx, JsonParser parser, TagWriter writer, Descriptor messageDescriptor, String currentField, Integer outerFieldNumber) throws IOException {
        if (messageDescriptor == null) {
            Type type = Type.primitiveFromString(currentField);
            if (type == null) {
                JsonReader.expectField("_type", currentField);
            } else {
                JsonReader.processPrimitive(parser, writer, type, outerFieldNumber);
            }
            return;
        }
        FieldDescriptor fd = messageDescriptor.findFieldByName(currentField);
        if (fd == null) {
            Type type = Type.primitiveFromString(currentField);
            if (type == null) {
                JsonReader.expectField("_type", currentField);
            } else {
                JsonReader.processPrimitive(parser, writer, type, JsonHelper.isContainerAdapter(ctx, messageDescriptor) ? null : outerFieldNumber);
            }
            return;
        }
        JsonToken token = Objects.requireNonNull(parser.nextToken(), "Field name not followed by value");
        ByteArrayOutputStream baos = null;
        TagWriter out = writer;
        if (outerFieldNumber != null) {
            baos = new ByteArrayOutputStream(512);
            out = TagWriterImpl.newInstance(ctx, baos);
        }
        switch (token) {
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                if (fd.getType() == Type.ENUM) {
                    JsonReader.writeEnumField(parser, out, fd, fd.getNumber());
                } else {
                    JsonReader.writeField(parser, out, fd.getType(), fd.getNumber());
                }
                if (outerFieldNumber == null) break;
                out.flush();
                writer.writeBytes((int)outerFieldNumber, baos.toByteArray());
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid token after field name: " + String.valueOf(token));
            }
        }
    }

    private static void processPrimitive(JsonParser parser, TagWriter writer, Type fieldType, Integer fieldId) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == null) {
            return;
        }
        switch (token) {
            case END_OBJECT: {
                return;
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                JsonReader.writeField(parser, writer, fieldType, fieldId == null ? JsonReader.getPrimitiveFieldId(fieldType) : fieldId);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            case FIELD_NAME: {
                JsonReader.expectField("_value", parser.currentName());
                JsonReader.processPrimitive(parser, writer, fieldType, fieldId);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected JSON token: " + String.valueOf(token));
            }
        }
    }

    private static void writeEnumField(JsonParser parser, TagWriter writer, FieldDescriptor fd, int fieldNumber) throws IOException {
        String value = parser.getText();
        EnumDescriptor enumDescriptor = fd.getEnumType();
        EnumValueDescriptor valueDescriptor = enumDescriptor.findValueByName(value);
        if (valueDescriptor == null) {
            throw new IllegalStateException("Invalid enum value '" + value + "'");
        }
        int choice = valueDescriptor.getNumber();
        writer.writeEnum(fieldNumber, choice);
    }

    private static void writeField(JsonParser parser, TagWriter writer, Type fieldType, int fieldNumber) throws IOException {
        switch (fieldType) {
            case INT64: {
                writer.writeInt64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case SFIXED64: {
                writer.writeSFixed64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case SINT64: {
                writer.writeSInt64(fieldNumber, Long.parseLong(parser.getText()));
                break;
            }
            case UINT64: {
                writer.writeUInt64(fieldNumber, Long.parseUnsignedLong(parser.getText()));
                break;
            }
            case FIXED64: {
                writer.writeFixed64(fieldNumber, Long.parseUnsignedLong(parser.getText()));
                break;
            }
            case INT32: {
                writer.writeInt32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case SFIXED32: {
                writer.writeSFixed32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case SINT32: {
                writer.writeSInt32(fieldNumber, Integer.parseInt(parser.getText()));
                break;
            }
            case FIXED32: {
                writer.writeFixed32(fieldNumber, Integer.parseUnsignedInt(parser.getText()));
                break;
            }
            case UINT32: {
                writer.writeUInt32(fieldNumber, Integer.parseUnsignedInt(parser.getText()));
                break;
            }
            case DOUBLE: {
                writer.writeDouble(fieldNumber, Double.parseDouble(parser.getText()));
                break;
            }
            case FLOAT: {
                writer.writeFloat(fieldNumber, Float.parseFloat(parser.getText()));
                break;
            }
            case BOOL: {
                writer.writeBool(fieldNumber, parser.getBooleanValue());
                break;
            }
            case STRING: {
                writer.writeString(fieldNumber, parser.getText());
                break;
            }
            case BYTES: {
                writer.writeBytes(fieldNumber, parser.getBinaryValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + String.valueOf((Object)fieldType));
            }
        }
    }

    private static int getPrimitiveFieldId(Type primitiveType) {
        return switch (primitiveType) {
            case Type.DOUBLE -> 1;
            case Type.FLOAT -> 2;
            case Type.INT32 -> 5;
            case Type.INT64 -> 3;
            case Type.FIXED32 -> 7;
            case Type.FIXED64 -> 6;
            case Type.BOOL -> 8;
            case Type.STRING -> 9;
            case Type.BYTES -> 10;
            case Type.UINT32 -> 11;
            case Type.UINT64 -> 4;
            case Type.SFIXED32 -> 12;
            case Type.SFIXED64 -> 13;
            case Type.SINT32 -> 14;
            case Type.SINT64 -> 15;
            default -> throw new IllegalStateException("Unknown field type " + String.valueOf((Object)primitiveType));
        };
    }

    private static boolean isInternalFieldAndObject(int fieldNumber) {
        return fieldNumber == 17 || fieldNumber == 18;
    }

    private static void expectField(String expectedFieldName, String actualFieldName) {
        if (!expectedFieldName.equals(actualFieldName)) {
            throw new IllegalStateException(String.format("Expected field '%s' but it was '%s'", expectedFieldName, actualFieldName));
        }
    }

    private static void assertDescriptorField(Descriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        boolean invalidFields = descriptor.getFields().stream().anyMatch(f -> "_type".equals(f.getName()) || "_value".equals(f.getName()));
        if (invalidFields) {
            StringBuilder sb = new StringBuilder();
            for (FieldDescriptor f2 : descriptor.getFields()) {
                if (!"_type".equals(f2.getName()) && !"_value".equals(f2.getName())) continue;
                sb.append("Field number '").append(f2.getNumber()).append("' has reserved name '").append(f2.getName()).append("'").append(System.lineSeparator());
            }
            throw new IllegalStateException(String.format("Message for '%s' has reserved fields that makes conversion illegal: %n%s", descriptor.getFullName(), sb));
        }
    }
}

