/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.EnumContainer;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.MessageContainer;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.SchemaByBuilder;
import org.infinispan.protostream.schema.SchemaByString;
import org.infinispan.protostream.schema.Syntax;

public interface Schema {
    public String getName();

    public String getContent();

    @Deprecated
    public String toString();

    public static Schema buildFromStringContent(String schemaName, String schemaContent) {
        return new SchemaByString(schemaName, schemaContent);
    }

    public static class Builder
    implements CommentContainer<Builder>,
    MessageContainer,
    OptionContainer<Builder>,
    EnumContainer {
        Syntax syntax = Syntax.PROTO3;
        final String name;
        String packageName;
        final Map<String, Enum.Builder> enums = new HashMap<String, Enum.Builder>();
        final Map<String, Message.Builder> messages = new HashMap<String, Message.Builder>();
        final Map<String, Object> options = new HashMap<String, Object>();
        final List<String> comments = new ArrayList<String>();
        final List<String> dependencies = new ArrayList<String>();
        final List<String> publicDependencies = new ArrayList<String>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder syntax(Syntax syntax) {
            this.syntax = syntax;
            return this;
        }

        public Builder addImport(String i) {
            this.dependencies.add(i);
            return this;
        }

        public Builder addPublicImport(String i) {
            this.publicDependencies.add(i);
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        @Override
        public Builder addOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        @Override
        public Enum.Builder addEnum(String name) {
            this.checkDuplicate(name);
            Enum.Builder e = new Enum.Builder(this, name);
            this.enums.put(name, e);
            return e;
        }

        @Override
        public Message.Builder addMessage(String name) {
            this.checkDuplicate(name);
            Message.Builder message = new Message.Builder(this, name);
            this.messages.put(name, message);
            return message;
        }

        @Override
        public Builder addComment(String comment) {
            this.comments.add(comment.trim());
            return this;
        }

        @Override
        public Schema build() {
            return new SchemaByBuilder(this);
        }

        @Override
        public String getFullName() {
            return Objects.requireNonNullElse(this.packageName, "");
        }

        private void checkDuplicate(String name) {
            if (this.messages.containsKey(name) || this.enums.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate name " + name);
            }
        }
    }
}

