/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.session.web.http.HttpSessionIdResolver;

public class CompositeHttpSessionIdResolver
implements HttpSessionIdResolver {
    private final HttpSessionIdResolver[] resolvers;

    public CompositeHttpSessionIdResolver(HttpSessionIdResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public List<String> resolveSessionIds(HttpServletRequest request) {
        return Stream.of(this.resolvers).flatMap(resolver -> resolver.resolveSessionIds(request).stream()).distinct().toList();
    }

    @Override
    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        for (HttpSessionIdResolver resolver : this.resolvers) {
            resolver.setSessionId(request, response, sessionId);
        }
    }

    @Override
    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        for (HttpSessionIdResolver resolver : this.resolvers) {
            resolver.expireSession(request, response);
        }
    }
}

