/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

public class Event {
    public static final int CONNECT = 2;
    public static final int DISCONNECT = 4;
    public static final int VIEW_CHANGE = 6;
    public static final int SUSPECT = 9;
    public static final int FIND_MBRS = 11;
    public static final int FIND_INITIAL_MBRS = 12;
    public static final int FIND_MBRS_ASYNC = 13;
    public static final int MERGE = 14;
    public static final int TMP_VIEW = 15;
    public static final int BECOME_SERVER = 16;
    public static final int GET_APPLSTATE = 17;
    public static final int GET_STATE = 19;
    public static final int GET_STATE_OK = 20;
    public static final int STABLE = 30;
    public static final int GET_DIGEST = 39;
    public static final int SET_DIGEST = 41;
    public static final int OVERWRITE_DIGEST = 42;
    public static final int UNSUSPECT = 51;
    public static final int MERGE_DIGEST = 53;
    public static final int CONFIG = 56;
    public static final int SUSPEND_STABLE = 65;
    public static final int RESUME_STABLE = 66;
    public static final int STATE_TRANSFER_INPUTSTREAM = 71;
    public static final int STATE_TRANSFER_OUTPUTSTREAM = 72;
    public static final int STATE_TRANSFER_INPUTSTREAM_CLOSED = 73;
    public static final int CLOSE_BARRIER = 76;
    public static final int OPEN_BARRIER = 77;
    public static final int CONNECT_WITH_STATE_TRANSFER = 80;
    public static final int GET_PHYSICAL_ADDRESS = 87;
    public static final int GET_LOGICAL_PHYSICAL_MAPPINGS = 88;
    public static final int ADD_PHYSICAL_ADDRESS = 89;
    public static final int REMOVE_ADDRESS = 90;
    public static final int GET_LOCAL_ADDRESS = 91;
    public static final int IS_MERGE_IN_PROGRESS = 100;
    public static final int GET_PHYSICAL_ADDRESSES = 102;
    public static final int SITE_UNREACHABLE = 104;
    public static final int MBR_UNREACHABLE = 105;
    public static final int PUNCH_HOLE = 106;
    public static final int CLOSE_HOLE = 107;
    public static final int GET_VIEW_FROM_COORD = 108;
    public static final int GET_PING_DATA = 109;
    public static final int GET_SECRET_KEY = 111;
    public static final int SET_SECRET_KEY = 112;
    public static final int INSTALL_MERGE_VIEW = 114;
    public static final int IS_LOCAL_SITEMASTER = 115;
    public static final int IS_LOCAL = 116;
    public static final int USER_DEFINED = 1000;
    public static final Event GET_DIGEST_EVT = new Event(39);
    private final int type;
    private final Object arg;

    public Event(int type) {
        this.type = type;
        this.arg = null;
    }

    public Event(int type, Object arg) {
        this.type = type;
        this.arg = arg;
    }

    public int type() {
        return this.type;
    }

    public int getType() {
        return this.type;
    }

    public <T> T arg() {
        return (T)this.arg;
    }

    public <T> T getArg() {
        return (T)this.arg;
    }

    public static String type2String(int t) {
        return switch (t) {
            case 2 -> "CONNECT";
            case 4 -> "DISCONNECT";
            case 6 -> "VIEW_CHANGE";
            case 9 -> "SUSPECT";
            case 11 -> "FIND_MBRS";
            case 12 -> "FIND_INITIAL_MBRS";
            case 13 -> "FIND_MBRS_ASYNC";
            case 15 -> "TMP_VIEW";
            case 16 -> "BECOME_SERVER";
            case 17 -> "GET_APPLSTATE";
            case 19 -> "GET_STATE";
            case 20 -> "GET_STATE_OK";
            case 30 -> "STABLE";
            case 39 -> "GET_DIGEST";
            case 41 -> "SET_DIGEST";
            case 42 -> "OVERWRITE_DIGEST";
            case 14 -> "MERGE";
            case 51 -> "UNSUSPECT";
            case 53 -> "MERGE_DIGEST";
            case 56 -> "CONFIG";
            case 65 -> "SUSPEND_STABLE";
            case 66 -> "RESUME_STABLE";
            case 71 -> "STATE_TRANSFER_INPUTSTREAM";
            case 72 -> "STATE_TRANSFER_OUTPUTSTREAM";
            case 73 -> "STATE_TRANSFER_INPUTSTREAM_CLOSED";
            case 76 -> "CLOSE_BARRIER";
            case 77 -> "OPEN_BARRIER";
            case 80 -> "CONNECT_WITH_STATE_TRANSFER";
            case 87 -> "GET_PHYSICAL_ADDRESS";
            case 88 -> "GET_LOGICAL_PHYSICAL_MAPPINGS";
            case 89 -> "ADD_PHYSICAL_ADDRESS";
            case 90 -> "REMOVE_ADDRESS";
            case 91 -> "GET_LOCAL_ADDRESS";
            case 100 -> "IS_MERGE_IN_PROGRESS";
            case 102 -> "GET_PHYSICAL_ADDRESSES";
            case 104 -> "SITE_UNREACHABLE";
            case 105 -> "MBR_UNREACHABLE";
            case 106 -> "PUNCH_HOLE";
            case 107 -> "CLOSE_HOLE";
            case 108 -> "GET_VIEW_FROM_COORD";
            case 109 -> "GET_PING_DATA";
            case 111 -> "GET_SECRET_KEY";
            case 112 -> "SET_SECRET_KEY";
            case 114 -> "INSTALL_MERGE_VIEW";
            case 115 -> "IS_LOCAL_SITEMASTER";
            case 116 -> "IS_LOCAL";
            case 1000 -> "USER_DEFINED";
            default -> "UNDEFINED(" + t + ")";
        };
    }

    public String toString() {
        return String.format("%s, arg=%s", Event.type2String(this.type), this.arg);
    }
}

