/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.util.Util;

public class Version {
    public static final short major;
    public static final short minor;
    public static final short micro;
    public static final String description;
    public static final short version;
    public static final String string_version;
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int MICRO_MASK = 63;
    public static final String VERSION_FILE = "JGROUPS_VERSION.properties";
    public static final String VERSION_PROPERTY = "jgroups.version";
    public static final String CODENAME = "jgroups.codename";
    private static final Pattern VERSION_REGEXP;
    private static boolean VERSION_CHECK;
    private static boolean VERSION_CHECK_MICRO;

    public static void initConfig() {
        String versionCheckMicro;
        String s = Util.getProperty("jgroups.version.check");
        if (s != null) {
            VERSION_CHECK = Boolean.parseBoolean(s);
        }
        if ((versionCheckMicro = Util.getProperty("jgroups.version.check.micro")) != null) {
            VERSION_CHECK_MICRO = Boolean.parseBoolean(versionCheckMicro);
        }
    }

    public static short getMajor() {
        return major;
    }

    public static short getMinor() {
        return minor;
    }

    public static short getMicro() {
        return micro;
    }

    public static short getMajor(short v) {
        return (short)((v & 0xF800) >> 11);
    }

    public static short getMinor(short v) {
        return (short)((v & 0x7C0) >> 6);
    }

    public static short getMicro(short v) {
        return (short)(v & 0x3F);
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!"-incr".equals(args[i])) continue;
            String old_version = args[++i];
            String new_version = Version.incrementVersion(old_version);
            System.out.print(new_version);
            return;
        }
        System.out.println("Version: " + description);
    }

    public static String printDescription() {
        return "JGroups " + description;
    }

    public static String printVersion() {
        return string_version;
    }

    public static boolean isSame(short v) {
        return version == v;
    }

    public static short encode(int major, int minor, int micro) {
        return (short)((major << 11) + (minor << 6) + micro);
    }

    public static String print(short version) {
        short major = Version.getMajor(version);
        short minor = Version.getMinor(version);
        short micro = Version.getMicro(version);
        return major + "." + minor + "." + micro;
    }

    public static short parse(String ver) {
        try {
            Matcher versionMatcher = VERSION_REGEXP.matcher(ver);
            versionMatcher.find();
            short maj = Short.parseShort(versionMatcher.group(2));
            short min = Short.parseShort(versionMatcher.group(3));
            short mic = Short.parseShort(versionMatcher.group(4));
            return Version.encode(maj, min, mic);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format("failed parsing version '%s': %s", ver, t));
        }
    }

    public static short[] decode(short version) {
        short major = (short)((version & 0xF800) >> 11);
        short minor = (short)((version & 0x7C0) >> 6);
        short micro = (short)(version & 0x3F);
        return new short[]{major, minor, micro};
    }

    public static boolean isBinaryCompatible(short ver) {
        if (!VERSION_CHECK || version == ver) {
            return true;
        }
        if (VERSION_CHECK_MICRO) {
            return false;
        }
        short tmp_major = (short)((ver & 0xF800) >> 11);
        short tmp_minor = (short)((ver & 0x7C0) >> 6);
        return major == tmp_major && minor == tmp_minor;
    }

    public static boolean isBinaryCompatible(short ver1, short ver2) {
        if (!VERSION_CHECK || ver1 == ver2) {
            return true;
        }
        if (VERSION_CHECK_MICRO) {
            return false;
        }
        short[] tmp = Version.decode(ver1);
        short tmp_major = tmp[0];
        short tmp_minor = tmp[1];
        tmp = Version.decode(ver2);
        short tmp_major2 = tmp[0];
        short tmp_minor2 = tmp[1];
        return tmp_major == tmp_major2 && tmp_minor == tmp_minor2;
    }

    public static String incrementVersion(String version) {
        return Version.incrementVersion(version, false);
    }

    public static String incrementVersion(String version, boolean add_snapshot) {
        boolean final_present = version.contains("Final");
        short[] decoded = Version.decode(Version.parse(version));
        decoded[2] = (short)(decoded[2] + 1);
        short new_version = Version.encode(decoded[0], decoded[1], decoded[2]);
        return String.format("%s%s%s", Version.print(new_version), final_present ? ".Final" : "", add_snapshot ? "-SNAPSHOT" : "");
    }

    static {
        VERSION_REGEXP = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+).*)");
        VERSION_CHECK = true;
        VERSION_CHECK_MICRO = false;
        String ver = null;
        String codename = "n/a";
        InputStream version_file = null;
        try {
            version_file = Util.getResourceAsStream(VERSION_FILE, Version.class);
            if (version_file == null) {
                throw new FileNotFoundException(VERSION_FILE);
            }
            Properties properties = new Properties();
            properties.load(version_file);
            ver = properties.getProperty(VERSION_PROPERTY);
            if (ver == null) {
                throw new RuntimeException("value for jgroups.version not found in JGROUPS_VERSION.properties");
            }
            codename = properties.getProperty(CODENAME, "n/a");
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("%s not found; make sure it is in the classpath", VERSION_FILE));
        }
        finally {
            Util.close((Closeable)version_file);
        }
        try {
            Matcher versionMatcher = VERSION_REGEXP.matcher(ver);
            versionMatcher.find();
            description = String.format("%s (%s)", ver, codename);
            major = Short.parseShort(versionMatcher.group(2));
            minor = Short.parseShort(versionMatcher.group(3));
            micro = Short.parseShort(versionMatcher.group(4));
            version = Version.encode(major, minor, micro);
            string_version = Version.print(version);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("failed parsing %s (%s correct?)", ver, VERSION_FILE), e);
        }
        Version.initConfig();
    }
}

