/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class NakAckHeader
extends Header {
    public static final byte MSG = 1;
    public static final byte XMIT_REQ = 2;
    public static final byte XMIT_RSP = 3;
    public static final byte HIGHEST_SEQNO = 4;
    public static final byte ACK = 5;
    protected byte type;
    protected long seqno = -1L;
    protected Address sender;

    public NakAckHeader() {
    }

    @Override
    public short getMagicId() {
        return 99;
    }

    @Override
    public Supplier<? extends Header> create() {
        return NakAckHeader::new;
    }

    public static NakAckHeader createMessageHeader(long seqno) {
        return new NakAckHeader(1, seqno);
    }

    public static NakAckHeader createXmitRequestHeader(Address orginal_sender) {
        return new NakAckHeader(2, orginal_sender);
    }

    public static NakAckHeader createXmitResponseHeader() {
        return new NakAckHeader(3, -1L);
    }

    public static NakAckHeader createHighestSeqnoHeader(long seqno) {
        return new NakAckHeader(4, seqno);
    }

    public static NakAckHeader createAckHeader(long ack) {
        return new NakAckHeader(5, ack);
    }

    private NakAckHeader(byte type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    private NakAckHeader(byte type, Address sender) {
        this.type = type;
        this.sender = sender;
    }

    public byte getType() {
        return this.type;
    }

    public byte type() {
        return this.type;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public Address getSender() {
        return this.sender;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                Bits.writeLongCompressed(this.seqno, out);
                break;
            }
            case 2: {
                Util.writeAddress(this.sender, out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                this.seqno = Bits.readLongCompressed(in);
                break;
            }
            case 2: {
                this.sender = Util.readAddress(in);
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = 1;
        return switch (this.type) {
            case 1, 3, 4, 5 -> retval + Bits.size(this.seqno);
            case 2 -> retval + Util.size(this.sender);
            default -> retval;
        };
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader();
        ret.type = this.type;
        ret.seqno = this.seqno;
        ret.sender = this.sender;
        return ret;
    }

    public static String type2Str(byte t) {
        return switch (t) {
            case 1 -> "MSG";
            case 2 -> "XMIT_REQ";
            case 3 -> "XMIT_RSP";
            case 4 -> "HIGHEST_SEQNO";
            case 5 -> "ACK";
            default -> "<undefined>";
        };
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(NakAckHeader.type2Str(this.type));
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                ret.append(", seqno=").append(this.seqno);
                break;
            }
        }
        if (this.sender != null) {
            ret.append(", sender=").append(this.sender);
        }
        return ret.toString();
    }
}

