/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractFunctionalMap<K, V>
implements FunctionalMap<K, V> {
    private static final Log log = LogFactory.getLog(FunctionalMap.class);
    protected final FunctionalMapImpl<K, V> fmap;
    protected final Params params;
    private final boolean transactional;
    private final boolean autoCommit;
    private final BatchContainer batchContainer;
    private final TransactionManager transactionManager;
    protected final DataConversion keyDataConversion;
    protected final DataConversion valueDataConversion;
    private final BlockingManager blockingManager;

    protected AbstractFunctionalMap(Params params, FunctionalMapImpl<K, V> fmap) {
        this.fmap = fmap;
        Configuration config = SecurityActions.getCacheConfiguration(fmap.cache);
        this.transactional = config.transaction().transactionMode().isTransactional();
        this.autoCommit = config.transaction().autoCommit();
        this.transactionManager = this.transactional ? fmap.cache.getTransactionManager() : null;
        this.batchContainer = this.transactional && config.invocationBatching().enabled() ? fmap.cache.getBatchContainer() : null;
        this.params = params;
        this.keyDataConversion = fmap.cache.getKeyDataConversion();
        this.valueDataConversion = fmap.cache.getValueDataConversion();
        this.blockingManager = SecurityActions.getCacheComponentRegistry(fmap.cache).getComponent(BlockingManager.class);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public ComponentStatus getStatus() {
        return this.fmap.getStatus();
    }

    @Override
    public void close() throws Exception {
        this.fmap.close();
    }

    @Override
    public Cache<K, V> cache() {
        return this.fmap.cache();
    }

    protected InvocationContext getInvocationContext(boolean isWrite, int keyCount) {
        InvocationContext invocationContext;
        if (this.fmap.delegateContextCreation()) {
            return this.fmap.createInvocationContext(isWrite, keyCount);
        }
        boolean txInjected = false;
        if (this.transactional) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.autoCommit && this.transactionManager != null) {
                try {
                    this.transactionManager.begin();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
                }
                transaction = this.getOngoingTransaction();
                txInjected = true;
            }
            invocationContext = this.fmap.invCtxFactory.createInvocationContext(transaction, txInjected);
        } else {
            invocationContext = this.fmap.invCtxFactory.createInvocationContext(isWrite, keyCount);
        }
        if (isWrite && this.fmap.lockOwner != null) {
            invocationContext.setLockOwner(this.fmap.lockOwner);
        }
        return invocationContext;
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.batchContainer != null) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    protected <T> CompletableFuture<T> invokeAsync(InvocationContext ctx, VisitableCommand cmd) {
        CompletableFuture<Object> cf;
        Transaction implicitTransaction;
        boolean isImplicitTx = ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
        try {
            if (isImplicitTx) {
                implicitTransaction = this.transactionManager.suspend();
                assert (implicitTransaction != null);
            } else {
                implicitTransaction = null;
            }
            cf = this.fmap.chain.invokeAsync(ctx, cmd);
        }
        catch (SystemException e) {
            throw new CacheException("Cannot suspend implicit transaction", (Throwable)e);
        }
        catch (Throwable t) {
            if (isImplicitTx) {
                try {
                    if (this.transactionManager != null) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Throwable t2) {
                    log.trace("Could not rollback", t2);
                    t.addSuppressed(t2);
                }
            }
            throw t;
        }
        if (isImplicitTx) {
            return this.blockingManager.handleBlocking(cf, (result, throwable) -> {
                if (throwable != null) {
                    try {
                        implicitTransaction.rollback();
                    }
                    catch (SystemException e) {
                        log.trace("Could not rollback", e);
                        throwable.addSuppressed(e);
                    }
                    throw CompletableFutures.asCompletionException((Throwable)throwable);
                }
                try {
                    implicitTransaction.commit();
                }
                catch (Exception e) {
                    log.couldNotCompleteInjectedTransaction(e);
                    throw CompletableFutures.asCompletionException((Throwable)e);
                }
                return result;
            }, ctx.getLockOwner()).toCompletableFuture();
        }
        return cf;
    }

    protected Set<?> encodeKeys(Set<? extends K> keys) {
        return keys.stream().map(k -> this.keyDataConversion.toStorage(k)).collect(Collectors.toSet());
    }

    protected Map<?, ?> encodeEntries(Map<? extends K, ?> entries) {
        HashMap encodedEntries = new HashMap();
        entries.entrySet().forEach(e -> {
            Object keyEncoded = this.keyDataConversion.toStorage(e.getKey());
            Object valueEncoded = this.valueDataConversion.toStorage(e.getValue());
            encodedEntries.put(keyEncoded, valueEncoded);
        });
        return encodedEntries;
    }
}

