/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.security.impl.Authorizer;

public class DefaultCacheManagerAdmin
implements EmbeddedCacheManagerAdmin {
    private final EmbeddedCacheManager cacheManager;
    private final GlobalConfigurationManager clusterConfigurationManager;
    private final Authorizer authorizer;
    private final EnumSet<CacheContainerAdmin.AdminFlag> flags;
    private final Subject subject;

    DefaultCacheManagerAdmin(EmbeddedCacheManager cm, Authorizer authorizer, EnumSet<CacheContainerAdmin.AdminFlag> flags, Subject subject, GlobalConfigurationManager clusterConfigurationManager) {
        this.cacheManager = cm;
        this.authorizer = authorizer;
        this.clusterConfigurationManager = clusterConfigurationManager;
        this.flags = flags;
        this.subject = subject;
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, configuration, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> createCache(String cacheName, String template) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, String template) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, template, this.flags));
        return this.cacheManager.getCache(cacheName);
    }

    @Override
    public void createTemplate(String name, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.createTemplate(name, configuration, this.flags));
    }

    @Override
    public Configuration getOrCreateTemplate(String name, Configuration configuration) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateTemplate(name, configuration, this.flags));
        return this.cacheManager.getCacheConfiguration(name);
    }

    @Override
    public void removeTemplate(String name) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.removeTemplate(name, this.flags));
    }

    public void removeCache(String cacheName) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        CompletionStages.join(this.clusterConfigurationManager.removeCache(cacheName, this.flags));
    }

    public EmbeddedCacheManagerAdmin withFlags(CacheContainerAdmin.AdminFlag ... flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        Collections.addAll(newFlags, flags);
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, newFlags, this.subject, this.clusterConfigurationManager);
    }

    public EmbeddedCacheManagerAdmin withFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        EnumSet<CacheContainerAdmin.AdminFlag> newFlags = EnumSet.copyOf(this.flags);
        newFlags.addAll(flags);
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, newFlags, this.subject, this.clusterConfigurationManager);
    }

    @Override
    public EmbeddedCacheManagerAdmin withSubject(Subject subject) {
        return new DefaultCacheManagerAdmin(this.cacheManager, this.authorizer, this.flags, subject, this.clusterConfigurationManager);
    }

    @Override
    public void updateConfigurationAttribute(String cacheName, String attributeName, String attributeValue) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        BasicCache cache = this.cacheManager.getCache(cacheName);
        Configuration config = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        Attribute attribute = config.findAttribute(attributeName);
        attribute.fromString(attributeValue);
        Object newFlags = this.flags.clone();
        ((AbstractCollection)newFlags).add(CacheContainerAdmin.AdminFlag.UPDATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, config, (EnumSet<CacheContainerAdmin.AdminFlag>)newFlags));
    }

    public void assignAlias(String aliasName, String cacheName) {
        this.authorizer.checkPermission(this.subject, AuthorizationPermission.CREATE);
        BasicCache cache = this.cacheManager.getCache(cacheName);
        BasicCache oldAliased = this.cacheManager.getCache(aliasName);
        Configuration config = cache.getCacheConfiguration();
        Attribute attribute = config.attributes().attribute(Configuration.ALIASES);
        HashSet<String> aliases = new HashSet<String>((Collection)attribute.get());
        aliases.add(aliasName);
        attribute.set(aliases);
        Object newFlags = this.flags.clone();
        ((AbstractCollection)newFlags).add(CacheContainerAdmin.AdminFlag.UPDATE);
        CompletionStages.join(this.clusterConfigurationManager.getOrCreateCache(cacheName, config, (EnumSet<CacheContainerAdmin.AdminFlag>)newFlags).thenCompose(arg_0 -> this.lambda$assignAlias$0((Cache)oldAliased, arg_0)));
    }

    private CompletionStage<Void> removeOldAlias(Cache<?, ?> assigned) {
        if (assigned == null) {
            return CompletableFutures.completedNull();
        }
        Configuration configuration = assigned.getCacheConfiguration();
        Object newFlags = this.flags.clone();
        ((AbstractCollection)newFlags).add(CacheContainerAdmin.AdminFlag.UPDATE);
        return this.clusterConfigurationManager.getOrCreateCache(assigned.getName(), configuration, (EnumSet<CacheContainerAdmin.AdminFlag>)newFlags).thenApply(CompletableFutures.toNullFunction());
    }

    private /* synthetic */ CompletionStage lambda$assignAlias$0(Cache oldAliased, Configuration ignore) {
        return this.removeOldAlias(oldAliased);
    }
}

