/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public interface RandomAccessOutputStream
extends Closeable {
    public int getPosition();

    public void setPosition(int var1);

    public void ensureCapacity(int var1);

    default public void reset() {
        this.setPosition(0);
    }

    public ByteBuffer getByteBuffer();

    public byte[] toByteArray();

    public byte get(int var1);

    default public void write(int b) throws IOException {
        this.write(this.getPosition(), b);
    }

    default public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    default public void write(byte[] b, int off, int len) throws IOException {
        this.write(this.getPosition(), b, off, len);
    }

    public void write(int var1, int var2) throws IOException;

    default public void write(int position, byte[] b) throws IOException {
        this.write(position, b, 0, b.length);
    }

    public void write(int var1, byte[] var2, int var3, int var4) throws IOException;

    public void move(int var1, int var2, int var3);

    public void copyTo(DataOutput var1) throws IOException;

    default public void writeFixed32Direct(int position, int value) throws IOException {
        this.write(position, (byte)value);
        this.write(position + 1, (byte)(value >> 8));
        this.write(position + 2, (byte)(value >> 16));
        this.write(position + 3, (byte)(value >> 24));
    }

    default public void writeFixed64Direct(int position, long value) throws IOException {
        this.write(position, (byte)value);
        this.write(position + 1, (byte)(value >> 8));
        this.write(position + 2, (byte)(value >> 16));
        this.write(position + 3, (byte)(value >> 24));
        this.write(position + 4, (byte)(value >> 32));
        this.write(position + 5, (byte)(value >> 40));
        this.write(position + 6, (byte)(value >> 48));
        this.write(position + 7, (byte)(value >> 56));
    }
}

