/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoComment;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.ProtoSyntax;
import org.infinispan.protostream.annotations.ProtoUnknownFieldSet;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMapMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ReservedProcessor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMember;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XRecordComponent;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.containers.IndexedElementContainer;
import org.infinispan.protostream.containers.IndexedElementContainerAdapter;
import org.infinispan.protostream.containers.IterableElementContainer;
import org.infinispan.protostream.containers.IterableElementContainerAdapter;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.Log;

public class ProtoMessageTypeMetadata
extends ProtoTypeMetadata {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Log log = Log.LogFactory.getLog(ProtoMessageTypeMetadata.class);
    private final BaseProtoSchemaGenerator protoSchemaGenerator;
    protected final XTypeFactory typeFactory;
    private SortedMap<Integer, ProtoFieldMetadata> fieldsByNumber = null;
    private final XClass annotatedClass;
    private final boolean isAdapter;
    private final boolean isIndexedContainer;
    private final boolean isIterableContainer;
    private final boolean isOrderedMarshallable;
    private XExecutable factory;
    private XField unknownFieldSetField;
    private XMethod unknownFieldSetGetter;
    private XMethod unknownFieldSetSetter;
    private final Map<XClass, ProtoTypeMetadata> innerTypes = new HashMap<XClass, ProtoTypeMetadata>();

    protected ProtoMessageTypeMetadata(BaseProtoSchemaGenerator protoSchemaGenerator, XClass annotatedClass, XClass javaClass) {
        super(ProtoMessageTypeMetadata.getProtoName(annotatedClass, javaClass), javaClass);
        this.protoSchemaGenerator = protoSchemaGenerator;
        this.annotatedClass = annotatedClass;
        this.typeFactory = annotatedClass.getFactory();
        this.isAdapter = javaClass != annotatedClass;
        this.isIndexedContainer = annotatedClass.isAssignableTo(this.isAdapter ? IndexedElementContainerAdapter.class : IndexedElementContainer.class);
        this.isIterableContainer = annotatedClass.isAssignableTo(this.isAdapter ? IterableElementContainerAdapter.class : IterableElementContainer.class);
        this.isOrderedMarshallable = protoSchemaGenerator.orderedMarshaller();
        this.checkInstantiability();
        this.validateName();
    }

    private static String getProtoName(XClass annotatedClass, XClass javaClass) {
        XClass clazz = javaClass.isInterface() ? annotatedClass : javaClass;
        ProtoName annotation = annotatedClass.getAnnotation(ProtoName.class);
        if (annotation != null) {
            return annotation.value().isEmpty() ? clazz.getSimpleName() : annotation.value();
        }
        return clazz.getSimpleName();
    }

    @Override
    public XClass getAnnotatedClass() {
        return this.annotatedClass;
    }

    @Override
    public boolean isAdapter() {
        return this.isAdapter;
    }

    public boolean isIndexedContainer() {
        return this.isIndexedContainer;
    }

    public boolean isIterableContainer() {
        return this.isIterableContainer;
    }

    public boolean isContainer() {
        return this.isIterableContainer || this.isIndexedContainer;
    }

    public boolean isOrderedMarshallable() {
        return this.isOrderedMarshallable;
    }

    public XExecutable getFactory() {
        this.scanMemberAnnotations();
        return this.factory;
    }

    public XField getUnknownFieldSetField() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetField;
    }

    public XMethod getUnknownFieldSetGetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetGetter;
    }

    public XMethod getUnknownFieldSetSetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetSetter;
    }

    public SortedMap<Integer, ProtoFieldMetadata> getFields() {
        this.scanMemberAnnotations();
        return this.fieldsByNumber;
    }

    protected void addInnerType(ProtoTypeMetadata typeMetadata) {
        this.innerTypes.put(typeMetadata.getJavaClass(), typeMetadata);
    }

    @Override
    public void generateProto(IndentWriter iw, ProtoSyntax syntax) {
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoMessageTypeMetadata.appendDocumentation(iw, this.getDocumentation());
        iw.append("message ").append(this.name);
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.getJavaClassName()).append(" */");
        }
        iw.append(" {\n");
        iw.inc();
        ReservedProcessor reserved = new ReservedProcessor();
        reserved.scan(this.annotatedClass);
        Iterator<Object> iterator = this.fieldsByNumber.keySet().iterator();
        while (iterator.hasNext()) {
            int memberNumber = iterator.next();
            ProtoFieldMetadata field = (ProtoFieldMetadata)this.fieldsByNumber.get(memberNumber);
            XClass where = reserved.checkReserved(memberNumber);
            if (where != null) {
                throw Log.LOG.reservedNumber(memberNumber, field.getName(), where.getCanonicalName());
            }
            where = reserved.checkReserved(field.getName());
            if (where == null) continue;
            throw Log.LOG.reservedName(field.getName(), where.getCanonicalName());
        }
        reserved.generate(iw);
        for (ProtoTypeMetadata t : this.innerTypes.values()) {
            t.generateProto(iw, syntax);
        }
        LinkedList<ProtoFieldMetadata> unprocessedFields = new LinkedList<ProtoFieldMetadata>(this.fieldsByNumber.values());
        while (!unprocessedFields.isEmpty()) {
            ProtoFieldMetadata f = unprocessedFields.remove();
            if (f.getOneof() == null) {
                f.generateProto(iw, syntax);
                continue;
            }
            iw.append("\noneof ").append(f.getOneof()).append(" {\n");
            iw.inc();
            f.generateProto(iw, syntax);
            Iterator it = unprocessedFields.iterator();
            while (it.hasNext()) {
                ProtoFieldMetadata f2 = (ProtoFieldMetadata)it.next();
                if (!f.getOneof().equals(f2.getOneof())) continue;
                f2.generateProto(iw, syntax);
                it.remove();
            }
            iw.dec();
            iw.append("}\n");
        }
        iw.dec();
        iw.append("}\n");
    }

    @Override
    public final boolean isEnum() {
        return false;
    }

    @Override
    public final ProtoEnumValueMetadata getEnumMemberByName(String name) {
        throw new IllegalStateException(this.getJavaClassName() + " is not an enum");
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByNumber(int number) {
        throw new IllegalStateException(this.getJavaClassName() + " is not an enum");
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.fieldsByNumber == null) {
            this.fieldsByNumber = new TreeMap<Integer, ProtoFieldMetadata>();
            HashMap<String, ProtoFieldMetadata> fieldsByName = new HashMap<String, ProtoFieldMetadata>();
            HashSet<String> oneofs = new HashSet<String>();
            this.discoverFields(this.annotatedClass, new HashSet<XClass>(), this.fieldsByNumber, fieldsByName, oneofs);
            if (this.fieldsByNumber.isEmpty()) {
                log.warnf("Class %s does not have any @ProtoField annotated members. The class should be either annotated or it should have a custom marshaller.", this.getAnnotatedClassName());
            }
            if (this.factory != null && !this.javaClass.isRecord()) {
                String[] parameterNames;
                String factoryKind = this.factory instanceof XConstructor ? "constructor" : (this.factory.isStatic() ? "static method" : "method");
                XClass[] parameterTypes = this.factory.getParameterTypes();
                int startPos = 0;
                if (this.isIndexedContainer || this.isIterableContainer) {
                    if (parameterTypes.length == 0 || parameterTypes[0] != this.typeFactory.fromClass(Integer.TYPE)) {
                        throw Log.LOG.factorySignatureMismatch(factoryKind, this.factory.toGenericString());
                    }
                    startPos = 1;
                }
                if ((parameterNames = this.factory.getParameterNames()).length != this.fieldsByNumber.size() + startPos) {
                    throw Log.LOG.factorySignatureMismatch(factoryKind, this.fieldsByNumber.size() + startPos, parameterNames.length, this.factory.toGenericString());
                }
                while (startPos < parameterNames.length) {
                    String parameterName = parameterNames[startPos];
                    ProtoFieldMetadata fieldMetadata = this.getFieldByPropertyName(parameterName);
                    if (fieldMetadata == null) {
                        throw Log.LOG.factorySignatureMismatch(factoryKind, parameterName, this.factory.toGenericString());
                    }
                    XClass parameterType = parameterTypes[startPos];
                    boolean paramTypeMismatch = false;
                    if (fieldMetadata.isArray()) {
                        if (!parameterType.isArray() || parameterType.getComponentType() != fieldMetadata.getJavaType()) {
                            paramTypeMismatch = true;
                        }
                    } else if (fieldMetadata.isRepeated()) {
                        if (!fieldMetadata.isStream() && !fieldMetadata.getRepeatedImplementation().isAssignableTo(parameterType)) {
                            paramTypeMismatch = true;
                        }
                    } else if (fieldMetadata.getJavaType() != parameterType) {
                        paramTypeMismatch = true;
                    }
                    if (paramTypeMismatch) {
                        throw Log.LOG.factorySignatureMismatchType(factoryKind, this.factory.toGenericString(), parameterName);
                    }
                    ++startPos;
                }
            }
        }
    }

    private ProtoFieldMetadata getFieldByPropertyName(String propName) {
        for (ProtoFieldMetadata field : this.fieldsByNumber.values()) {
            if (!propName.equals(field.getPropertyName())) continue;
            return field;
        }
        return null;
    }

    private void checkInstantiability() {
        if (this.annotatedClass.isAbstract() || this.annotatedClass.isInterface()) {
            throw Log.LOG.abstractClassNotAllowed(this.getAnnotatedClassName());
        }
        if (this.annotatedClass.isLocal()) {
            throw Log.LOG.localOrAnonymousClass(this.getAnnotatedClassName());
        }
        if (this.annotatedClass.getEnclosingClass() != null && !this.annotatedClass.isStatic()) {
            throw Log.LOG.nonStaticInnerClass(this.getAnnotatedClassName());
        }
        for (XConstructor xConstructor : this.annotatedClass.getDeclaredConstructors()) {
            if (xConstructor.getAnnotation(ProtoFactory.class) == null) continue;
            if (this.factory != null) {
                throw Log.LOG.multipleFactories(xConstructor.toString());
            }
            if (xConstructor.isPrivate()) {
                throw Log.LOG.privateFactory(xConstructor.toString());
            }
            this.factory = xConstructor;
        }
        for (XMethod xMethod : this.annotatedClass.getDeclaredMethods()) {
            if (xMethod.getAnnotation(ProtoFactory.class) == null) continue;
            if (this.factory != null) {
                throw Log.LOG.multipleFactories(xMethod.toString());
            }
            if (!this.isAdapter && !xMethod.isStatic()) {
                throw Log.LOG.nonStaticFactory(xMethod.toString());
            }
            if (xMethod.isPrivate()) {
                throw Log.LOG.privateFactory(xMethod.toString());
            }
            if (xMethod.getReturnType() != this.javaClass) {
                throw Log.LOG.wrongFactoryReturnType(xMethod.toString());
            }
            this.factory = xMethod;
        }
        if (this.factory == null) {
            if (this.javaClass.isRecord()) {
                Iterable<? extends XConstructor> declaredConstructors = this.javaClass.getDeclaredConstructors();
                this.factory = declaredConstructors.iterator().next();
            } else {
                if (this.isAdapter || this.isContainer()) {
                    throw new ProtoSchemaBuilderException("The class " + this.getJavaClassName() + " must be instantiable using an accessible @ProtoFactory annotated method defined by " + this.getAnnotatedClassName());
                }
                XConstructor ctor = this.javaClass.getDeclaredConstructor(new XClass[0]);
                if (ctor == null || ctor.isPrivate()) {
                    throw new ProtoSchemaBuilderException("The class " + this.getJavaClassName() + " must be instantiable using an accessible no-argument constructor.");
                }
            }
        }
    }

    private void discoverFields(XClass clazz, Set<XClass> examinedClasses, Map<Integer, ProtoFieldMetadata> fieldsByNumber, Map<String, ProtoFieldMetadata> fieldsByName, Set<String> oneofs) {
        if (!examinedClasses.add(clazz)) {
            return;
        }
        if (clazz.isRecord()) {
            this.discoverFieldsFromRecord(clazz, fieldsByNumber, fieldsByName);
            return;
        }
        if (clazz.getSuperclass() != null) {
            this.discoverFields(clazz.getSuperclass(), examinedClasses, fieldsByNumber, fieldsByName, oneofs);
        }
        for (XClass i : clazz.getInterfaces()) {
            this.discoverFields(i, examinedClasses, fieldsByNumber, fieldsByName, oneofs);
        }
        this.discoverFieldsFromClassFields(clazz, fieldsByNumber, fieldsByName, oneofs);
        this.discoverFieldsFromClassMethods(clazz, fieldsByNumber, fieldsByName, oneofs);
    }

    private void discoverFieldsFromClassMethods(XClass clazz, Map<Integer, ProtoFieldMetadata> fieldsByNumber, Map<String, ProtoFieldMetadata> fieldsByName, Set<String> oneofs) {
        HashSet<XMethod> skipMethods = new HashSet<XMethod>();
        for (XMethod xMethod : clazz.getDeclaredMethods()) {
            ProtoFieldMetadata fieldMetadata;
            XClass getterReturnType;
            XMethod getter;
            XMethod setter;
            String propertyName;
            if (skipMethods.contains(xMethod)) continue;
            if (xMethod.getAnnotation(ProtoUnknownFieldSet.class) != null) {
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not occur more than once in a class and its superclasses and superinterfaces : " + String.valueOf(xMethod));
                }
                if (xMethod.getAnnotation(ProtoField.class) != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet and @ProtoField annotations cannot be used together: " + String.valueOf(xMethod));
                }
                if (xMethod.getReturnType() == this.typeFactory.fromClass(Void.TYPE)) {
                    String propertyName2 = this.detectPropertyNameFromSetter(xMethod);
                    this.unknownFieldSetSetter = xMethod;
                    this.unknownFieldSetGetter = this.findGetter(propertyName2, xMethod.getParameterTypes()[0]);
                    this.checkForbiddenAnnotations(this.unknownFieldSetGetter, this.unknownFieldSetSetter);
                    skipMethods.add(this.unknownFieldSetGetter);
                    continue;
                }
                String propertyName2 = this.determinePropertyNameFromGetter(xMethod);
                this.unknownFieldSetGetter = xMethod;
                this.unknownFieldSetSetter = this.findSetter(propertyName2, this.unknownFieldSetGetter.getReturnType());
                this.checkForbiddenAnnotations(this.unknownFieldSetSetter, this.unknownFieldSetGetter);
                skipMethods.add(this.unknownFieldSetSetter);
                continue;
            }
            ProtoField annotation = xMethod.getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            if (xMethod.isPrivate()) {
                throw new ProtoSchemaBuilderException("Private methods cannot be @ProtoField annotated: " + String.valueOf(xMethod));
            }
            if (!this.isAdapter && xMethod.isStatic()) {
                throw new ProtoSchemaBuilderException("Static methods cannot be @ProtoField annotated: " + String.valueOf(xMethod));
            }
            if (xMethod.getReturnType() == this.typeFactory.fromClass(Void.TYPE)) {
                propertyName = this.detectPropertyNameFromSetter(xMethod);
                setter = xMethod;
                getter = this.findGetter(propertyName, xMethod.getParameterTypes()[0]);
                this.checkForbiddenAnnotations(getter, setter);
                skipMethods.add(getter);
                getterReturnType = getter.getReturnType();
                if (getterReturnType == this.typeFactory.fromClass(Optional.class)) {
                    getterReturnType = getter.determineOptionalReturnType();
                }
            } else {
                propertyName = this.determinePropertyNameFromGetter(xMethod);
                getter = xMethod;
                getterReturnType = getter.getReturnType();
                if (getterReturnType == this.typeFactory.fromClass(Optional.class)) {
                    getterReturnType = getter.determineOptionalReturnType();
                }
                if (this.factory == null) {
                    setter = this.findSetter(propertyName, getterReturnType);
                    this.checkForbiddenAnnotations(setter, getter);
                    skipMethods.add(setter);
                } else {
                    setter = null;
                }
            }
            int number = ProtoMessageTypeMetadata.getNumber(annotation, xMethod);
            String fieldName = annotation.name();
            if (fieldName.isEmpty()) {
                fieldName = propertyName;
            }
            Type protobufType = this.defaultType(annotation, getterReturnType);
            boolean isArray = this.isArray(getterReturnType, protobufType);
            boolean isIterable = getterReturnType.isAssignableTo(Iterable.class);
            boolean isRepeated = this.isRepeated(getterReturnType, protobufType);
            boolean isRequired = annotation.required();
            boolean isStream = getterReturnType.isAssignableTo(Stream.class);
            if (isRequired && this.protoSchemaGenerator.syntax() != ProtoSyntax.PROTO2) {
                throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required when using \"" + String.valueOf((Object)this.protoSchemaGenerator.syntax()) + "\" syntax");
            }
            boolean isMap = this.isMap(getterReturnType);
            if (isMap && this.protoSchemaGenerator.syntax() == ProtoSyntax.PROTO2) {
                throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of " + clazz.getCanonicalName() + " of type map is not supported when using \"" + String.valueOf((Object)this.protoSchemaGenerator.syntax()) + "\" syntax");
            }
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required.");
            }
            XClass javaType = this.getJavaTypeFromAnnotation(annotation);
            if (javaType == this.typeFactory.fromClass(Void.TYPE)) {
                XClass xClass = javaType = isRepeated ? getter.determineRepeatedElementType() : getterReturnType;
            }
            if (javaType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && javaType.isAbstract() && !javaType.isEnum()) {
                throw Log.LOG.abstractType(javaType.getCanonicalName(), fieldName, clazz.getCanonicalName());
            }
            protobufType = this.getProtobufType(javaType, protobufType);
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType.getJavaType() == JavaType.ENUM || protobufType.getJavaType() == JavaType.MESSAGE) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            if (isMap) {
                repeatedImplementation = this.getMapImplementation(clazz, getterReturnType, this.getMapImplementationFromAnnotation(annotation), fieldName, isRepeated);
                XClass keyJavaType = getter.getTypeArgument(0);
                Type keyProtobufType = this.getProtobufType(keyJavaType, Type.MESSAGE);
                if (!keyProtobufType.isValidMapKey()) {
                    throw new ProtoSchemaBuilderException("The key of the map field '" + fieldName + "' of " + clazz.getName() + " must be either a String or an integral type");
                }
                fieldMetadata = new ProtoMapMetadata(number, fieldName, keyJavaType, javaType, repeatedImplementation, keyProtobufType, protobufType, protoTypeMetadata, propertyName, xMethod, getter, setter);
            } else {
                repeatedImplementation = this.getCollectionImplementation(clazz, getterReturnType, this.getCollectionImplementationFromAnnotation(annotation), fieldName, isRepeated);
                if (isArray) {
                    repeatedImplementation = this.typeFactory.fromClass(ArrayList.class);
                }
                String oneof = this.validateOneOf(clazz, fieldsByName, oneofs, annotation, fieldName, isRepeated, isRequired);
                Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, annotation.defaultValue(), isRepeated);
                if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                    throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not nullable so it should be either marked required or should have a default value, while processing " + this.protoSchemaGenerator.generator);
                }
                fieldMetadata = new ProtoFieldMetadata(number, fieldName, oneof, javaType, repeatedImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, isIterable, isStream, defaultValue, propertyName, xMethod, getter, setter);
            }
            ProtoFieldMetadata existing = fieldsByNumber.get(number);
            if (this.isDuplicateField(existing, fieldMetadata)) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with number " + number + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            existing = fieldsByName.get(fieldMetadata.getName());
            if (this.isDuplicateField(existing, fieldMetadata)) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            ProtoMessageTypeMetadata.checkReserved(fieldMetadata);
            fieldsByNumber.put(number, fieldMetadata);
            fieldsByName.put(fieldName, fieldMetadata);
        }
    }

    private boolean isDuplicateField(ProtoFieldMetadata existing, ProtoFieldMetadata newField) {
        if (existing == null) {
            return false;
        }
        if (existing.isArray() || newField.isArray()) {
            return true;
        }
        return !newField.getJavaType().isAssignableTo(existing.getJavaType());
    }

    private Type defaultType(ProtoField annotation, XClass type) {
        Type protobufType;
        Type type2 = protobufType = annotation == null ? Type.MESSAGE : annotation.type();
        if (type == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
            protobufType = Type.BYTES;
        }
        return protobufType;
    }

    private void discoverFieldsFromClassFields(XClass clazz, Map<Integer, ProtoFieldMetadata> fieldsByNumber, Map<String, ProtoFieldMetadata> fieldsByName, Set<String> oneofs) {
        boolean implicitFields = clazz.getAnnotation(Proto.class) != null;
        int position = 0;
        for (XField xField : clazz.getDeclaredFields()) {
            ProtoFieldMetadata fieldMetadata;
            boolean isRequired;
            ++position;
            if (xField.getAnnotation(ProtoUnknownFieldSet.class) != null) {
                if (this.isAdapter) {
                    throw new ProtoSchemaBuilderException("No ProtoStream annotations should be present on fields when @ProtoAdapter is present on a class : " + clazz.getCanonicalName() + "." + String.valueOf(xField));
                }
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not occur more than once in a class and its superclasses and superinterfaces : " + clazz.getCanonicalName() + "." + String.valueOf(xField));
                }
                if (xField.getAnnotation(ProtoField.class) != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet and @ProtoField annotations cannot be used together: " + String.valueOf(xField));
                }
                this.unknownFieldSetField = xField;
                continue;
            }
            ProtoField annotation = xField.getAnnotation(ProtoField.class);
            if (annotation == null && !implicitFields) continue;
            this.validateField(clazz, xField);
            int number = annotation != null ? ProtoMessageTypeMetadata.getNumber(annotation, xField) : position;
            String fieldName = ProtoMessageTypeMetadata.getName(annotation, xField);
            Type protobufType = this.defaultType(annotation, xField.getType());
            boolean isArray = this.isArray(xField.getType(), protobufType);
            boolean isRepeated = this.isRepeated(xField.getType(), protobufType);
            boolean isIterable = xField.getType().isAssignableTo(Iterable.class);
            boolean isStream = xField.getType().isAssignableTo(Stream.class);
            boolean bl = isRequired = annotation != null && annotation.required();
            if (isRequired && this.protoSchemaGenerator.syntax() != ProtoSyntax.PROTO2) {
                throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required when using \"" + String.valueOf((Object)this.protoSchemaGenerator.syntax()) + "\" syntax, while processing " + this.protoSchemaGenerator.generator);
            }
            boolean isMap = this.isMap(xField.getType());
            if (isMap && this.protoSchemaGenerator.syntax() == ProtoSyntax.PROTO2) {
                throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of " + clazz.getCanonicalName() + " of type map is not supported when using \"" + String.valueOf((Object)this.protoSchemaGenerator.syntax()) + "\" syntax, while processing " + this.protoSchemaGenerator.generator);
            }
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required.");
            }
            XClass javaType = this.getJavaTypeFromAnnotation(annotation);
            if (javaType == this.typeFactory.fromClass(Void.TYPE)) {
                XClass xClass = javaType = isRepeated ? xField.determineRepeatedElementType() : xField.getType();
            }
            if (javaType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && javaType.isAbstract() && !javaType.isEnum()) {
                throw Log.LOG.abstractType(javaType.getCanonicalName(), fieldName, clazz.getCanonicalName());
            }
            protobufType = this.getProtobufType(javaType, protobufType);
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType.getJavaType() == JavaType.ENUM || protobufType.getJavaType() == JavaType.MESSAGE) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            if (isMap) {
                XClass repeatedImplementation = this.getMapImplementation(clazz, xField.getType(), this.getMapImplementationFromAnnotation(annotation), fieldName, isRepeated);
                XClass keyJavaType = xField.getTypeArgument(0);
                Type keyProtobufType = this.getProtobufType(keyJavaType, Type.MESSAGE);
                if (!keyProtobufType.isValidMapKey()) {
                    throw new ProtoSchemaBuilderException("The key of the map field '" + fieldName + "' of " + clazz.getName() + " must be either a String or an integral type, while processing " + this.protoSchemaGenerator.generator);
                }
                fieldMetadata = new ProtoMapMetadata(number, fieldName, keyJavaType, javaType, repeatedImplementation, keyProtobufType, protobufType, protoTypeMetadata, xField);
            } else {
                Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, annotation == null ? "" : annotation.defaultValue(), isRepeated);
                if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                    throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not nullable so it should be either marked required or should have a default value, while processing " + this.protoSchemaGenerator.generator);
                }
                String oneof = this.validateOneOf(clazz, fieldsByName, oneofs, annotation, fieldName, isRepeated, isRequired);
                XClass repeatedImplementation = isArray ? this.typeFactory.fromClass(ArrayList.class) : this.getCollectionImplementation(clazz, xField.getType(), this.getCollectionImplementationFromAnnotation(annotation), fieldName, isRepeated);
                fieldMetadata = new ProtoFieldMetadata(number, fieldName, oneof, javaType, repeatedImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, isIterable, isStream, defaultValue, xField);
            }
            ProtoFieldMetadata existing = fieldsByNumber.get(number);
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field number definition. Found two field definitions with number " + number + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation() + ", while processing " + this.protoSchemaGenerator.generator);
            }
            existing = fieldsByName.get(fieldMetadata.getName());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field name definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation() + ", while processing " + this.protoSchemaGenerator.generator);
            }
            ProtoMessageTypeMetadata.checkReserved(fieldMetadata);
            fieldsByNumber.put(fieldMetadata.getNumber(), fieldMetadata);
            fieldsByName.put(fieldName, fieldMetadata);
        }
    }

    private static String getName(ProtoField annotation, XField field) {
        if (annotation == null || annotation.name().isEmpty()) {
            return field.getName();
        }
        return annotation.name();
    }

    private String validateOneOf(XClass clazz, Map<String, ProtoFieldMetadata> fieldsByName, Set<String> oneofs, ProtoField annotation, String fieldName, boolean isRepeated, boolean isRequired) {
        if (annotation == null) {
            return null;
        }
        String oneof = annotation.oneof();
        if (oneof.isEmpty()) {
            oneof = null;
        } else {
            if (oneof.equals(fieldName) || fieldsByName.containsKey(oneof)) {
                throw new ProtoSchemaBuilderException("The field named '" + fieldName + "' of " + clazz.getName() + " is member of the '" + oneof + "' oneof which collides with an existing field or oneof, while processing " + this.protoSchemaGenerator.generator);
            }
            if (isRepeated || isRequired) {
                throw new ProtoSchemaBuilderException("The field named '" + fieldName + "' of " + clazz.getName() + " cannot be marked repeated or required since it is member of the '" + oneof + " oneof, while processing " + this.protoSchemaGenerator.generator);
            }
            oneofs.add(oneof);
        }
        return oneof;
    }

    private void validateField(XClass clazz, XField field) {
        if (this.isAdapter) {
            throw new ProtoSchemaBuilderException("No ProtoStream annotations should be present on fields when @ProtoAdapter is present on a class : " + clazz.getCanonicalName() + "." + String.valueOf(field));
        }
        if (field.isStatic()) {
            throw new ProtoSchemaBuilderException("Static fields cannot be @ProtoField annotated: " + clazz.getCanonicalName() + "." + String.valueOf(field));
        }
        if (this.factory == null && field.isFinal()) {
            throw new ProtoSchemaBuilderException("Final fields cannot be @ProtoField annotated: " + clazz.getCanonicalName() + "." + String.valueOf(field));
        }
        if (field.isPrivate()) {
            throw new ProtoSchemaBuilderException("Private fields cannot be @ProtoField annotated: " + clazz.getCanonicalName() + "." + String.valueOf(field));
        }
    }

    private String detectPropertyNameFromSetter(XMethod method) {
        if (this.isAdapter && method.getParameterTypes().length != 2 || !this.isAdapter && method.getParameterTypes().length != 1) {
            throw new ProtoSchemaBuilderException("Illegal setter method signature: " + String.valueOf(method));
        }
        if (method.getName().startsWith("set") && method.getName().length() > 3) {
            return Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
        }
        return method.getName();
    }

    private String determinePropertyNameFromGetter(XMethod method) {
        if (this.isAdapter && method.getParameterTypes().length != 1 || !this.isAdapter && method.getParameterTypes().length != 0) {
            throw new ProtoSchemaBuilderException("Illegal getter method signature: " + String.valueOf(method));
        }
        if (method.getName().startsWith("get") && method.getName().length() > 3) {
            return Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
        }
        if (method.getName().startsWith("is") && method.getName().length() > 2) {
            return Character.toLowerCase(method.getName().charAt(2)) + method.getName().substring(3);
        }
        return method.getName();
    }

    private void discoverFieldsFromRecord(XClass clazz, Map<Integer, ProtoFieldMetadata> fieldsByNumber, Map<String, ProtoFieldMetadata> fieldsByName) {
        String[] parameterNames = this.factory.getParameterNames();
        XClass[] parameterTypes = this.factory.getParameterTypes();
        Iterator<? extends XRecordComponent> components = clazz.getRecordComponents().iterator();
        for (int i = 0; i < this.factory.getParameterCount(); ++i) {
            ProtoFieldMetadata fieldMetadata;
            Object defaultValue;
            int fieldNumber = i + 1;
            ProtoField annotation = components.next().getAnnotation(ProtoField.class);
            String fieldName = parameterNames[i];
            XClass javaType = parameterTypes[i];
            Type protobufType = this.defaultType(annotation, javaType);
            XMethod getter = clazz.getMethod(fieldName, new XClass[0]);
            boolean isArray = this.isArray(javaType, protobufType);
            boolean isIterable = javaType.isAssignableTo(Iterable.class);
            boolean isStream = javaType.isAssignableTo(Stream.class);
            boolean isRepeated = this.isRepeated(javaType, protobufType);
            boolean isMap = this.isMap(javaType);
            XClass repeatedImplementation = null;
            if (isMap) {
                repeatedImplementation = this.getMapImplementation(clazz, javaType, this.getMapImplementationFromAnnotation(annotation), fieldName, true);
            } else if (isArray) {
                repeatedImplementation = this.typeFactory.fromClass(ArrayList.class);
            } else if (isRepeated) {
                repeatedImplementation = this.getCollectionImplementation(clazz, javaType, this.getCollectionImplementationFromAnnotation(annotation), fieldName, true);
            }
            if (isRepeated) {
                javaType = getter.determineRepeatedElementType();
            }
            if (javaType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && javaType.isAbstract() && !javaType.isEnum()) {
                throw new ProtoSchemaBuilderException("The type " + javaType.getCanonicalName() + " of field '" + fieldName + "' of " + clazz.getCanonicalName() + " should not be abstract.");
            }
            protobufType = this.getProtobufType(javaType, protobufType);
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType.getJavaType() == JavaType.ENUM || protobufType.getJavaType() == JavaType.MESSAGE) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            String oneof = null;
            if (annotation == null) {
                defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, "", false);
            } else {
                if (annotation.number() > 0) {
                    fieldNumber = annotation.number();
                }
                if (!annotation.name().isEmpty()) {
                    fieldName = annotation.name();
                }
                if (!annotation.oneof().isEmpty()) {
                    oneof = annotation.oneof();
                }
                defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, annotation.defaultValue(), false);
            }
            if (isMap) {
                XClass keyJavaType = getter.getTypeArgument(0);
                Type keyType = this.getProtobufType(keyJavaType, Type.MESSAGE);
                if (!keyType.isValidMapKey()) {
                    throw new ProtoSchemaBuilderException("The key of the map field '" + fieldName + "' of " + clazz.getName() + " must be either a String or an integral type, while processing " + this.protoSchemaGenerator.generator);
                }
                fieldMetadata = new ProtoMapMetadata(fieldNumber, fieldName, keyJavaType, javaType, repeatedImplementation, keyType, protobufType, protoTypeMetadata, fieldName, getter, getter, null);
            } else {
                fieldMetadata = new ProtoFieldMetadata(fieldNumber, fieldName, oneof, javaType, repeatedImplementation, protobufType, protoTypeMetadata, false, isRepeated, isArray, isIterable, isStream, defaultValue, fieldName, getter, getter, null);
            }
            ProtoMessageTypeMetadata.checkReserved(fieldMetadata);
            fieldsByNumber.put(fieldMetadata.getNumber(), fieldMetadata);
            fieldsByName.put(fieldMetadata.getName(), fieldMetadata);
        }
    }

    private static int getNumber(ProtoField annotation, XMember member) {
        int number = annotation.number();
        if (number == 0) {
            number = annotation.value();
        } else if (annotation.value() != 0) {
            throw new ProtoSchemaBuilderException("@ProtoField.number() and value() are mutually exclusive: " + String.valueOf(member));
        }
        if (number < 1) {
            throw new ProtoSchemaBuilderException("Protobuf field numbers specified by @ProtoField.number() or value() must be greater than 0: " + String.valueOf(member));
        }
        return number;
    }

    private static void checkReserved(ProtoFieldMetadata fieldMetadata) {
        if (fieldMetadata.getNumber() >= 19000 && fieldMetadata.getNumber() <= 19999) {
            throw new ProtoSchemaBuilderException("Field numbers 19000 through 19999 are reserved for internal use by the protobuf specification: " + fieldMetadata.getLocation());
        }
    }

    protected XClass getCollectionImplementationFromAnnotation(ProtoField annotation) {
        return annotation == null ? this.typeFactory.fromClass(Collection.class) : this.typeFactory.fromClass(annotation.collectionImplementation());
    }

    protected XClass getMapImplementationFromAnnotation(ProtoField annotation) {
        return annotation == null ? this.typeFactory.fromClass(Map.class) : this.typeFactory.fromClass(annotation.mapImplementation());
    }

    protected XClass getJavaTypeFromAnnotation(ProtoField annotation) {
        return annotation == null ? this.typeFactory.fromClass(Void.TYPE) : this.typeFactory.fromClass(annotation.javaType());
    }

    private Object getDefaultValue(XClass clazz, String fieldName, XClass fieldType, Type protobufType, String value, boolean isRepeated) {
        Optional<String> defaultValue;
        if ((this.protoSchemaGenerator.syntax() == ProtoSyntax.PROTO2 || this.protoSchemaGenerator.allowNullFields() && !fieldType.isPrimitive()) && (value == null || value.isEmpty())) {
            return null;
        }
        if (fieldType == this.typeFactory.fromClass(String.class)) {
            return isRepeated ? null : value;
        }
        Optional<String> optional = defaultValue = value == null || value.isEmpty() ? Optional.empty() : Optional.of(value);
        if (fieldType.isEnum()) {
            ProtoTypeMetadata protoEnumTypeMetadata = this.protoSchemaGenerator.scanAnnotations(fieldType);
            ProtoEnumValueMetadata enumVal = defaultValue.isEmpty() ? protoEnumTypeMetadata.getEnumMemberByNumber(0) : protoEnumTypeMetadata.getEnumMemberByName((String)defaultValue.get());
            if (enumVal == null) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + defaultValue.orElse("0") + " is not a member of " + protoEnumTypeMetadata.getFullName() + " enum");
            }
            return enumVal;
        }
        if (fieldType == this.typeFactory.fromClass(Character.class) || fieldType == this.typeFactory.fromClass(Character.TYPE)) {
            if (defaultValue.isEmpty() || ((String)defaultValue.get()).length() > 1) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + String.valueOf(defaultValue));
            }
            return Character.valueOf(((String)defaultValue.get()).charAt(0));
        }
        if (fieldType == this.typeFactory.fromClass(Boolean.class) || fieldType == this.typeFactory.fromClass(Boolean.TYPE)) {
            return Boolean.valueOf(defaultValue.orElse("false"));
        }
        try {
            if (fieldType == this.typeFactory.fromClass(Integer.class) || fieldType == this.typeFactory.fromClass(Integer.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                int v = defaultValue.map(ProtoMessageTypeMetadata::parseInt).orElse(0);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + String.valueOf((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + String.valueOf(defaultValue));
                }
                return v;
            }
            if (fieldType == this.typeFactory.fromClass(Long.class) || fieldType == this.typeFactory.fromClass(Long.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                long v = defaultValue.map(ProtoMessageTypeMetadata::parseLong).orElse(0L);
                if (v < 0L && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + String.valueOf((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + String.valueOf(defaultValue));
                }
                return v;
            }
            if (fieldType == this.typeFactory.fromClass(Short.class) || fieldType == this.typeFactory.fromClass(Short.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                int v = defaultValue.map(ProtoMessageTypeMetadata::parseInt).orElse(0);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + String.valueOf((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + String.valueOf(defaultValue));
                }
                if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                    throw new NumberFormatException("Value out of range for \"" + String.valueOf((Object)protobufType) + "\": \"" + String.valueOf(defaultValue));
                }
                return (short)v;
            }
            if (fieldType == this.typeFactory.fromClass(Double.class) || fieldType == this.typeFactory.fromClass(Double.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                return defaultValue.map(Double::parseDouble).orElse(0.0);
            }
            if (fieldType == this.typeFactory.fromClass(Float.class) || fieldType == this.typeFactory.fromClass(Float.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                return defaultValue.map(Float::parseFloat).orElse(Float.valueOf(0.0f));
            }
            if (fieldType == this.typeFactory.fromClass(Byte.class) || fieldType == this.typeFactory.fromClass(Byte.TYPE)) {
                if (defaultValue.isEmpty() && isRepeated) {
                    return null;
                }
                int v = defaultValue.map(ProtoMessageTypeMetadata::parseInt).orElse(0);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + String.valueOf((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + String.valueOf(defaultValue));
                }
                if (v < -128 || v > 127) {
                    throw new NumberFormatException("Value out of range for \"" + String.valueOf((Object)protobufType) + "\": \"" + String.valueOf(defaultValue));
                }
                return (byte)v;
            }
            if (fieldType.isAssignableTo(Date.class) || fieldType.isAssignableTo(Instant.class)) {
                return defaultValue.map(Long::parseUnsignedLong).orElse(0L);
            }
        }
        catch (NumberFormatException e) {
            throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + String.valueOf(defaultValue), (Throwable)e);
        }
        if (protobufType == Type.BYTES) {
            if (fieldType == this.typeFactory.fromClass(byte[].class)) {
                return ProtoMessageTypeMetadata.cescape(defaultValue);
            }
            throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + String.valueOf(defaultValue));
        }
        if (defaultValue.isPresent()) {
            throw new ProtoSchemaBuilderException("No default value is allowed for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName());
        }
        return null;
    }

    static byte[] cescape(Optional<String> s) {
        return s.map(string -> ProtoMessageTypeMetadata.cescape(string.getBytes(StandardCharsets.UTF_8))).orElse(EMPTY_BYTES);
    }

    static byte[] cescape(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        for (byte b : bytes) {
            int ub = Byte.toUnsignedInt(b);
            if (ub < 32 || ub > 127) {
                baos.write(92);
                baos.write(48 + (ub >> 6 & 7));
                baos.write(48 + (ub >> 3 & 7));
                baos.write(48 + (ub & 7));
                continue;
            }
            baos.write(ub);
        }
        return baos.toByteArray();
    }

    private static long parseLong(String value) {
        int radix;
        if (value == null) {
            throw new IllegalArgumentException("value argument cannot be null");
        }
        if (value.isEmpty()) {
            throw new NumberFormatException("Empty input string");
        }
        String s = value;
        boolean isNegative = false;
        if (s.charAt(0) == '-') {
            isNegative = true;
            s = s.substring(1);
        }
        if (s.length() > 1 && s.charAt(0) == '0') {
            if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                s = s.substring(2);
            } else {
                radix = 8;
                s = s.substring(1);
            }
        } else {
            radix = 10;
        }
        try {
            long v = Long.parseUnsignedLong(s, radix);
            return isNegative ? -v : v;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }
    }

    private static int parseInt(String value) {
        int radix;
        if (value == null) {
            throw new IllegalArgumentException("value argument cannot be null");
        }
        if (value.isEmpty()) {
            throw new NumberFormatException("Empty input string");
        }
        String s = value;
        boolean isNegative = false;
        if (s.charAt(0) == '-') {
            isNegative = true;
            s = s.substring(1);
        }
        if (s.length() > 1 && s.charAt(0) == '0') {
            if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                s = s.substring(2);
            } else {
                radix = 8;
                s = s.substring(1);
            }
        } else {
            radix = 10;
        }
        try {
            int v = Integer.parseUnsignedInt(s, radix);
            return isNegative ? -v : v;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }
    }

    private XClass getCollectionImplementation(XClass clazz, XClass fieldType, XClass configuredCollection, String fieldName, boolean isRepeated) {
        XClass collectionImplementation;
        XClass javaUtilCollectionClass = this.typeFactory.fromClass(Collection.class);
        if (isRepeated && !fieldType.isArray()) {
            collectionImplementation = configuredCollection;
            if (collectionImplementation == javaUtilCollectionClass) {
                collectionImplementation = fieldType == this.typeFactory.fromClass(Set.class) ? this.typeFactory.fromClass(HashSet.class) : (fieldType == this.typeFactory.fromClass(List.class) || fieldType == this.typeFactory.fromClass(Collection.class) || fieldType == this.typeFactory.fromClass(Iterable.class) || fieldType == this.typeFactory.fromClass(Stream.class) ? this.typeFactory.fromClass(ArrayList.class) : fieldType);
            }
            if (!collectionImplementation.isAssignableTo(javaUtilCollectionClass)) {
                throw new ProtoSchemaBuilderException("The collection class of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must implement java.util.Collection.");
            }
            if (collectionImplementation.isAbstract()) {
                throw new ProtoSchemaBuilderException("The collection class (" + collectionImplementation.getCanonicalName() + ") of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must not be abstract. Please specify an appropriate class in collectionImplementation member.");
            }
            XConstructor ctor = collectionImplementation.getDeclaredConstructor(new XClass[0]);
            if (ctor == null || ctor.isPrivate()) {
                throw new ProtoSchemaBuilderException("The collection class ('" + collectionImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must have a public no-argument constructor.");
            }
            if (!fieldType.isAssignableTo(Stream.class) && !collectionImplementation.isAssignableTo(fieldType)) {
                throw new ProtoSchemaBuilderException("The collection implementation class ('" + collectionImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not assignable to this field's type.");
            }
        } else {
            if (configuredCollection != javaUtilCollectionClass) {
                throw new ProtoSchemaBuilderException("Specifying the collection implementation class is only allowed for collection (repeated) fields: '" + fieldName + "' of " + clazz.getCanonicalName());
            }
            collectionImplementation = null;
        }
        return collectionImplementation;
    }

    private XClass getMapImplementation(XClass clazz, XClass fieldType, XClass configuredMap, String fieldName, boolean isRepeated) {
        XClass mapImplementation;
        XClass javaUtilMapClass = this.typeFactory.fromClass(Map.class);
        if (isRepeated && !fieldType.isArray()) {
            mapImplementation = configuredMap;
            if (mapImplementation == javaUtilMapClass) {
                mapImplementation = fieldType == this.typeFactory.fromClass(Map.class) ? this.typeFactory.fromClass(HashMap.class) : (fieldType == this.typeFactory.fromClass(ConcurrentMap.class) || fieldType == this.typeFactory.fromClass(ConcurrentHashMap.class) ? this.typeFactory.fromClass(ConcurrentHashMap.class) : (fieldType == this.typeFactory.fromClass(SortedMap.class) ? this.typeFactory.fromClass(TreeMap.class) : fieldType));
            }
            if (!mapImplementation.isAssignableTo(javaUtilMapClass)) {
                throw new ProtoSchemaBuilderException("The map class of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must implement java.util.Map.");
            }
            if (mapImplementation.isAbstract()) {
                throw new ProtoSchemaBuilderException("The map class (" + mapImplementation.getCanonicalName() + ") of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must not be abstract. Please specify an appropriate class in mapImplementation member.");
            }
            XConstructor ctor = mapImplementation.getDeclaredConstructor(new XClass[0]);
            if (ctor == null || ctor.isPrivate()) {
                throw new ProtoSchemaBuilderException("The map class ('" + mapImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must have a public no-argument constructor.");
            }
            if (!mapImplementation.isAssignableTo(fieldType)) {
                throw new ProtoSchemaBuilderException("The map implementation class ('" + mapImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not assignable to this field's type.");
            }
        } else {
            if (configuredMap != javaUtilMapClass) {
                throw new ProtoSchemaBuilderException("Specifying the map implementation class is only allowed for map fields: '" + fieldName + "' of " + clazz.getCanonicalName());
            }
            mapImplementation = null;
        }
        return mapImplementation;
    }

    private Type getProtobufType(XClass javaType, Type declaredType) {
        switch (declaredType) {
            case MESSAGE: {
                if (javaType.isEnum()) {
                    ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                    if (!m.isEnum()) {
                        throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable enum type");
                    }
                    return Type.ENUM;
                }
                if (javaType == this.typeFactory.fromClass(String.class)) {
                    return Type.STRING;
                }
                if (javaType == this.typeFactory.fromClass(Double.class) || javaType == this.typeFactory.fromClass(Double.TYPE)) {
                    return Type.DOUBLE;
                }
                if (javaType == this.typeFactory.fromClass(Float.class) || javaType == this.typeFactory.fromClass(Float.TYPE)) {
                    return Type.FLOAT;
                }
                if (javaType == this.typeFactory.fromClass(Long.class) || javaType == this.typeFactory.fromClass(Long.TYPE)) {
                    return Type.INT64;
                }
                if (javaType == this.typeFactory.fromClass(Integer.class) || javaType == this.typeFactory.fromClass(Integer.TYPE) || javaType == this.typeFactory.fromClass(Short.class) || javaType == this.typeFactory.fromClass(Short.TYPE) || javaType == this.typeFactory.fromClass(Byte.class) || javaType == this.typeFactory.fromClass(Byte.TYPE) || javaType == this.typeFactory.fromClass(Character.class) || javaType == this.typeFactory.fromClass(Character.TYPE)) {
                    return Type.INT32;
                }
                if (javaType == this.typeFactory.fromClass(Boolean.class) || javaType == this.typeFactory.fromClass(Boolean.TYPE)) {
                    return Type.BOOL;
                }
                if (javaType.isAssignableTo(Date.class)) {
                    return Type.FIXED64;
                }
                if (javaType.isAssignableTo(Instant.class)) {
                    return Type.FIXED64;
                }
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable message type");
            }
            case ENUM: {
                if (javaType.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable enum type");
            }
            case GROUP: {
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable message type");
            }
            case STRING: {
                if (javaType == this.typeFactory.fromClass(String.class)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case BYTES: {
                if (javaType == this.typeFactory.fromClass(byte[].class)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case DOUBLE: {
                if (javaType == this.typeFactory.fromClass(Double.class) || javaType == this.typeFactory.fromClass(Double.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case FLOAT: {
                if (javaType == this.typeFactory.fromClass(Float.class) || javaType == this.typeFactory.fromClass(Float.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case BOOL: {
                if (javaType == this.typeFactory.fromClass(Boolean.class) || javaType == this.typeFactory.fromClass(Boolean.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case INT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: 
            case SINT32: {
                if (javaType == this.typeFactory.fromClass(Integer.class) || javaType == this.typeFactory.fromClass(Integer.TYPE) || javaType == this.typeFactory.fromClass(Short.class) || javaType == this.typeFactory.fromClass(Short.TYPE) || javaType == this.typeFactory.fromClass(Byte.class) || javaType == this.typeFactory.fromClass(Byte.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                if (javaType == this.typeFactory.fromClass(Long.class) || javaType == this.typeFactory.fromClass(Long.TYPE) || javaType.isAssignableTo(Date.class) || javaType.isAssignableTo(Instant.class)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + String.valueOf((Object)declaredType));
            }
        }
        return declaredType;
    }

    private boolean isArray(XClass javaType, Type type) {
        if (type == Type.BYTES && javaType == this.typeFactory.fromClass(byte[].class)) {
            return false;
        }
        return javaType.isArray();
    }

    private boolean isRepeated(XClass javaType, Type type) {
        if (type == Type.BYTES && javaType == this.typeFactory.fromClass(byte[].class)) {
            return false;
        }
        return javaType.isArray() || javaType.isAssignableTo(Collection.class) || javaType.isAssignableTo(Map.class) || javaType.isAssignableTo(Iterable.class) || javaType.isAssignableTo(Stream.class);
    }

    private boolean isMap(XClass javaType) {
        return javaType.isAssignableTo(Map.class);
    }

    private XMethod findGetter(String propertyName, XClass propertyType) {
        XMethod getter;
        boolean isBoolean = propertyType == this.typeFactory.fromClass(Boolean.TYPE) || propertyType == this.typeFactory.fromClass(Boolean.class);
        String methodName = (isBoolean ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        if (this.isAdapter) {
            getter = this.annotatedClass.getMethod(methodName, new XClass[0]);
            if (getter == null && isBoolean) {
                methodName = getterName;
                getter = this.annotatedClass.getMethod(methodName, this.javaClass);
            }
            if (getter == null) {
                getter = this.annotatedClass.getMethod(propertyName, this.javaClass);
            }
            if (getter == null) {
                throw new ProtoSchemaBuilderException("No getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getAnnotatedClassName());
            }
            XClass returnType = getter.getReturnType();
            if (returnType == this.typeFactory.fromClass(Optional.class)) {
                returnType = getter.determineOptionalReturnType();
            }
            if (returnType != propertyType) {
                throw new ProtoSchemaBuilderException("No suitable getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getAnnotatedClassName() + ". The candidate method does not have a suitable return type: " + String.valueOf(getter));
            }
        } else {
            getter = this.javaClass.getMethod(methodName, new XClass[0]);
            if (getter == null && isBoolean) {
                methodName = getterName;
                getter = this.javaClass.getMethod(methodName, new XClass[0]);
            }
            if (getter == null) {
                getter = this.javaClass.getMethod(propertyName, new XClass[0]);
            }
            if (getter == null) {
                throw new ProtoSchemaBuilderException("No getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName());
            }
            XClass returnType = getter.getReturnType();
            if (returnType == this.typeFactory.fromClass(Optional.class)) {
                returnType = getter.determineOptionalReturnType();
            }
            if (returnType != propertyType) {
                throw new ProtoSchemaBuilderException("No suitable getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName() + ". The candidate method does not have a suitable return type: " + String.valueOf(getter));
            }
        }
        return getter;
    }

    private XMethod findSetter(String propertyName, XClass propertyType) {
        XMethod setter;
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        if (this.isAdapter) {
            setter = this.annotatedClass.getMethod(methodName, this.javaClass, propertyType);
            if (setter == null) {
                setter = this.annotatedClass.getMethod(propertyName, this.javaClass, propertyType);
            }
            if (setter == null) {
                throw new ProtoSchemaBuilderException("No setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getAnnotatedClassName());
            }
            if (setter.getReturnType() != this.typeFactory.fromClass(Void.TYPE)) {
                throw new ProtoSchemaBuilderException("No suitable setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getAnnotatedClassName() + ". The candidate method does not have a suitable return type: " + String.valueOf(setter));
            }
        } else {
            setter = this.javaClass.getMethod(methodName, propertyType);
            if (setter == null) {
                setter = this.javaClass.getMethod(propertyName, propertyType);
            }
            if (setter == null) {
                throw new ProtoSchemaBuilderException("No setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getJavaClassName());
            }
            if (setter.getReturnType() != this.typeFactory.fromClass(Void.TYPE)) {
                throw new ProtoSchemaBuilderException("No suitable setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.getJavaClassName() + ". The candidate method does not have a suitable return type: " + String.valueOf(setter));
            }
        }
        return setter;
    }

    private void checkForbiddenAnnotations(XMethod m1, XMethod m2) {
        if (m1.getAnnotation(ProtoComment.class) != null || m1.getAnnotation(ProtoField.class) != null || m1.getAnnotation(ProtoUnknownFieldSet.class) != null) {
            throw new ProtoSchemaBuilderException("No @ProtoDoc, @ProtoField or @ProtoUnknownFieldSet annotations allowed on method " + String.valueOf(m1) + ". They should have been added to " + String.valueOf(m2));
        }
    }

    public String toString() {
        return "ProtoMessageTypeMetadata{name='" + this.name + "', javaClass=" + String.valueOf(this.javaClass) + ", annotatedClass=" + String.valueOf(this.annotatedClass) + ", isAdapter=" + this.isAdapter + ", fieldsByNumber=" + String.valueOf(this.fieldsByNumber) + ", factory=" + String.valueOf(this.factory) + ", unknownFieldSetField=" + String.valueOf(this.unknownFieldSetField) + ", unknownFieldSetGetter=" + String.valueOf(this.unknownFieldSetGetter) + ", unknownFieldSetSetter=" + String.valueOf(this.unknownFieldSetSetter) + ", innerTypes=" + String.valueOf(this.innerTypes) + "}";
    }
}

