/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.MapDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.TagWriterImpl;
import org.jboss.logging.Logger;

final class ProtoStreamWriterImpl
implements MessageMarshaller.ProtoStreamWriter {
    private static final Log log = Log.LogFactory.getLog(ProtoStreamWriterImpl.class);
    private static final int CHUNK_SIZE = 4096;
    private final SerializationContextImpl serCtx;
    private WriteMessageContext messageContext;

    ProtoStreamWriterImpl(SerializationContextImpl serCtx) {
        this.serCtx = serCtx;
    }

    WriteMessageContext enterContext(FieldDescriptor fd, Descriptor messageDescriptor, TagWriterImpl out) {
        this.messageContext = new WriteMessageContext(this.messageContext, fd, messageDescriptor, out);
        return this.messageContext;
    }

    void exitContext() {
        this.messageContext = (WriteMessageContext)this.messageContext.getParentContext();
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public void writeInt(String fieldName, int value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeInt(String fieldName, Integer value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeInts(String fieldName, int[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case INT32: {
                for (int value : array) {
                    out.writeInt32(fieldNumber, value);
                }
                break;
            }
            case FIXED32: {
                for (int value : array) {
                    out.writeFixed32(fieldNumber, value);
                }
                break;
            }
            case UINT32: {
                for (int value : array) {
                    out.writeUInt32(fieldNumber, value);
                }
                break;
            }
            case SFIXED32: {
                for (int value : array) {
                    out.writeSFixed32(fieldNumber, value);
                }
                break;
            }
            case SINT32: {
                for (int value : array) {
                    out.writeSInt32(fieldNumber, value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeLong(String fieldName, long value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeLong(String fieldName, Long value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeLongs(String fieldName, long[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case INT64: {
                for (long value : array) {
                    out.writeInt64(fieldNumber, value);
                }
                break;
            }
            case FIXED64: {
                for (long value : array) {
                    out.writeFixed64(fieldNumber, value);
                }
                break;
            }
            case UINT64: {
                for (long value : array) {
                    out.writeUInt64(fieldNumber, value);
                }
                break;
            }
            case SFIXED64: {
                for (long value : array) {
                    out.writeSFixed64(fieldNumber, value);
                }
                break;
            }
            case SINT64: {
                for (long value : array) {
                    out.writeSInt64(fieldNumber, value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public void writeDate(String fieldName, Date value) throws IOException {
        if (value != null) {
            this.writeLong(fieldName, value.getTime());
        }
    }

    @Override
    public void writeInstant(String fieldName, Instant value) throws IOException {
        if (value != null) {
            this.writeLong(fieldName, value.toEpochMilli());
        }
    }

    @Override
    public void writeDouble(String fieldName, double value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.messageContext.out.writeDouble(fd.getNumber(), value);
    }

    @Override
    public void writeDouble(String fieldName, Double value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.messageContext.out.writeDouble(fd.getNumber(), value);
    }

    @Override
    public void writeDoubles(String fieldName, double[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.DOUBLE) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (double value : array) {
            out.writeDouble(fieldNumber, value);
        }
    }

    @Override
    public void writeFloat(String fieldName, float value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        this.messageContext.out.writeFloat(fd.getNumber(), value);
    }

    @Override
    public void writeFloat(String fieldName, Float value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.messageContext.out.writeFloat(fd.getNumber(), value.floatValue());
    }

    @Override
    public void writeFloats(String fieldName, float[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.FLOAT) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (float value : array) {
            out.writeFloat(fieldNumber, value);
        }
    }

    @Override
    public void writeBoolean(String fieldName, boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        this.messageContext.out.writeBool(fd.getNumber(), value);
    }

    @Override
    public void writeBoolean(String fieldName, Boolean value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.messageContext.out.writeBool(fd.getNumber(), value);
    }

    @Override
    public void writeBooleans(String fieldName, boolean[] array) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.BOOL) {
            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
        }
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        for (boolean value : array) {
            out.writeBool(fieldNumber, value);
        }
    }

    @Override
    public void writeString(String fieldName, String value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.STRING) {
            throw new IllegalArgumentException("Declared field type is not of type string : " + fd.getFullName());
        }
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.messageContext.out.writeString(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, byte[] value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type bytes : " + fd.getFullName());
        }
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.messageContext.out.writeBytes(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, InputStream input) throws IOException {
        int bufLen;
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (fd.getType() != Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type bytes : " + fd.getFullName());
        }
        if (input == null) {
            throw new IllegalArgumentException("The input stream cannot be null");
        }
        int len = 0;
        LinkedList<byte[]> chunks = new LinkedList<byte[]>();
        byte[] buffer = new byte[4096];
        while ((bufLen = input.read(buffer)) != -1) {
            chunks.add(buffer);
            len += bufLen;
            buffer = new byte[4096];
        }
        input.close();
        TagWriterImpl out = this.messageContext.out;
        out.writeTag(fd.getNumber(), 2);
        out.writeVarint32(len);
        for (byte[] chunk : chunks) {
            out.writeRawBytes(buffer, 0, chunk == buffer ? bufLen : 4096);
        }
    }

    @Override
    public <E> void writeObject(String fieldName, E value, Class<? extends E> clazz) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        if (fd.getType() == Type.GROUP) {
            this.writeGroup(fd, value, clazz);
        } else if (fd.getType() == Type.MESSAGE) {
            this.writeMessage(fd, value, clazz);
        } else if (fd.getType() == Type.ENUM) {
            this.writeEnum(fd, (Enum)value);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fd.getFullName());
        }
    }

    @Override
    public <E extends Enum<E>> void writeEnum(String fieldName, E value) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (fd.getType() != Type.ENUM) {
            throw new IllegalArgumentException("Declared field type is not an enum : " + fd.getFullName());
        }
        this.checkFieldWrite(fd);
        if (value == null) {
            if (fd.getLabel() == Label.REQUIRED) {
                throw new IllegalArgumentException("A required field cannot be null : " + fd.getFullName());
            }
            return;
        }
        this.writeEnum(fd, value);
    }

    private void writeMessage(FieldDescriptor fd, Object value, Class<?> clazz) throws IOException {
        BaseMarshallerDelegate<Class<?>> marshallerDelegate = this.serCtx.getMarshallerDelegate(clazz);
        try (TagWriter nestedWriter = this.messageContext.out.subWriter(fd.getNumber(), true);){
            marshallerDelegate.marshall((TagWriterImpl)nestedWriter, fd, (Class<?>)value);
        }
    }

    private void writeGroup(FieldDescriptor fd, Object value, Class<?> clazz) throws IOException {
        BaseMarshallerDelegate<Class<?>> marshallerDelegate = this.serCtx.getMarshallerDelegate(clazz);
        this.messageContext.out.writeTag(fd.getNumber(), 3);
        marshallerDelegate.marshall(this.messageContext.out, fd, (Class<?>)value);
        this.messageContext.out.writeTag(fd.getNumber(), 4);
    }

    private <T extends Enum<T>> void writeEnum(FieldDescriptor fd, T value) throws IOException {
        BaseMarshallerDelegate<Class<?>> marshallerDelegate = this.serCtx.getMarshallerDelegate(value.getClass());
        marshallerDelegate.marshall(this.messageContext.out, fd, (Class<?>)((Object)value));
    }

    @Override
    public <E> void writeCollection(String fieldName, Collection<? super E> collection, Class<E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (collection == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case GROUP: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeGroup(fd, t, elementClass);
                }
                break;
            }
            case MESSAGE: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeMessage(fd, t, elementClass);
                }
                break;
            }
            case ENUM: {
                for (E t : collection) {
                    this.validateElement(t, elementClass);
                    this.writeEnum(fd, (Enum)t);
                }
                break;
            }
            case DOUBLE: {
                this.validateElementClass(elementClass, Double.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeDouble(fieldNumber, (Double)value);
                }
                break;
            }
            case FLOAT: {
                this.validateElementClass(elementClass, Float.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFloat(fieldNumber, ((Float)value).floatValue());
                }
                break;
            }
            case BOOL: {
                this.validateElementClass(elementClass, Boolean.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeBool(fieldNumber, (Boolean)value);
                }
                break;
            }
            case STRING: {
                this.validateElementClass(elementClass, String.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeString(fieldNumber, (String)value);
                }
                break;
            }
            case BYTES: {
                this.validateElementClass(elementClass, byte[].class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeBytes(fieldNumber, (byte[])value);
                }
                break;
            }
            case INT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case UINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeUInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case FIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SFIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case INT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case FIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case UINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeUInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SFIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : collection) {
                    this.validateElement(value, elementClass);
                    out.writeSInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    @Override
    public <E> void writeArray(String fieldName, E[] array, Class<? extends E> elementClass) throws IOException {
        FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkRepeatedFieldWrite(fd);
        if (array == null) {
            return;
        }
        TagWriterImpl out = this.messageContext.out;
        int fieldNumber = fd.getNumber();
        switch (fd.getType()) {
            case GROUP: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeGroup(fd, t, elementClass);
                }
                break;
            }
            case MESSAGE: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeMessage(fd, t, elementClass);
                }
                break;
            }
            case ENUM: {
                for (E t : array) {
                    this.validateElement(t, elementClass);
                    this.writeEnum(fd, (Enum)t);
                }
                break;
            }
            case DOUBLE: {
                this.validateElementClass(elementClass, Double.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeDouble(fieldNumber, (Double)value);
                }
                break;
            }
            case FLOAT: {
                this.validateElementClass(elementClass, Float.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFloat(fieldNumber, ((Float)value).floatValue());
                }
                break;
            }
            case BOOL: {
                this.validateElementClass(elementClass, Boolean.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeBool(fieldNumber, (Boolean)value);
                }
                break;
            }
            case STRING: {
                this.validateElementClass(elementClass, String.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeString(fieldNumber, (String)value);
                }
                break;
            }
            case BYTES: {
                this.validateElementClass(elementClass, byte[].class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeBytes(fieldNumber, (byte[])value);
                }
                break;
            }
            case INT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case UINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeUInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case FIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SFIXED64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed64(fieldNumber, (Long)value);
                }
                break;
            }
            case SINT64: {
                this.validateElementClass(elementClass, Long.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSInt64(fieldNumber, (Long)value);
                }
                break;
            }
            case INT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case FIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case UINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeUInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SFIXED32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSFixed32(fieldNumber, (Integer)value);
                }
                break;
            }
            case SINT32: {
                this.validateElementClass(elementClass, Integer.class);
                for (E value : array) {
                    this.validateElement(value, elementClass);
                    out.writeSInt32(fieldNumber, (Integer)value);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + fd.getFullName());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <K, V> void writeMap(String fieldName, Map<? super K, ? super V> map, Class<K> keyClass, Class<V> valueClass) throws IOException {
        md = (MapDescriptor)this.messageContext.getFieldByName(fieldName);
        if (map == null) {
            return;
        }
        fieldNumber = md.getNumber();
lbl5:
        // 36 sources

        block59: for (Map.Entry<K, V> entry : map.entrySet()) {
            key = entry.getKey();
            this.validateElement(key, keyClass);
            out = this.messageContext.out.subWriter(fieldNumber, true);
            try {
                switch (1.$SwitchMap$org$infinispan$protostream$descriptors$Type[md.getKeyType().ordinal()]) {
                    case 16: {
                        out.writeBool(1, (Boolean)key);
                        break;
                    }
                    case 1: {
                        out.writeInt32(1, (Integer)key);
                        break;
                    }
                    case 6: {
                        out.writeInt64(1, (Long)key);
                        break;
                    }
                    case 2: {
                        out.writeFixed32(1, (Integer)key);
                        break;
                    }
                    case 8: {
                        out.writeFixed64(1, (Long)key);
                        break;
                    }
                    case 5: {
                        out.writeSInt32(1, (Integer)key);
                        break;
                    }
                    case 10: {
                        out.writeSInt64(1, (Long)key);
                        break;
                    }
                    case 4: {
                        out.writeSFixed32(1, (Integer)key);
                        break;
                    }
                    case 9: {
                        out.writeSFixed64(1, (Long)key);
                        break;
                    }
                    case 3: {
                        out.writeUInt32(1, (Integer)key);
                        break;
                    }
                    case 7: {
                        out.writeUInt64(1, (Long)key);
                        break;
                    }
                    case 17: {
                        out.writeString(1, (String)key);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + md.getFullName());
                    }
                }
                value = entry.getValue();
                if (value == null) {
                    switch (1.$SwitchMap$org$infinispan$protostream$descriptors$Type[md.getType().ordinal()]) {
                        case 16: {
                            out.writeBool(2, false);
                            continue block59;
                        }
                        case 1: {
                            out.writeInt32(2, 0);
                            continue block59;
                        }
                        case 6: {
                            out.writeInt64(2, 0L);
                            continue block59;
                        }
                        case 2: {
                            out.writeFixed32(2, 0);
                            continue block59;
                        }
                        case 8: {
                            out.writeFixed64(2, 0L);
                            continue block59;
                        }
                        case 5: {
                            out.writeSInt32(2, 0);
                            continue block59;
                        }
                        case 10: {
                            out.writeSInt64(2, 0L);
                            continue block59;
                        }
                        case 4: {
                            out.writeSFixed32(2, 0);
                            continue block59;
                        }
                        case 9: {
                            out.writeSFixed64(2, 0L);
                            continue block59;
                        }
                        case 3: {
                            out.writeUInt32(2, 0);
                            continue block59;
                        }
                        case 7: {
                            out.writeUInt64(2, 0L);
                            continue block59;
                        }
                        case 14: {
                            out.writeDouble(2, 0.0);
                            continue block59;
                        }
                        case 15: {
                            out.writeFloat(2, 0.0f);
                            continue block59;
                        }
                        case 17: {
                            out.writeString(2, "");
                            continue block59;
                        }
                        case 18: {
                            out.writeBytes(2, new byte[0]);
                            continue block59;
                        }
                        case 13: {
                            out.writeEnum(2, 0);
                            continue block59;
                        }
                        default: {
                            throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + md.getFullName());
                        }
                    }
                }
                switch (1.$SwitchMap$org$infinispan$protostream$descriptors$Type[md.getType().ordinal()]) {
                    case 16: {
                        out.writeBool(2, (Boolean)value);
                        ** break;
                    }
                    case 1: {
                        out.writeInt32(2, (Integer)value);
                        ** break;
                    }
                    case 6: {
                        out.writeInt64(2, (Long)value);
                        ** break;
                    }
                    case 2: {
                        out.writeFixed32(2, (Integer)value);
                        ** break;
                    }
                    case 8: {
                        out.writeFixed64(2, (Long)value);
                        ** break;
                    }
                    case 5: {
                        out.writeSInt32(2, (Integer)value);
                        ** break;
                    }
                    case 10: {
                        out.writeSInt64(2, (Long)value);
                        ** break;
                    }
                    case 4: {
                        out.writeSFixed32(2, (Integer)value);
                        ** break;
                    }
                    case 9: {
                        out.writeSFixed64(2, (Long)value);
                        ** break;
                    }
                    case 3: {
                        out.writeUInt32(2, (Integer)value);
                        ** break;
                    }
                    case 7: {
                        out.writeUInt64(2, (Long)value);
                        ** break;
                    }
                    case 17: {
                        out.writeString(2, (String)value);
                        ** break;
                    }
                    case 18: {
                        out.writeBytes(2, (byte[])value);
                        ** break;
                    }
                    case 13: {
                        out.writeEnum(2, ((Enum)value).ordinal());
                        ** break;
                    }
                    case 12: {
                        marshallerDelegate = this.serCtx.getMarshallerDelegate(valueClass);
                        nestedWriter = out.subWriter(2, true);
                        try {
                            marshallerDelegate.marshall((TagWriterImpl)nestedWriter, md, (Class<V>)value);
                            continue block59;
                        }
                        finally {
                            if (nestedWriter == null) continue block59;
                            nestedWriter.close();
                            continue block59;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + md.getFullName());
                    }
                }
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private void validateElementClass(Class<?> elementClass, Class<?> expectedElementClass) {
        if (elementClass != expectedElementClass) {
            throw new IllegalArgumentException("elementClass argument should be " + expectedElementClass.getCanonicalName());
        }
    }

    private void validateElement(Object element, Class<?> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException("Collection or array element cannot be null");
        }
        if (element.getClass() != elementClass) {
            throw new IllegalArgumentException("Collection or array element is expected to be an instance of " + elementClass.getCanonicalName());
        }
    }

    private void checkFieldWrite(FieldDescriptor fd) {
        if (fd.isRepeated()) {
            throw new IllegalStateException("A repeated field should be written with one of the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be written twice : " + fd.getFullName());
        }
        if (this.serCtx.getConfiguration().logOutOfSequenceWrites() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldWriteOutOfSequence(fd.getFullName());
        }
    }

    private void checkRepeatedFieldWrite(FieldDescriptor fd) {
        if (!fd.isRepeated()) {
            throw new IllegalStateException("This field is not repeated and cannot be written with the methods intended for collections or arrays: " + fd.getFullName());
        }
        if (!this.messageContext.markField(fd.getNumber())) {
            throw new IllegalStateException("A field cannot be written twice : " + fd.getFullName());
        }
        if (this.serCtx.getConfiguration().logOutOfSequenceWrites() && log.isEnabled(Logger.Level.WARN) && this.messageContext.getMaxSeenFieldNumber() > fd.getNumber()) {
            log.fieldWriteOutOfSequence(fd.getFullName());
        }
    }

    static final class WriteMessageContext
    extends MessageContext<WriteMessageContext> {
        final TagWriterImpl out;

        WriteMessageContext(WriteMessageContext parent, FieldDescriptor fieldDescriptor, Descriptor messageDescriptor, TagWriterImpl out) {
            super(parent, fieldDescriptor, messageDescriptor);
            this.out = out;
        }
    }
}

