/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class SmallIntMap<V> {
    private static final int DEFAULT_ARRAY_THRESHOLD = 4096;
    private volatile V[] array;
    private Map<Integer, V> map;
    private final StampedLock lock = new StampedLock();

    public SmallIntMap() {
        this(4096);
    }

    public SmallIntMap(int arrayThreshold) {
        this.array = new Object[arrayThreshold];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(int key, V value) {
        long stamp = this.lock.writeLock();
        try {
            if (key >= 0 && key < this.array.length) {
                V oldValue = this.array[key];
                if (oldValue == value) {
                    V v = oldValue;
                    return v;
                }
                V[] newArray = Arrays.copyOf(this.array, this.array.length);
                newArray[key] = value;
                this.array = newArray;
                V v = oldValue;
                return v;
            }
            if (this.map == null) {
                this.map = new HashMap<Integer, V>();
            }
            V v = this.map.put(key, value);
            return v;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void putAll(Map<? extends Integer, ? extends V> m) {
        long stamp = this.lock.writeLock();
        try {
            V[] newArray = null;
            for (Map.Entry<Integer, V> e : m.entrySet()) {
                int key = e.getKey();
                V value = e.getValue();
                if (key >= 0 && key < this.array.length) {
                    void oldValue;
                    if (newArray == null) {
                        newArray = Arrays.copyOf(this.array, this.array.length);
                    }
                    if ((oldValue = newArray[key]) == value) continue;
                    newArray[key] = value;
                    continue;
                }
                if (this.map == null) {
                    this.map = new HashMap<Integer, V>();
                }
                this.map.put(key, value);
            }
            if (newArray != null) {
                this.array = newArray;
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int key) {
        if (key >= 0 && key < this.array.length) {
            return this.array[key];
        }
        long stamp = this.lock.readLock();
        try {
            if (this.map == null) {
                V v = null;
                return v;
            }
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(int key) {
        long stamp = this.lock.writeLock();
        try {
            if (key >= 0 && key < this.array.length) {
                V oldValue = this.array[key];
                if (oldValue == null) {
                    V v = null;
                    return v;
                }
                V[] newArray = Arrays.copyOf(this.array, this.array.length);
                newArray[key] = null;
                this.array = newArray;
                V v = oldValue;
                return v;
            }
            if (this.map == null) {
                V v = null;
                return v;
            }
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.array = new Object[this.array.length];
            if (this.map != null) {
                this.map.clear();
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

