/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.SchemaWriter;
import org.infinispan.protostream.schema.Syntax;

class SchemaByBuilder
implements Schema {
    private final Syntax syntax;
    private final String name;
    private final String packageName;
    private final List<Enum> enums;
    private final List<Message> messages;
    private final Map<String, Object> options;
    private final List<String> comments;
    private final List<String> dependencies;
    private final List<String> publicDependencies;

    SchemaByBuilder(Schema.Builder builder) {
        this.syntax = builder.syntax;
        this.dependencies = List.copyOf(builder.dependencies);
        this.publicDependencies = List.copyOf(builder.publicDependencies);
        this.name = builder.name;
        this.packageName = builder.packageName;
        this.options = Map.copyOf(builder.options);
        this.enums = builder.enums.values().stream().map(Enum.Builder::create).toList();
        this.messages = builder.messages.values().stream().map(Message.Builder::create).toList();
        this.comments = List.copyOf(builder.comments);
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContent() {
        return this.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<Enum> getEnums() {
        return this.enums;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getPublicDependencies() {
        return this.publicDependencies;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public String toString() {
        try {
            StringWriter w = new StringWriter();
            new SchemaWriter().write((Writer)w, (Schema)this);
            return w.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

