/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.spi;

import jakarta.persistence.criteria.Predicate;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.predicate.SqmJunctionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.spi.NavigablePath;

public class SqmCreationHelper {
    public static final String IMPLICIT_ALIAS = "{implicit}";
    private static final AtomicLong UNIQUE_ID_COUNTER = new AtomicLong();

    public static NavigablePath buildRootNavigablePath(String base, String alias) {
        return new NavigablePath(base, SqmCreationHelper.determineAlias(alias));
    }

    public static NavigablePath buildSubNavigablePath(NavigablePath lhs, String base, String alias) {
        return lhs.append(base, SqmCreationHelper.determineAlias(alias));
    }

    public static String acquireUniqueAlias() {
        return Long.toString(UNIQUE_ID_COUNTER.incrementAndGet());
    }

    public static String determineAlias(String alias) {
        if (alias == null) {
            return SqmCreationHelper.acquireUniqueAlias();
        }
        if (alias == IMPLICIT_ALIAS) {
            return null;
        }
        return alias;
    }

    public static NavigablePath buildSubNavigablePath(SqmPath<?> lhs, String subNavigable, String alias) {
        if (lhs == null) {
            throw new IllegalArgumentException("`lhs` cannot be null for a sub-navigable reference - " + subNavigable);
        }
        NavigablePath navigablePath = lhs.getNavigablePath();
        if (lhs.getResolvedModel() instanceof PluralPersistentAttribute && CollectionPart.Nature.fromName(subNavigable) == null) {
            navigablePath = navigablePath.append(CollectionPart.Nature.ELEMENT.getName());
        }
        return SqmCreationHelper.buildSubNavigablePath(navigablePath, subNavigable, alias);
    }

    public static SqmPredicate combinePredicates(SqmPredicate baseRestriction, List<Predicate> incomingRestrictions) {
        if (CollectionHelper.isEmpty(incomingRestrictions)) {
            return baseRestriction;
        }
        SqmPredicate combined = SqmCreationHelper.combinePredicates(null, baseRestriction);
        for (int i = 0; i < incomingRestrictions.size(); ++i) {
            combined = SqmCreationHelper.combinePredicates(combined, (SqmPredicate)incomingRestrictions.get(i));
        }
        return combined;
    }

    public static SqmPredicate combinePredicates(SqmPredicate baseRestriction, JpaPredicate ... incomingRestrictions) {
        if (CollectionHelper.isEmpty(incomingRestrictions)) {
            return baseRestriction;
        }
        SqmPredicate combined = SqmCreationHelper.combinePredicates(null, baseRestriction);
        for (int i = 0; i < incomingRestrictions.length; ++i) {
            combined = SqmCreationHelper.combinePredicates(combined, incomingRestrictions[i]);
        }
        return combined;
    }

    public static SqmPredicate combinePredicates(SqmPredicate baseRestriction, Predicate ... incomingRestrictions) {
        if (CollectionHelper.isEmpty(incomingRestrictions)) {
            return baseRestriction;
        }
        SqmPredicate combined = SqmCreationHelper.combinePredicates(null, baseRestriction);
        for (int i = 0; i < incomingRestrictions.length; ++i) {
            combined = SqmCreationHelper.combinePredicates(combined, incomingRestrictions[i]);
        }
        return combined;
    }

    public static SqmPredicate combinePredicates(SqmPredicate baseRestriction, SqmPredicate incomingRestriction) {
        SqmJunctionPredicate combinedPredicate;
        if (baseRestriction == null) {
            return incomingRestriction;
        }
        if (incomingRestriction == null) {
            return baseRestriction;
        }
        if (baseRestriction instanceof SqmJunctionPredicate) {
            SqmJunctionPredicate junction = (SqmJunctionPredicate)baseRestriction;
            if (junction.getPredicates().isEmpty()) {
                return incomingRestriction;
            }
            if (junction.getOperator() == Predicate.BooleanOperator.AND) {
                combinedPredicate = junction;
            } else {
                combinedPredicate = new SqmJunctionPredicate(Predicate.BooleanOperator.AND, baseRestriction.getExpressible(), baseRestriction.nodeBuilder());
                combinedPredicate.getPredicates().add(baseRestriction);
            }
        } else {
            combinedPredicate = new SqmJunctionPredicate(Predicate.BooleanOperator.AND, baseRestriction.getExpressible(), baseRestriction.nodeBuilder());
            combinedPredicate.getPredicates().add(baseRestriction);
        }
        combinedPredicate.getPredicates().add(incomingRestriction);
        return combinedPredicate;
    }

    private SqmCreationHelper() {
    }
}

