/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import java.util.List;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.vault.core.VaultTemplate;

public class SpringVaultTemplateBuilder {
    private final ConfigTokenProvider configTokenProvider;
    private final List<SpringVaultClientAuthenticationProvider> authProviders;
    private final ApplicationContext applicationContext;

    public SpringVaultTemplateBuilder(ConfigTokenProvider configTokenProvider, List<SpringVaultClientAuthenticationProvider> authProviders, ApplicationContext applicationContext) {
        this.configTokenProvider = configTokenProvider;
        this.authProviders = authProviders;
        this.applicationContext = applicationContext;
    }

    public VaultTemplate build(VaultEnvironmentProperties vaultProperties) {
        ConfigTokenProvider tokenProvider = this.isStaticToken(vaultProperties) ? vaultProperties::getToken : this.configTokenProvider;
        SpringVaultClientConfiguration clientConfiguration = new SpringVaultClientConfiguration(vaultProperties, tokenProvider, this.authProviders);
        clientConfiguration.setApplicationContext(this.applicationContext);
        VaultTemplate vaultTemplate = clientConfiguration.vaultTemplate();
        vaultTemplate.setSessionManager(clientConfiguration.sessionManager());
        return vaultTemplate;
    }

    private boolean isStaticToken(VaultEnvironmentProperties vaultProperties) {
        return vaultProperties.getAuthentication() == null && StringUtils.hasText((String)vaultProperties.getToken());
    }
}

