/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.blocks.cs.BaseServer;

public abstract class Connection
implements Closeable {
    public static final byte[] cookie = new byte[]{98, 101, 108, 97};
    protected BaseServer server;
    protected Address peer_addr;
    protected long last_access;
    protected final Lock send_lock = new ReentrantLock();

    public abstract boolean isConnected();

    public abstract boolean isConnectionPending();

    public abstract boolean isClosed();

    public abstract Address localAddress();

    public Address peerAddress() {
        return this.peer_addr;
    }

    public abstract void flush();

    public abstract void connect(Address var1) throws Exception;

    public abstract void start() throws Exception;

    public abstract void send(byte[] var1, int var2, int var3) throws Exception;

    public abstract void send(ByteBuffer var1) throws Exception;

    public abstract String status();

    protected long getTimestamp() {
        return this.server.timeService() != null ? this.server.timeService().timestamp() : System.nanoTime();
    }

    protected void updateLastAccessed() {
        if (this.server.connExpireTime() > 0L) {
            this.last_access = this.getTimestamp();
        }
    }

    public boolean isExpired(long now) {
        return this.server.connExpireTime() > 0L && now - this.last_access >= this.server.connExpireTime();
    }
}

