/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonArrayBuilderImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;

class JsonBuilderFactoryImpl
implements JsonBuilderFactory,
Serializable {
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private BufferStrategy.BufferProvider<char[]> bufferProvider;
    private static final String[] SUPPORTED_CONFIG_KEYS = new String[0];

    protected JsonBuilderFactoryImpl() {
    }

    JsonBuilderFactoryImpl(Map<String, ?> config, BufferStrategy.BufferProvider<char[]> bufferProvider) {
        this.bufferProvider = bufferProvider;
        if (config != null && config.size() > 0) {
            List<String> supportedConfigKeys = Arrays.asList(SUPPORTED_CONFIG_KEYS);
            for (String configKey : config.keySet()) {
                if (supportedConfigKeys.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
    }

    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(Collections.emptyMap(), this.bufferProvider);
    }

    public JsonObjectBuilder createObjectBuilder(JsonObject initialData) {
        return new JsonObjectBuilderImpl(initialData, this.bufferProvider);
    }

    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(Collections.emptyList(), this.bufferProvider);
    }

    public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
        return new JsonArrayBuilderImpl(initialData, this.bufferProvider);
    }

    public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
        return new JsonArrayBuilderImpl(initialData, this.bufferProvider);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    public JsonObjectBuilder createObjectBuilder(Map<String, Object> initialValues) {
        return new JsonObjectBuilderImpl(initialValues, this.bufferProvider);
    }
}

