/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Type;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypeUtils;
import org.joda.convert.TypedStringConverter;
import org.joda.convert.Types;

final class TypeStringConverterFactory
implements StringConverterFactory {
    static final TypeStringConverterFactory INSTANCE = new TypeStringConverterFactory();

    private TypeStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (Type.class.isAssignableFrom(cls) && cls != Class.class) {
            return new TypeStringConverter(cls);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static final class TypeStringConverter
    implements TypedStringConverter<Type> {
        private final Class<?> effectiveType;

        TypeStringConverter(Class<?> effectiveType) {
            this.effectiveType = effectiveType;
        }

        @Override
        public String convertToString(Type type) {
            try {
                return Types.toString(type);
            }
            catch (Exception ex) {
                return type.toString();
            }
        }

        @Override
        public Type convertFromString(Class<? extends Type> cls, String str) {
            return TypeUtils.parse(str);
        }

        @Override
        public Class<?> getEffectiveType() {
            return this.effectiveType;
        }
    }
}

