/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import io.netty.util.internal.logging.InternalLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.rzo.yajsw.util.CommonsLoggingAdapter;
import org.rzo.yajsw.util.File;

public class VFSUtils {
    static DefaultFileSystemManager fsManager = null;
    static FileSystemOptions opts = new FileSystemOptions();

    public static void init() throws FileSystemException {
        if (fsManager != null) {
            return;
        }
        fsManager = (DefaultFileSystemManager)VFS.getManager();
        String httpProxy = System.getProperty("http.proxyHost");
        String httpPort = System.getProperty("http.proxyPort");
        if (httpProxy != null) {
            HttpFileSystemConfigBuilder.getInstance().setProxyHost(opts, httpProxy);
            int port = 8080;
            if (httpPort != null) {
                try {
                    port = Integer.parseInt(httpPort);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            HttpFileSystemConfigBuilder.getInstance().setProxyPort(opts, port);
        }
    }

    public static void setLogger(InternalLogger logger) {
        fsManager.setLogger((Log)new CommonsLoggingAdapter(logger));
    }

    public static FileObject resolveFile(String file) throws FileSystemException {
        VFSUtils.init();
        return fsManager.resolveFile(file);
    }

    public static FileObject resolveFile(String base, String file) throws FileSystemException {
        VFSUtils.init();
        FileObject basef = null;
        if (base != null) {
            basef = fsManager.resolveFile((java.io.File)new File("."), base);
        }
        return VFSUtils.resolveFile(basef, file);
    }

    public static long getLastModifiedTime(FileObject file) {
        try {
            return file.getContent().getLastModifiedTime();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static FileObject resolveFile(FileObject basef, String file) throws FileSystemException {
        VFSUtils.init();
        if (basef != null) {
            return fsManager.resolveFile(basef, file, opts);
        }
        return fsManager.resolveFile(file, opts);
    }

    public static List<FileObject> resolveFiles(String value) throws Exception {
        VFSUtils.init();
        return VFSUtils.resolveFiles(fsManager.resolveFile(new File(".").getAbsolutePath()), value);
    }

    public static List<FileObject> resolveFiles(FileObject basef, String value) throws Exception {
        VFSUtils.init();
        return VFSUtils.resolveFiles(basef, value, fsManager);
    }

    public static List<FileObject> resolveFiles(FileObject basef, String value, DefaultFileSystemManager fsManager) {
        System.out.println("resolve files " + value);
        try {
            int iquest;
            ArrayList<FileObject> result = new ArrayList<FileObject>();
            if (!value.contains("?") && !value.contains("*")) {
                result.add(VFSUtils.resolveFile(basef, value));
                return result;
            }
            String pattern = value.replaceAll("\\.", "\\\\.");
            if ((pattern = pattern.replaceAll("\\?", ".")).contains("/**/")) {
                pattern = pattern.replaceAll("/\\*\\*/", "/*/");
            }
            pattern = pattern.replaceAll("\\*", ".*");
            pattern = basef.getName().getPath() + "/" + pattern;
            final Pattern pat = Pattern.compile(pattern);
            int istar = value.indexOf("*");
            if (istar <= 0) {
                istar = Integer.MAX_VALUE;
            }
            if ((iquest = value.indexOf("?")) <= 0) {
                iquest = Integer.MAX_VALUE;
            }
            int i = Math.min(istar, iquest);
            String prefix = null;
            if (i < Integer.MAX_VALUE) {
                prefix = value.substring(0, i);
            }
            int depth = 0;
            if (value.contains("**/")) {
                depth = Integer.MAX_VALUE;
            } else {
                while ((i = value.indexOf("*/")) != -1) {
                    ++depth;
                    value = value.substring(i + 2);
                }
            }
            final int fdepth = depth;
            FileSelector fs = new FileSelector(){

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    if (info.getFile().getType() == FileType.IMAGINARY) {
                        return false;
                    }
                    boolean result = pat.matcher(info.getFile().getName().getPath()).matches();
                    System.out.println(info.getFile().getName().getPath() + " " + result);
                    return result;
                }

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return info.getDepth() <= fdepth;
                }
            };
            FileObject nbase = prefix != null ? basef.resolveFile(prefix) : basef;
            FileObject[] files = nbase.findFiles(fs);
            if (files != null && files.length > 0) {
                return Arrays.asList(files);
            }
            return new ArrayList<FileObject>();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean isLocal(FileObject f) {
        if (f instanceof OnCallRefreshFileObject) {
            try {
                return f.getContent().getFile() instanceof LocalFile;
            }
            catch (FileSystemException e) {
                e.printStackTrace();
            }
        }
        return f instanceof LocalFile;
    }
}

