/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.plugin.stitch.service.engine.index.dto;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.documentation.PublicApi;

/**
 * Represent processor parameter during parsing and validation phase.
 */
@PublicApi
public interface StitchProcessorParameterDto {

  /**
   * Returns parameter name.
   * @return parameter name as {@link String}.
   */
  String getName();

  /**
   * Returns parameters value.
   * @return parameters value as {@link JsonNode}.
   */
  JsonNode getValue();

  /**
   * Returns parameters value from external file.
   * @return parameters value if value corresponds to external file as {@link String}.
   */
  String getContent();
}
