/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.bean;

import com.jeta.forms.beanmgr.BeanManager;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanDeserializer;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.properties.FontProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class DefaultBeanDeserializer
implements BeanDeserializer {
    private PropertiesMemento m_memento;

    public DefaultBeanDeserializer(PropertiesMemento propertiesMemento) {
        this.m_memento = propertiesMemento;
    }

    public PropertiesMemento getProperties() {
        return this.m_memento;
    }

    public Component createBean() throws FormException {
        try {
            Object object;
            Class clazz = null;
            try {
                object = (BeanManager)JETARegistry.lookup("jeta.forms.bean.manager");
                if (object != null) {
                    clazz = object.getBeanClass(this.m_memento.getBeanClassName());
                }
            }
            catch (Exception exception) {
                FormsLogger.severe(exception);
            }
            if (clazz == null) {
                clazz = Class.forName(this.m_memento.getBeanClassName());
            }
            object = (Component)clazz.newInstance();
            return object;
        }
        catch (Exception exception) {
            FormsLogger.severe(exception);
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    public void initializeBean(JETABean jETABean) throws FormException {
        block16: {
            if (jETABean == null) {
                return;
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Component component = jETABean.getDelegate();
                if (component instanceof JList) {
                    ((JList)component).setModel(new DefaultListModel());
                } else if (component instanceof JTable && (object3 = ((JTable)(object2 = (JTable)component)).getModel()) instanceof DefaultTableModel && ((DefaultTableModel)(object = (DefaultTableModel)object3)).getColumnCount() == 0) {
                    ((DefaultTableModel)object).addColumn("A");
                    ((DefaultTableModel)object).addColumn("B");
                    ((DefaultTableModel)object).addRow(new Object[]{"", ""});
                    ((DefaultTableModel)object).addRow(new Object[]{"", ""});
                }
                if (component == null) break block16;
                object2 = jETABean.getPropertyDescriptors();
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    object = (JETAPropertyDescriptor)object3.next();
                    try {
                        if (!this.m_memento.containsProperty(object.getName())) continue;
                        Object object4 = this.m_memento.getPropertyValue(object.getName());
                        if (object4 instanceof FontProperty) {
                            object4 = ((FontProperty)object4).getFont();
                        } else if (object4 instanceof ColorHolder) {
                            object4 = ((ColorHolder)object4).getColor();
                        }
                        object.setPropertyValue(jETABean, this.convertValue(object.getPropertyType(), object4));
                    }
                    catch (Exception exception) {
                        FormsLogger.debug(exception);
                    }
                }
                try {
                    if (this.m_memento.containsProperty("name")) {
                        component.setName((String)this.m_memento.getPropertyValue("name"));
                    }
                }
                catch (Exception exception) {
                    FormsLogger.severe(exception);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof FormException) {
                    throw (FormException)exception;
                }
                throw new FormException(exception);
            }
        }
    }

    private Object convertValue(Class clazz, Object object) {
        String string;
        String string2 = string = object == null ? "null" : object.getClass().getName();
        if (object instanceof String) {
            String string3 = (String)object;
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                return Boolean.valueOf(string3);
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return Byte.valueOf(string3);
            }
            if (clazz == Character.class || clazz == Character.TYPE) {
                return new Character(string3.length() == 0 ? (char)'\u0000' : string3.charAt(0));
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return Short.valueOf(string3);
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return Integer.valueOf(string3);
            }
            if (clazz == Long.class || clazz == Long.TYPE) {
                return Long.valueOf(string3);
            }
            if (clazz == Float.class || clazz == Float.TYPE) {
                return Float.valueOf(string3);
            }
            if (clazz == Double.class || clazz == Double.TYPE) {
                return Double.valueOf(string3);
            }
        }
        return object;
    }
}

