/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */

package com.xebialabs.deployit.core.rest.view;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The result of preview containing the map of deployeds with Invocation Descriptions.
 */
@PublicApiRef
public class PreviewResult extends AbstractDto {
  Map<String, List<InvocationDescriptorView>> deployedMap  = new HashMap<>();

  public PreviewResult() {
  }

  public PreviewResult(Map<String, List<InvocationDescriptorView>> deployedMap) {
    this.deployedMap = deployedMap;
  }

  /**
   * Returns map of deployeds with Invocation Descriptions.
   *
   * @return The map of deployeds with Invocation Descriptions.
   */
  public Map<String, List<InvocationDescriptorView>> getDeployedMap() {
    return deployedMap;
  }

  /**
   * Sets map of deployeds with Invocation Descriptions.
   *
   * @param deployedMap The deployedMap of deployeds with Invocation Descriptions.
   */
  public void setDeployedMap(Map<String, List<InvocationDescriptorView>> deployedMap) {
    this.deployedMap = deployedMap;
  }
}
