/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.common;

import com.jeta.forms.gui.common.FormSpecDefinition;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.common.parsers.FormSpecParser;
import com.jeta.forms.logger.FormsLogger;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.util.StringTokenizer;

public class FormSpecAdapter
implements FormSpecDefinition,
Externalizable {
    private int m_version = 1;
    public static final int VERSION_ID = 1;
    private String m_alignment;
    private String m_size_type;
    private double m_constant_size;
    private String m_constant_units;
    private String m_component_size;
    private String m_bounded_size;
    private String m_resize;
    private double m_resize_weight = 1.0;

    public FormSpecAdapter(ColumnSpec columnSpec) {
        this(columnSpec.toString());
    }

    public FormSpecAdapter(RowSpec rowSpec) {
        this(rowSpec.toString());
    }

    public FormSpecAdapter(String string) {
        try {
            StringReader stringReader = new StringReader(string);
            FormSpecParser formSpecParser = new FormSpecParser(stringReader);
            formSpecParser.parse();
            this.m_alignment = formSpecParser.m_alignment;
            this.m_size_type = formSpecParser.m_size_type;
            this.m_constant_units = formSpecParser.m_constant_units;
            this.m_component_size = formSpecParser.m_component_size;
            this.m_bounded_size = formSpecParser.m_bounded_size;
            this.m_resize = formSpecParser.m_resize;
            try {
                this.m_constant_size = Double.parseDouble(formSpecParser.m_constant_size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.m_resize_weight = Double.parseDouble(formSpecParser.m_resize_weight);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            FormsLogger.severe(throwable);
        }
    }

    public static String fixup(String string) {
        try {
            FormSpecAdapter formSpecAdapter = new FormSpecAdapter(string);
            return FormUtils.toEncodedString(formSpecAdapter);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String fixupSpecs(String string) {
        if (string == null) {
            System.out.println("FormSpecAdapter.fixupSpecs  specs=null!");
            FormUtils.safeAssert(false);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(FormSpecAdapter.fixup(string2));
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getAlignment() {
        return this.m_alignment;
    }

    public String getSizeType() {
        return this.m_size_type;
    }

    public String getConstantUnits() {
        return this.m_constant_units;
    }

    public double getConstantSize() {
        return this.m_constant_size;
    }

    public String getComponentSize() {
        return this.m_component_size;
    }

    public String getBoundedSize() {
        return this.m_bounded_size;
    }

    public boolean isBoundedMinimum() {
        return "MIN".equalsIgnoreCase(this.m_bounded_size);
    }

    public boolean isBoundedMaximum() {
        return "MAX".equalsIgnoreCase(this.m_bounded_size);
    }

    public boolean isIntegralUnits() {
        return FormUtils.isIntegralUnits(this.m_constant_units);
    }

    public String getResize() {
        return this.m_resize;
    }

    public boolean isResizeNone() {
        return "NONE".equalsIgnoreCase(this.m_resize);
    }

    public boolean isResizeGrow() {
        return "GROW".equalsIgnoreCase(this.m_resize);
    }

    public double getResizeWeight() {
        return this.m_resize_weight;
    }

    public boolean isBoundedSize() {
        return "BOUNDED".equals(this.m_size_type);
    }

    public boolean isComponentSize() {
        return "COMPONENT".equals(this.m_size_type);
    }

    public boolean isConstantSize() {
        return "CONSTANT".equals(this.m_size_type);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.m_version = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.m_version);
    }
}

