/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

final class SecurityActions {
    private SecurityActions() {
        throw new InstantiationError("Must not instantiate this class");
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    static String getSystemProperty(String name) {
        return SecurityActions.doPrivileged(() -> System.getProperty(name));
    }

    public static Properties getSystemProperties() {
        return SecurityActions.doPrivileged(System::getProperties);
    }
}

