/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.bridge;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.oio.OioDatagramChannel;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.mcast.MulticastEndpoint;

public class MulticastAdapter {
    private static Channel channel;
    private static MulticastEndpoint mcast;
    private static long RECONNECT_DELAY;
    private static Timer timer;
    private static Bootstrap bootstrap;

    public static void main(String[] args) throws Exception {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        bootstrap = new Bootstrap();
        OioEventLoopGroup group = new OioEventLoopGroup();
        bootstrap.group((EventLoopGroup)group);
        bootstrap.channel(OioDatagramChannel.class);
        bootstrap.remoteAddress((SocketAddress)new InetSocketAddress(host, port));
        bootstrap.handler((ChannelHandler)new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() {
                return ChannelPipelineFactory.handlerList(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (mcast != null && mcast.isInit()) {
                            mcast.send((ByteBuf)msg);
                        }
                    }

                    public void channelActive(ChannelHandlerContext ctx) {
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                bootstrap.connect();
                            }
                        }, RECONNECT_DELAY);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ConnectException) {
                            System.out.println("conection lost: reconnecting...");
                        }
                        ctx.channel().close();
                    }
                }});
            }
        });
        ChannelFuture f = bootstrap.connect();
        channel = f.sync().channel();
        mcast.init(new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() {
                return ChannelPipelineFactory.handlerList(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        ByteBuf b = mcast.getMessage((ByteBuf)msg);
                        if (b == null) {
                            return;
                        }
                        if (channel != null && channel.isActive()) {
                            channel.write((Object)b);
                        }
                    }
                }});
            }
        });
    }

    static {
        mcast = new MulticastEndpoint();
        RECONNECT_DELAY = 5000L;
        timer = new Timer();
    }
}

