/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.GenericType;
import com.github.drapostolos.typeparser.InputPreprocessor;
import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.TypeParserUtility;

public final class TypeParserBuilder {
    Parsers parsers;
    SplitStrategy splitStrategy = TypeParserUtility.defaultSplitStrategy();
    SplitStrategy keyValueSplitStrategy = TypeParserUtility.defaultKeyValueSplitStrategy();
    InputPreprocessor inputPreprocessor = TypeParserUtility.defaultInputPreprocessor();

    TypeParserBuilder() {
        this.parsers = Parsers.copyDefault();
    }

    public TypeParserBuilder unregisterParser(Class<?> targetType) {
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.parsers.remove(targetType);
        return this;
    }

    public <T> TypeParserBuilder unregisterParser(GenericType<T> targetType) {
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.parsers.remove(targetType.getType());
        return this;
    }

    public TypeParserBuilder unregisterParserForTypesAssignableTo(Class<?> targetType) {
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.assignableParsers.remove(targetType);
        return this;
    }

    public <T> TypeParserBuilder registerParser(Class<T> targetType, Parser<T> parser) {
        if (parser == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("parser"));
        }
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.parsers.put(targetType, parser);
        return this;
    }

    public TypeParserBuilder registerParserForTypesAssignableTo(Class<?> targetType, Parser<?> parser) {
        if (parser == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("parser"));
        }
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.assignableParsers.put(targetType, parser);
        return this;
    }

    public <T> TypeParserBuilder registerParser(GenericType<T> targetType, Parser<T> parser) {
        if (parser == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("parser"));
        }
        if (targetType == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.parsers.put(targetType.getType(), parser);
        return this;
    }

    public TypeParserBuilder setSplitStrategy(SplitStrategy splitStrategy) {
        if (splitStrategy == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("splitStrategy"));
        }
        this.splitStrategy = splitStrategy;
        return this;
    }

    public TypeParserBuilder setKeyValueSplitStrategy(SplitStrategy splitStrategy) {
        if (splitStrategy == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("splitStrategy"));
        }
        this.keyValueSplitStrategy = splitStrategy;
        return this;
    }

    public TypeParserBuilder setInputPreprocessor(InputPreprocessor inputPreprocessor) {
        if (inputPreprocessor == null) {
            throw new NullPointerException(TypeParserUtility.makeNullArgumentErrorMsg("inputPreprocessor"));
        }
        this.inputPreprocessor = inputPreprocessor;
        return this;
    }

    public TypeParser build() {
        return new TypeParser(this);
    }
}

