/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.PrioritizedService;

public class ConnectionServiceFactory {
    private static ConnectionServiceFactory instance;
    private List<DatabaseConnection> databaseConnections = new ArrayList<DatabaseConnection>();

    public static synchronized void reset() {
        instance = new ConnectionServiceFactory();
    }

    public static synchronized ConnectionServiceFactory getInstance() {
        if (instance == null) {
            instance = new ConnectionServiceFactory();
        }
        return instance;
    }

    public DatabaseConnection create(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        DatabaseConnection databaseConnection = this.getDatabaseConnection();
        try {
            databaseConnection.open(url, driverObject, driverProperties);
        }
        catch (Exception sqle) {
            throw new DatabaseException(sqle);
        }
        return databaseConnection;
    }

    public DatabaseConnection getDatabaseConnection() {
        TreeSet<DatabaseConnection> sortedConnections = new TreeSet<DatabaseConnection>(new Comparator<DatabaseConnection>(){

            @Override
            public int compare(DatabaseConnection o1, DatabaseConnection o2) {
                return -1 * Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        sortedConnections.addAll(this.databaseConnections);
        try {
            DatabaseConnection connection;
            DatabaseConnection exampleService = (DatabaseConnection)sortedConnections.iterator().next();
            Class<?> aClass = exampleService.getClass();
            try {
                aClass.getConstructor(new Class[0]);
                connection = (DatabaseConnection)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                connection = exampleService;
            }
            return connection;
        }
        catch (Exception e3) {
            throw new UnexpectedLiquibaseException(e3);
        }
    }

    private ConnectionServiceFactory() {
        try {
            List<DatabaseConnection> connections = Scope.getCurrentScope().getServiceLocator().findInstances(DatabaseConnection.class);
            for (DatabaseConnection connection : connections) {
                this.register((DatabaseConnection)connection.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public void register(DatabaseConnection databaseConnection) {
        this.databaseConnections.add(databaseConnection);
        Collections.sort(this.databaseConnections, PrioritizedService.COMPARATOR);
    }
}

