/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.conversion;

import com.xebialabs.deployit.conversion.Coder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;

public class AESCoder
implements Coder {
    public static final String IDENTIFIER = "{aes:%s}";
    private static final String KEY_ID = "v0";

    @Override
    public String identifier() {
        return IDENTIFIER.substring(0, 4);
    }

    @Override
    public byte[] decode(byte[] encodedBytes) {
        String s1 = new String(encodedBytes, StandardCharsets.UTF_8);
        if (s1.startsWith(this.identifier())) {
            return Base64.decodeBase64((byte[])s1.substring(s1.indexOf("}") + 1).getBytes(StandardCharsets.UTF_8));
        }
        throw new RuntimeException("byte[] was not encoded with {aes:%s} unable to decode!");
    }

    @Override
    public byte[] encode(byte[] toEncode) {
        return this.encode(toEncode, KEY_ID);
    }

    @Override
    public byte[] encode(byte[] toEncode, String keyId) {
        return ArrayUtils.addAll((byte[])String.format(IDENTIFIER, keyId).getBytes(StandardCharsets.UTF_8), (byte[])Base64.encodeBase64((byte[])toEncode));
    }
}

