/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverthereConnector {
    private static final Logger logger = LoggerFactory.getLogger(OverthereConnector.class);
    final AtomicReference<Map<String, Class<? extends OverthereConnectionBuilder>>> protocols = new AtomicReference(new HashMap());

    public void registerProtocol(Class<? extends OverthereConnectionBuilder> builderClass) {
        if (!builderClass.isAnnotationPresent(Protocol.class)) {
            throw new IllegalArgumentException("The OverthereConnectionBuilder " + builderClass + " should be annotated with @Protocol");
        }
        String name = builderClass.getAnnotation(Protocol.class).name();
        this.protocols.get().put(name, builderClass);
    }

    public OverthereConnection getConnection(String protocol, ConnectionOptions options) {
        if (!this.protocols.get().containsKey(protocol)) {
            throw new IllegalArgumentException("Unknown connection protocol " + protocol);
        }
        logger.trace("Connection for protocol {} requested with the following connection options: {}", (Object)protocol, (Object)options);
        ConnectionOptions jumpstationOptions = (ConnectionOptions)options.getOptional("jumpstation");
        AddressPortMapper mapper = DefaultAddressPortMapper.INSTANCE;
        if (jumpstationOptions != null) {
            String jumpstationProtocol = jumpstationOptions.get("protocol", "ssh-jumpstation");
            if (jumpstationProtocol.equals("ssh")) {
                jumpstationProtocol = "ssh-jumpstation";
            }
            mapper = (AddressPortMapper)((Object)Overthere.getConnection(jumpstationProtocol, jumpstationOptions));
        }
        try {
            return this.buildConnection(protocol, options, mapper);
        }
        catch (RuntimeException exc) {
            OverthereUtils.closeQuietly(mapper);
            throw exc;
        }
    }

    private OverthereConnection buildConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        Class<? extends OverthereConnectionBuilder> connectionBuilderClass = this.protocols.get().get(protocol);
        try {
            Constructor<? extends OverthereConnectionBuilder> constructor = connectionBuilderClass.getConstructor(String.class, ConnectionOptions.class, AddressPortMapper.class);
            OverthereConnectionBuilder connectionBuilder = constructor.newInstance(protocol, options, mapper);
            if (connectionBuilder instanceof LocalConnection) {
                logger.debug("Connecting to {}", (Object)connectionBuilder);
            } else {
                logger.info("Connecting to {}", (Object)connectionBuilder);
            }
            OverthereConnection connection = connectionBuilder.connect();
            logger.trace("Connected to {}", (Object)connection);
            return connection;
        }
        catch (NoSuchMethodException exc) {
            throw new IllegalStateException(connectionBuilderClass + " does not have a public constructor with the signature (String, ConnectionOptions, AddressPortMapper)", exc);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException exc) {
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
        catch (InvocationTargetException exc) {
            if (exc.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exc.getCause();
            }
            throw new IllegalStateException("Cannot instantiate " + connectionBuilderClass, exc);
        }
    }
}

