/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SecurityItemModifier;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLTemplate;
import org.apache.jackrabbit.core.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEditor
extends SecurityItemModifier
implements AccessControlEditor,
AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger((Class)ACLEditor.class);
    private static final String DEFAULT_ACE_NAME = "ace";
    private final SessionImpl session;
    private final String acRootPath;

    ACLEditor(SessionImpl session, Path acRootPath) throws RepositoryException {
        this.session = session;
        this.acRootPath = session.getJCRPath(acRootPath);
    }

    ACLTemplate getACL(Principal principal) throws RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        String nPath = this.getPathToAcNode(principal);
        if (this.session.nodeExists(nPath)) {
            return (ACLTemplate)this.getPolicies(nPath)[0];
        }
        log.debug("No combined policy template for Principal " + principal.getName());
        return null;
    }

    public AccessControlPolicy[] getPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        NodeImpl acNode = this.getAcNode(nodePath);
        if (acNode != null) {
            return new AccessControlPolicy[]{this.createTemplate(acNode)};
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] editAccessControlPolicies(String nodePath) throws AccessControlException, PathNotFoundException, RepositoryException {
        this.checkProtectsNode(nodePath);
        if (Text.isDescendant(this.acRootPath, nodePath)) {
            NodeImpl acNode = this.getAcNode(nodePath);
            if (acNode == null) {
                this.getPrincipal(nodePath);
                acNode = this.createAcNode(nodePath);
            }
            return new AccessControlPolicy[]{this.createTemplate(acNode)};
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] editAccessControlPolicies(Principal principal) throws RepositoryException {
        if (!this.session.getPrincipalManager().hasPrincipal(principal.getName())) {
            throw new AccessControlException("Unknown principal.");
        }
        String nPath = this.getPathToAcNode(principal);
        if (!this.session.nodeExists(nPath)) {
            this.createAcNode(nPath);
        }
        return this.getPolicies(nPath);
    }

    public void setPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        NodeImpl aclNode;
        this.checkProtectsNode(nodePath);
        this.checkValidPolicy(nodePath, policy);
        ACLTemplate acl = (ACLTemplate)policy;
        NodeImpl acNode = this.getAcNode(nodePath);
        if (acNode == null) {
            throw new PathNotFoundException("No such node " + nodePath);
        }
        if (acNode.hasNode(N_POLICY)) {
            aclNode = acNode.getNode(N_POLICY);
            this.removeSecurityItem(aclNode);
        }
        aclNode = this.addSecurityNode(acNode, N_POLICY, NT_REP_ACL);
        AccessControlEntry[] aces = acl.getAccessControlEntries();
        for (int i = 0; i < aces.length; ++i) {
            JackrabbitAccessControlEntry ace = (JackrabbitAccessControlEntry)aces[i];
            Name nodeName = ACLEditor.getUniqueNodeName(aclNode, "entry");
            Name ntName = ace.isAllow() ? NT_REP_GRANT_ACE : NT_REP_DENY_ACE;
            NodeImpl aceNode = this.addSecurityNode(aclNode, nodeName, ntName);
            ValueFactory vf = this.session.getValueFactory();
            this.setSecurityProperty(aceNode, P_PRINCIPAL_NAME, vf.createValue(ace.getPrincipal().getName()));
            Privilege[] privs = ace.getPrivileges();
            Value[] vs = new Value[privs.length];
            for (int j = 0; j < privs.length; ++j) {
                vs[j] = vf.createValue(privs[j].getName());
            }
            this.setSecurityProperty(aceNode, P_PRIVILEGES, vs);
            String[] restrNames = ace.getRestrictionNames();
            for (int rnIndex = 0; rnIndex < restrNames.length; ++rnIndex) {
                Name pName = this.session.getQName(restrNames[rnIndex]);
                Value value = ace.getRestriction(restrNames[rnIndex]);
                this.setSecurityProperty(aceNode, pName, value);
            }
        }
    }

    public void removePolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException, PathNotFoundException, RepositoryException {
        AccessControlPolicy tmpl;
        this.checkProtectsNode(nodePath);
        this.checkValidPolicy(nodePath, policy);
        NodeImpl acNode = this.getAcNode(nodePath);
        if (acNode != null && this.isAccessControlled(acNode) && (tmpl = this.createTemplate(acNode)).equals(policy)) {
            this.removeSecurityItem(acNode.getNode(N_POLICY));
            return;
        }
        throw new AccessControlException("Policy " + policy + " does not apply to " + nodePath);
    }

    private NodeImpl getAcNode(String nodePath) throws PathNotFoundException, RepositoryException {
        if (Text.isDescendant(this.acRootPath, nodePath)) {
            return (NodeImpl)this.session.getNode(nodePath);
        }
        return null;
    }

    private NodeImpl createAcNode(String acPath) throws RepositoryException {
        String[] segms = Text.explode(acPath, 47, false);
        NodeImpl node = (NodeImpl)this.session.getRootNode();
        for (int i = 0; i < segms.length; ++i) {
            Name nName = this.session.getQName(segms[i]);
            if (node.hasNode(nName)) {
                if ((node = node.getNode(nName)).isNodeType(NT_REP_ACCESS_CONTROL)) continue;
                throw new RepositoryException("Internal error: Unexpected nodetype " + node.getPrimaryNodeType().getName() + " below /rep:accessControl");
            }
            node = this.addSecurityNode(node, nName, NT_REP_ACCESS_CONTROL);
        }
        return node;
    }

    private void checkProtectsNode(String nodePath) throws RepositoryException {
        NodeImpl n;
        if (this.session.nodeExists(nodePath) && ((n = (NodeImpl)this.session.getNode(nodePath)).isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE))) {
            throw new AccessControlException("Node " + nodePath + " defines ACL or ACE.");
        }
    }

    private void checkValidPolicy(String nodePath, AccessControlPolicy policy) throws AccessControlException {
        if (policy == null || !(policy instanceof ACLTemplate)) {
            throw new AccessControlException("Attempt to set/remove invalid policy " + policy);
        }
        ACLTemplate acl = (ACLTemplate)policy;
        if (!nodePath.equals(acl.getPath())) {
            throw new AccessControlException("Policy " + policy + " is not applicable or does not apply to the node at " + nodePath);
        }
    }

    String getPathToAcNode(Principal principal) throws RepositoryException {
        StringBuffer princPath = new StringBuffer(this.acRootPath);
        if (principal instanceof ItemBasedPrincipal) {
            princPath.append(((ItemBasedPrincipal)principal).getPath());
        } else {
            princPath.append("/");
            princPath.append(Text.escapeIllegalJcrChars(principal.getName()));
        }
        return princPath.toString();
    }

    private Principal getPrincipal(String pathToACNode) throws RepositoryException {
        String name = Text.unescapeIllegalJcrChars(Text.getName(pathToACNode));
        PrincipalManager pMgr = this.session.getPrincipalManager();
        if (!pMgr.hasPrincipal(name)) {
            throw new AccessControlException("Unknown principal.");
        }
        return pMgr.getPrincipal(name);
    }

    private boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node.isNodeType(NT_REP_ACCESS_CONTROL) && node.hasNode(N_POLICY);
    }

    private AccessControlPolicy createTemplate(NodeImpl acNode) throws RepositoryException {
        Principal principal;
        if (!acNode.isNodeType(NT_REP_ACCESS_CONTROL)) {
            throw new RepositoryException("Expected node of type rep:AccessControl.");
        }
        String principalName = Text.unescapeIllegalJcrChars(acNode.getName());
        PrincipalManager pMgr = ((SessionImpl)acNode.getSession()).getPrincipalManager();
        if (pMgr.hasPrincipal(principalName)) {
            principal = pMgr.getPrincipal(principalName);
        } else {
            log.warn("Principal with name " + principalName + " unknown to PrincipalManager.");
            principal = new PrincipalImpl(principalName);
        }
        return new ACLTemplate(principal, acNode);
    }

    protected static Name getUniqueNodeName(Node node, String name) throws RepositoryException {
        if (name == null) {
            name = DEFAULT_ACE_NAME;
        } else {
            try {
                NameParser.checkFormat(name);
            }
            catch (NameException e) {
                name = DEFAULT_ACE_NAME;
                log.debug("Invalid path name for Permission: " + name + ".");
            }
        }
        int i = 0;
        String check = name;
        while (node.hasNode(check)) {
            check = name + i;
            ++i;
        }
        return ((SessionImpl)node.getSession()).getQName(check);
    }
}

