/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.rmi.remote.RemoteQuery;
import org.apache.jackrabbit.rmi.remote.RemoteQueryManager;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerQueryManager
extends ServerObject
implements RemoteQueryManager {
    private QueryManager manager;

    public ServerQueryManager(QueryManager manager, ServerAdapterFactory factory) throws RemoteException {
        super(factory);
        this.manager = manager;
    }

    public RemoteQuery createQuery(String statement, String language) throws RepositoryException, RemoteException {
        try {
            Query query = this.manager.createQuery(statement, language);
            return this.getFactory().getRemoteQuery(query);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemoteQuery getQuery(String absPath) throws RepositoryException, RemoteException {
        try {
            Node node = null;
            return this.getFactory().getRemoteQuery(this.manager.getQuery(node));
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException, RemoteException {
        try {
            return this.manager.getSupportedQueryLanguages();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

