/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import ai.digital.configuration.central.deploy.db.DatabaseProperties;
import com.xebialabs.deployit.core.metrics.XldDbMetricsTrackerFactory;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.config.DatabaseDriverConfiguration$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import java.sql.Connection;

public final class SqlConfiguration$ {
    public static final SqlConfiguration$ MODULE$ = new SqlConfiguration$();

    public HikariDataSource hikariDataSource(DatabaseProperties config, String name, XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory) {
        return new HikariDataSource(this.hikariConfig(config, name, xldDbMetricsTrackerFactory));
    }

    private HikariConfig hikariConfig(DatabaseProperties config, String poolName, XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory) {
        if (!config.hasConfigured()) {
            throw new IllegalArgumentException("No mandatory configuration for db-url or db-driver-classname");
        }
        HikariConfig hikariConfig = new HikariConfig();
        String url = config.dbUrl();
        if (DatabaseDriverConfiguration$.MODULE$.isMSSqlDatabase(config.dbDriverClassname()) && !url.contains("sendStringParametersAsUnicode")) {
            url = url.concat(";sendStringParametersAsUnicode=false");
        }
        hikariConfig.setDriverClassName(config.dbDriverClassname());
        hikariConfig.setJdbcUrl(url);
        hikariConfig.setUsername(config.dbUsername());
        hikariConfig.setPassword(config.dbPassword());
        hikariConfig.setMaximumPoolSize(config.maxPoolSize());
        hikariConfig.setMaxLifetime(config.getMaxLifeTimeInMillis());
        hikariConfig.setIdleTimeout(config.getIdleTimeoutInMillis());
        hikariConfig.setMinimumIdle(config.minimumIdle());
        hikariConfig.setConnectionTimeout(config.getConnectionTimeoutInMillis());
        hikariConfig.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        hikariConfig.setPoolName(poolName);
        hikariConfig.setAutoCommit(false);
        hikariConfig.setLeakDetectionThreshold(config.getLeakDetectionThresholdInMillis());
        hikariConfig.setMetricsTrackerFactory((MetricsTrackerFactory)xldDbMetricsTrackerFactory);
        return hikariConfig;
    }

    public String liquibaseContext(SqlDialect dialect, Connection con) {
        int majorVersion = con.getMetaData().getDatabaseMajorVersion();
        return new StringBuilder(1).append(dialect.toString()).append("-").append(majorVersion).toString();
    }

    private SqlConfiguration$() {
    }
}

