/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class BinaryInputStream
extends InputStream {
    private final ByteBuffer bbuf;

    BinaryInputStream(ByteBuffer b) {
        this.bbuf = b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.bbuf.hasRemaining()) {
            int chunk = Math.min(this.bbuf.remaining(), len);
            this.bbuf.get(b, off, chunk);
            return chunk;
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.bbuf.hasRemaining()) {
            return this.bbuf.get() & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        int skipped = 0;
        while (n > 0L && this.bbuf.hasRemaining()) {
            this.bbuf.get();
            --n;
            ++skipped;
        }
        return skipped;
    }

    public int available() throws IOException {
        return this.bbuf.remaining();
    }

    public void close() throws IOException {
    }
}

