/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.neo4j;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.neo4j.Neo4jHealthDetailsHandler;
import org.springframework.boot.actuate.neo4j.Neo4jHealthIndicator;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.retry.Retry;

public final class Neo4jReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Log logger = LogFactory.getLog(Neo4jReactiveHealthIndicator.class);
    private final Driver driver;
    private final Neo4jHealthDetailsHandler healthDetailsHandler;

    public Neo4jReactiveHealthIndicator(Driver driver) {
        this.driver = driver;
        this.healthDetailsHandler = new Neo4jHealthDetailsHandler();
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.runHealthCheckQuery().doOnError(SessionExpiredException.class, e -> logger.warn((Object)"Neo4j session has expired, retrying one single time to retrieve server health.")).retryWhen((Retry)Retry.max((long)1L).filter(SessionExpiredException.class::isInstance)).map(result -> {
            this.healthDetailsHandler.addHealthDetails(builder, (String)result.getT1(), (ResultSummary)result.getT2());
            return builder.build();
        });
    }

    Mono<Tuple2<String, ResultSummary>> runHealthCheckQuery() {
        return Mono.using(() -> this.driver.rxSession(Neo4jHealthIndicator.DEFAULT_SESSION_CONFIG), session -> {
            RxResult result = session.run("CALL dbms.components() YIELD name, edition WHERE name = 'Neo4j Kernel' RETURN edition");
            return Mono.from((Publisher)result.records()).map(record -> record.get("edition").asString()).zipWhen(edition -> Mono.from((Publisher)result.consume()));
        }, RxSession::close);
    }
}

