/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.client.local;

import ai.digital.deploy.permissions.api.rest.dto.RoleDto;
import ai.digital.deploy.permissions.api.rest.dto.RoleWithPrincipalsDto;
import ai.digital.deploy.permissions.api.rest.dto.converters.RoleConverter$;
import ai.digital.deploy.permissions.client.PaginatedResponse;
import ai.digital.deploy.permissions.client.RoleServiceClient;
import ai.digital.deploy.permissions.client.configuration.PermissionServiceEntityNotFoundError;
import ai.digital.deploy.permissions.client.util.SortOrder;
import ai.digital.deploy.permissions.client.util.SortOrder$;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.Role$;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Component
@ConditionalOnProperty(name={"xl.permission-service.enabled"}, havingValue="true", matchIfMissing=true)
@Profile(value={"permission-service"})
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u000b\u0017\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")\u0011\u000b\u0001C!%\")\u0011\u000e\u0001C!U\")1\u0010\u0001C!y\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0007\u0001\t\u0003\nY\u0002\u0003\u0004j\u0001\u0011\u0005\u0013q\u0005\u0005\u0007\u007f\u0002!\t%a\u000b\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001a\u0001\t\u0003\ni\u0007C\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAX\u0001\u0011\u0005\u0013\u0011\u0017\u0002\u0017\u0019>\u001c\u0017\r\u001c*pY\u0016\u001cVM\u001d<jG\u0016\u001cE.[3oi*\u0011q\u0003G\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u00033i\taa\u00197jK:$(BA\u000e\u001d\u0003-\u0001XM]7jgNLwN\\:\u000b\u0005uq\u0012A\u00023fa2|\u0017P\u0003\u0002 A\u00059A-[4ji\u0006d'\"A\u0011\u0002\u0005\u0005L7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,Y5\t\u0001$\u0003\u0002.1\t\t\"k\u001c7f'\u0016\u0014h/[2f\u00072LWM\u001c;\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003aMj\u0011!\r\u0006\u0003ei\tqa]3sm&\u001cW-\u0003\u00025c\tY!k\u001c7f'\u0016\u0014h/[2fQ\t\ta\u0007\u0005\u00028\u00056\t\u0001H\u0003\u0002:u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005mb\u0014a\u00024bGR|'/\u001f\u0006\u0003{y\nQAY3b]NT!a\u0010!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!Q\u0001\u0004_J<\u0017BA\"9\u0005%\tU\u000f^8xSJ,G-\u0001\u000bs_2,\u0007K]5oG&\u0004\u0018\r\\*feZL7-\u001a\t\u0003a\u0019K!aR\u0019\u0003)I{G.\u001a)sS:\u001c\u0017\u000e]1m'\u0016\u0014h/[2fQ\t\u0011a'\u0001\u0004=S:LGO\u0010\u000b\u0004\u00176{\u0005C\u0001'\u0001\u001b\u00051\u0002\"\u0002\u0018\u0004\u0001\u0004y\u0003FA'7\u0011\u0015!5\u00011\u0001FQ\tye'\u0001\u0004hKR\fE\u000e\\\u000b\u0002'B\u0019A\u000bX0\u000f\u0005USfB\u0001,Z\u001b\u00059&B\u0001-#\u0003\u0019a$o\\8u}%\tq%\u0003\u0002\\M\u00059\u0001/Y2lC\u001e,\u0017BA/_\u0005\u0011a\u0015n\u001d;\u000b\u0005m3\u0003C\u00011h\u001b\u0005\t'B\u00012d\u0003\r!Go\u001c\u0006\u0003I\u0016\fAA]3ti*\u0011aMG\u0001\u0004CBL\u0017B\u00015b\u0005\u001d\u0011v\u000e\\3Ei>\faa\u0019:fCR,GcA6oqB\u0011\u0001\r\\\u0005\u0003[\u0006\u0014QCU8mK^KG\u000f\u001b)sS:\u001c\u0017\u000e]1mg\u0012#x\u000eC\u0003p\u000b\u0001\u0007\u0001/\u0001\u0003oC6,\u0007CA9v\u001d\t\u00118\u000f\u0005\u0002WM%\u0011AOJ\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uM!)\u00110\u0002a\u0001u\u0006Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\u0007Qc\u0006/\u0001\bde\u0016\fG/Z(s+B$\u0017\r^3\u0015\u0005}k\b\"\u0002@\u0007\u0001\u0004y\u0016\u0001\u0002:pY\u0016\fa!\u001e9eCR,G#C6\u0002\u0004\u0005\u001d\u00111BA\u000b\u0011\u0019\t)a\u0002a\u0001a\u0006\u0001rN]5hS:\fGNU8mK:\u000bW.\u001a\u0005\u0007\u0003\u00139\u0001\u0019\u00019\u0002\u001fU\u0004H-\u0019;fIJ{G.\u001a(b[\u0016Dq!!\u0004\b\u0001\u0004\ty!\u0001\nqe&t7-\u001b9bYN$vn\u0011:fCR,\u0007\u0003B9\u0002\u0012AL1!a\u0005x\u0005\r\u0019V\r\u001e\u0005\b\u0003/9\u0001\u0019AA\b\u0003I\u0001(/\u001b8dSB\fGn\u001d+p\t\u0016dW\r^3\u0002'I,Wn\u001c<f\u00032d'+\u001a4fe\u0016t7-Z:\u0015\t\u0005u\u00111\u0005\t\u0004K\u0005}\u0011bAA\u0011M\t!QK\\5u\u0011\u0019\t)\u0003\u0003a\u0001a\u0006A!o\u001c7f\u001d\u0006lW\rF\u0002`\u0003SAQa\\\u0005A\u0002A$RaXA\u0017\u0003\u0003Bq!a\f\u000b\u0001\u0004\t\t$\u0001\u0002jIB!\u00111GA\u001f\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001B;uS2T!!a\u000f\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\t)D\u0001\u0003V+&#\u0005BBA\u0013\u0015\u0001\u0007\u0001/\u0001\u0004sK:\fW.\u001a\u000b\u0006?\u0006\u001d\u0013\u0011\n\u0005\u0006_.\u0001\r\u0001\u001d\u0005\u0007\u0003\u0017Z\u0001\u0019\u00019\u0002\u000f9,wOT1nK\u00061A-\u001a7fi\u0016$B!!\b\u0002R!1\u0011Q\u0005\u0007A\u0002A\f!\u0002Z3mKR,')_%e)\u0011\ti\"a\u0016\t\r\u0005eS\u00021\u0001q\u0003\u0019\u0011x\u000e\\3JI\u0006A!/Z1e\u0005fLE\r\u0006\u0003\u0002`\u0005\u0015\u0004\u0003B\u0013\u0002b}K1!a\u0019'\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011\f\bA\u0002A\fAA]3bIR!\u0011qLA6\u0011\u0019\t)c\u0004a\u0001aRa\u0011qNA;\u0003s\n\u0019)a\"\u0002\u0016B!1&!\u001d`\u0013\r\t\u0019\b\u0007\u0002\u0012!\u0006<\u0017N\\1uK\u0012\u0014Vm\u001d9p]N,\u0007BBA<!\u0001\u0007\u0001/A\u0006oC6,\u0007+\u0019;uKJt\u0007bBA>!\u0001\u0007\u0011QP\u0001\u0005a\u0006<W\rE\u0002&\u0003\u007fJ1!!!'\u0005\rIe\u000e\u001e\u0005\b\u0003\u000b\u0003\u0002\u0019AA?\u0003\u0011\u0019\u0018N_3\t\u000f\u0005%\u0005\u00031\u0001\u0002\f\u0006)qN\u001d3feB!\u0011QRAI\u001b\t\tyIC\u0002\u00028aIA!a%\u0002\u0010\nI1k\u001c:u\u001fJ$WM\u001d\u0005\u0007\u0003/\u0003\u0002\u0019\u00019\u0002\u000b\u0019LW\r\u001c3\u0002#I,\u0017\r\u001a\"z%>dW\rU1ui\u0016\u0014h\u000eF\u0002T\u0003;Ca!a\u001e\u0012\u0001\u0004\u0001\u0018!\u0003:f[>4X-\u00117m)\t\ti\"\u0001\u0006s_2,W\t_5tiN$B!a*\u0002.B\u0019Q%!+\n\u0007\u0005-fEA\u0004C_>dW-\u00198\t\r\u0005\u00152\u00031\u0001q\u0003)\u0019w.\u001e8u%>dWm\u001d\u000b\u0005\u0003g\u000bI\fE\u0002&\u0003kK1!a.'\u0005\u0011auN\\4\t\r\u0005mF\u00031\u0001q\u0003=\u0011x\u000e\\3OC6,\u0007+\u0019;uKJt\u0007f\u0001\u0001\u0002@B!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002Fj\t1A\u001b9b\u0013\u0011\tI-a1\u0003=Q\u0013\u0018M\\:bGRLwN\\1m!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007f\u0002\u0001\u0002N\u0006m\u0017Q\u001c\t\u0005\u0003\u001f\f9.\u0004\u0002\u0002R*\u0019\u0011(a5\u000b\u0007\u0005Ug(A\u0004d_:$X\r\u001f;\n\t\u0005e\u0017\u0011\u001b\u0002\b!J|g-\u001b7f\u0003\u00151\u0018\r\\;fY\t\ty.\t\u0002\u0002b\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8.g\u0016\u0014h/[2fQ9\u0001\u0011Q]8\u0002z\u0006}(\u0011\u0001B\u0003\u0005\u000f\u0001B!a:\u0002v6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/A\u0005d_:$\u0017\u000e^5p]*!\u0011q^Ay\u00035\tW\u000f^8d_:4\u0017nZ;sK*\u0019\u00111\u001f \u0002\t\t|w\u000e^\u0005\u0005\u0003o\fIOA\u000bD_:$\u0017\u000e^5p]\u0006dwJ\u001c)s_B,'\u000f^=-\u0005\u0005m\u0018EAA\u007f\u0003uAHN\f9fe6L7o]5p]6\u001aXM\u001d<jG\u0016tSM\\1cY\u0016$\u0017a\u00035bm&twMV1mk\u0016\f#Aa\u0001\u0002\tQ\u0014X/Z\u0001\u000f[\u0006$8\r[%g\u001b&\u001c8/\u001b8h3\u0005\t\u0001f\u0001\u0001\u0003\fA!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012y\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011)Ba\u0004\u0003\u0013\r{W\u000e]8oK:$\b")
public class LocalRoleServiceClient
implements RoleServiceClient {
    @Autowired
    private final RoleService roleService;
    @Autowired
    private final RolePrincipalService rolePrincipalService;

    @Override
    public List<RoleDto> getAll() {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readAll());
    }

    @Override
    public RoleWithPrincipalsDto create(String name, List<String> principals) {
        this.roleService.create(name);
        Tuple2 tuple2 = this.rolePrincipalService.add(name, principals);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Role role = (Role)tuple2._1();
        List rolePrincipals = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)role, (Object)rolePrincipals);
        Tuple2 tuple23 = tuple22;
        Role role2 = (Role)tuple23._1();
        List rolePrincipals2 = (List)tuple23._2();
        return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(role2), rolePrincipals2.map((Function1 & Serializable)x$2 -> x$2.principalName()));
    }

    @Override
    public RoleDto createOrUpdate(RoleDto role) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.createOrUpdate(Role$.MODULE$.apply(role.id(), role.name())));
    }

    @Override
    public RoleWithPrincipalsDto update(String originalRoleName, String updatedRoleName, Set<String> principalsToCreate, Set<String> principalsToDelete) {
        this.rolePrincipalService.edit(originalRoleName, principalsToCreate.toList(), principalsToDelete.toList());
        Role role = (Role)this.roleService.read(originalRoleName).getOrElse((Function0 & Serializable)() -> {
            throw new PermissionServiceEntityNotFoundError(new StringBuilder(45).append("Couldn't update role ").append(originalRoleName).append(" - role entity not found").toString());
        });
        role.name_$eq(updatedRoleName);
        Role updatedRole = this.roleService.update(role);
        return new RoleWithPrincipalsDto(RoleConverter$.MODULE$.roleToDto(updatedRole), ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(updatedRole.principals()).asScala().map((Function1 & Serializable)x$3 -> x$3.principalName())).toList());
    }

    @Override
    public void removeAllReferences(String roleName) {
        this.roleService.deleteAllRoleReferences(roleName);
    }

    @Override
    public RoleDto create(String name) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.create(name));
    }

    @Override
    public RoleDto update(UUID id, String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.update(Role$.MODULE$.apply(id, roleName)));
    }

    @Override
    public RoleDto rename(String name, String newName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.rename(name, newName));
    }

    @Override
    public void delete(String roleName) {
        this.roleService.delete(roleName);
    }

    @Override
    public void deleteById(String roleId) {
        this.roleService.delete(UUID.fromString(roleId));
    }

    @Override
    public Option<RoleDto> readById(String roleId) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(UUID.fromString(roleId)));
    }

    @Override
    public Option<RoleDto> read(String roleName) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.read(roleName));
    }

    @Override
    public PaginatedResponse<RoleDto> read(String namePattern, int page, int size, SortOrder order, String field) {
        Page rolePage = this.roleService.read(namePattern, (Pageable)PageRequest.of((int)(page - 1), (int)size, (Sort)SortOrder$.MODULE$.getSort(order, field)));
        return new PaginatedResponse<RoleDto>(RoleConverter$.MODULE$.roleToDto(CollectionConverters$.MODULE$.ListHasAsScala(rolePage.getContent()).asScala().toList()), rolePage.getTotalElements(), page, size, rolePage.hasNext());
    }

    @Override
    public List<RoleDto> readByRolePattern(String namePattern) {
        return RoleConverter$.MODULE$.roleToDto(this.roleService.readByRolePattern(namePattern));
    }

    @Override
    public void removeAll() {
        this.roleService.removeAll();
    }

    @Override
    public boolean roleExists(String roleName) {
        return this.roleService.read(roleName).isDefined();
    }

    @Override
    public long countRoles(String roleNamePattern) {
        return this.roleService.count(roleNamePattern);
    }

    public LocalRoleServiceClient(@Autowired RoleService roleService, @Autowired RolePrincipalService rolePrincipalService) {
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

