/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.LogicalCallableStatement;
import org.apache.derby.client.am.LogicalPreparedStatement;
import org.apache.derby.client.am.LogicalStatementEntity;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.client.am.stmtcache.StatementKeyFactory;
import org.apache.derby.jdbc.ClientDriver;

public final class StatementCacheInteractor {
    private final JDBCStatementCache cache;
    private final ClientConnection physicalConnection;
    private final ArrayList<LogicalStatementEntity> openLogicalStatements = new ArrayList();
    private boolean connCloseInProgress = false;

    StatementCacheInteractor(JDBCStatementCache jDBCStatementCache, ClientConnection clientConnection) {
        this.cache = jDBCStatementCache;
        this.physicalConnection = clientConnection;
    }

    synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newPrepared(string, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.holdability());
        PreparedStatement preparedStatement = this.cache.getCached(statementKey);
        if (preparedStatement == null) {
            preparedStatement = this.physicalConnection.prepareStatement(string);
        }
        return this.createLogicalPreparedStatement(preparedStatement, statementKey);
    }

    synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newPrepared(string, this.physicalConnection.getCurrentSchemaName(), n, n2, this.physicalConnection.holdability());
        PreparedStatement preparedStatement = this.cache.getCached(statementKey);
        if (preparedStatement == null) {
            preparedStatement = this.physicalConnection.prepareStatement(string, n, n2);
        }
        return this.createLogicalPreparedStatement(preparedStatement, statementKey);
    }

    synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newPrepared(string, this.physicalConnection.getCurrentSchemaName(), n, n2, n3);
        PreparedStatement preparedStatement = this.cache.getCached(statementKey);
        if (preparedStatement == null) {
            preparedStatement = this.physicalConnection.prepareStatement(string, n, n2, n3);
        }
        return this.createLogicalPreparedStatement(preparedStatement, statementKey);
    }

    synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newPrepared(string, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.getHoldability(), n);
        PreparedStatement preparedStatement = this.cache.getCached(statementKey);
        if (preparedStatement == null) {
            preparedStatement = this.physicalConnection.prepareStatement(string, n);
        }
        return this.createLogicalPreparedStatement(preparedStatement, statementKey);
    }

    synchronized CallableStatement prepareCall(String string) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newCallable(string, this.physicalConnection.getCurrentSchemaName(), this.physicalConnection.holdability());
        CallableStatement callableStatement = (CallableStatement)this.cache.getCached(statementKey);
        if (callableStatement == null) {
            callableStatement = this.physicalConnection.prepareCall(string);
        }
        return this.createLogicalCallableStatement(callableStatement, statementKey);
    }

    synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newCallable(string, this.physicalConnection.getCurrentSchemaName(), n, n2, this.physicalConnection.holdability());
        CallableStatement callableStatement = (CallableStatement)this.cache.getCached(statementKey);
        if (callableStatement == null) {
            callableStatement = this.physicalConnection.prepareCall(string, n, n2);
        }
        return this.createLogicalCallableStatement(callableStatement, statementKey);
    }

    synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        StatementKey statementKey = StatementKeyFactory.newCallable(string, this.physicalConnection.getCurrentSchemaName(), n, n2, n3);
        CallableStatement callableStatement = (CallableStatement)this.cache.getCached(statementKey);
        if (callableStatement == null) {
            callableStatement = this.physicalConnection.prepareCall(string, n, n2, n3);
        }
        return this.createLogicalCallableStatement(callableStatement, statementKey);
    }

    synchronized void closeOpenLogicalStatements() throws SQLException {
        this.connCloseInProgress = true;
        for (LogicalStatementEntity logicalStatementEntity : this.openLogicalStatements) {
            logicalStatementEntity.close();
        }
        this.openLogicalStatements.clear();
    }

    synchronized void markClosed(LogicalStatementEntity logicalStatementEntity) {
        if (!this.connCloseInProgress) {
            boolean bl = this.openLogicalStatements.remove(logicalStatementEntity);
        }
    }

    private PreparedStatement createLogicalPreparedStatement(PreparedStatement preparedStatement, StatementKey statementKey) throws SQLException {
        LogicalPreparedStatement logicalPreparedStatement = ClientDriver.getFactory().newLogicalPreparedStatement(preparedStatement, statementKey, this);
        this.openLogicalStatements.add(logicalPreparedStatement);
        return logicalPreparedStatement;
    }

    private CallableStatement createLogicalCallableStatement(CallableStatement callableStatement, StatementKey statementKey) throws SQLException {
        LogicalCallableStatement logicalCallableStatement = ClientDriver.getFactory().newLogicalCallableStatement(callableStatement, statementKey, this);
        this.openLogicalStatements.add(logicalCallableStatement);
        return logicalCallableStatement;
    }

    JDBCStatementCache getCache() {
        return this.cache;
    }
}

