/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDir
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(WorkDir.class);
    private LocalFile baseWorkDir;
    private String prefix;
    private LocalFile workDir;

    public WorkDir(File baseWorkDir, String workDirPrefix) {
        this.baseWorkDir = LocalFile.from((File)baseWorkDir);
        this.prefix = workDirPrefix;
    }

    public WorkDir(LocalFile workDir) {
        this.workDir = workDir;
    }

    private synchronized LocalFile workDir() {
        if (this.workDir == null || !this.workDir.exists()) {
            this.workDir = WorkDir.initWorkDir(this.baseWorkDir, this.prefix);
        }
        return this.workDir;
    }

    public LocalFile newFile(String filename) {
        LocalFile workDir = this.workDir();
        OverthereUtils.checkState((boolean)workDir.exists(), (String)"Cannot create a new file when workDir [%s] does not exist.", (Object[])new Object[]{workDir});
        return (LocalFile)OverthereUtils.getUniqueFolder((OverthereFile)workDir, (String)"artifact").getFile(filename);
    }

    public String getPath() {
        return this.workDir().getPath();
    }

    public void delete() {
        if (this.workDir != null) {
            logger.debug("Deleting workDir {}", (Object)this);
            if (this.workDir.exists()) {
                try {
                    this.workDir.deleteRecursively();
                }
                catch (Exception e) {
                    logger.warn("Could not delete [{}]; you can do this manually.", (Object)this.workDir.getPath());
                    logger.debug(String.format("The reason is: %s", e.getMessage()), (Throwable)e);
                }
            } else {
                logger.debug("Workdirectory {} already deleted.", (Object)this);
            }
        }
    }

    public WorkDir rebase(File newBaseWorkDir, boolean create) {
        this.baseWorkDir = LocalFile.from((File)newBaseWorkDir);
        if (this.workDir != null) {
            this.workDir = (LocalFile)this.baseWorkDir.getFile(this.workDir.getName());
            if (create && !this.workDir.exists()) {
                this.workDir.mkdir();
            }
        }
        return this;
    }

    public String toString() {
        if (this.workDir == null) {
            return "WorkDir[" + this.baseWorkDir + " : " + WorkDir.getBaseName(this.prefix) + "]";
        }
        return "WorkDir[" + this.getPath() + "]";
    }

    private static LocalFile initWorkDir(LocalFile baseWorkDir, String baseName) {
        OverthereFile uniqueFolder = OverthereUtils.getUniqueFolder((OverthereFile)baseWorkDir, (String)WorkDir.workDirPrefix(WorkDir.getBaseName(baseName)));
        logger.info("Working directory initialized in {}", (Object)uniqueFolder);
        return (LocalFile)uniqueFolder;
    }

    private static String getBaseName(String baseName) {
        return WorkDir.isBlank(baseName) ? "workdir" : baseName;
    }

    private static String workDirPrefix(String baseName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        return baseName + "-" + dateFormat.format(new Date());
    }

    private static boolean isBlank(String workdirPrefix) {
        return workdirPrefix == null || workdirPrefix.trim().isEmpty();
    }
}

