/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.effects.ImagePainter;
import com.jeta.forms.gui.effects.Paintable;
import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.effects.PaintSupport;
import com.jeta.open.i18n.I18N;
import java.awt.Component;
import java.io.IOException;

public class ImageProperty
extends IconProperty
implements PaintSupport {
    static final long serialVersionUID = -9049185327280513748L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 5;
    public static final int VERSION = 1;
    private int m_halign;
    private int m_valign;
    private transient ImagePainter m_painter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Painter createPainter() {
        if (this.m_painter == null) {
            this.m_painter = new ImagePainter(this, this.getHorizontalAlignment(), this.getVerticalAlignment());
        }
        return this.m_painter;
    }

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public void setHorizontalAlignment(int n) {
        this.m_halign = n;
        this.m_painter = null;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (object instanceof ImageProperty) {
            ImageProperty imageProperty = (ImageProperty)object;
            this.m_halign = imageProperty.m_halign;
            this.m_valign = imageProperty.m_valign;
            this.m_painter = null;
        } else if (!(object instanceof IconProperty) && !$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setVerticalAlignment(int n) {
        this.m_valign = n;
        this.m_painter = null;
    }

    public void updateBean(JETABean jETABean) {
        Component component;
        super.updateBean(jETABean);
        ImagePainter imagePainter = (ImagePainter)this.createPainter();
        if (jETABean != null && (component = jETABean.getDelegate()) instanceof Paintable) {
            ((Paintable)((Object)component)).setBackgroundPainter(imagePainter);
        }
    }

    public String toString() {
        return I18N.getLocalizedMessage("Image");
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_halign = jETAObjectInput.readInt("halign");
        this.m_valign = jETAObjectInput.readInt("valign");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(IconProperty.class));
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeInt("halign", this.m_halign);
        jETAObjectOutput.writeInt("valign", this.m_valign);
    }

    static {
        $assertionsDisabled = !ImageProperty.class.desiredAssertionStatus();
    }
}

