/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.local;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.local.LocalProcess;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.overthere.util.WindowsCommandLineArgsSanitizer;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="local")
public class LocalConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    public static final String LOCAL_PROTOCOL = "local";
    private static final Logger logger = LoggerFactory.getLogger(LocalConnection.class);

    public LocalConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, LocalConnection.fixOptions(options), mapper, true);
    }

    public LocalConnection(String protocol, ConnectionOptions options) {
        this(protocol, options, new DefaultAddressPortMapper());
    }

    private static ConnectionOptions fixOptions(ConnectionOptions options) {
        options = new ConnectionOptions(options);
        options.set("os", (Object)OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        if (options.getOptional("tmp") == null) {
            options.set("tmp", System.getProperty("java.io.tmpdir"));
        }
        return options;
    }

    @Override
    public OverthereConnection connect() {
        this.connected();
        return this;
    }

    @Override
    public void doClose() {
    }

    @Override
    protected void logDisconnect() {
        logger.debug("Disconnected from: {}", (Object)this);
    }

    @Override
    public OverthereFile getFile(String path) throws RuntimeIOException {
        return new LocalFile(this, new File(path));
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        if (!(parent instanceof LocalFile)) {
            throw new IllegalStateException("parent is not a LocalOverthereFile");
        }
        File childFile = new File(((LocalFile)parent).getFile(), child);
        return new LocalFile(this, childFile);
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return this.getFile(parent, name);
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        OverthereUtils.checkNotNull(cmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(cmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        File wd = null;
        if (this.workingDirectory != null) {
            wd = ((LocalFile)this.workingDirectory).getFile();
        }
        try {
            logger.debug("Creating " + this.os + " process with command line [{}]", (Object)obfuscatedCmd);
            CmdLine command = this.isWindows(this.os) ? this.getCmdForWindows(cmd) : cmd;
            ProcessBuilder pb = new ProcessBuilder(command.toCommandArray(this.os, false));
            if (wd != null) {
                logger.debug("Setting working directory to [{}]", (Object)wd);
                pb.directory(wd);
            } else {
                logger.debug("Not setting working directory");
            }
            logger.debug("Starting process");
            Process p = pb.start();
            return new LocalProcess(p);
        }
        catch (IOException exc) {
            throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, this), exc);
        }
    }

    @Override
    public String toString() {
        return "local:";
    }

    @Override
    protected void finalize() throws Throwable {
        OverthereUtils.closeQuietly(this);
        super.finalize();
    }

    public static OverthereConnection getLocalConnection() {
        return Overthere.getConnection(LOCAL_PROTOCOL, new ConnectionOptions());
    }

    private boolean isWindows(OperatingSystemFamily os) {
        return os == OperatingSystemFamily.WINDOWS;
    }

    private CmdLine getCmdForWindows(CmdLine cmd) {
        String command = cmd.toCommandLine(OperatingSystemFamily.WINDOWS, false);
        CmdLine c = CmdLine.build("cmd", "/s", "/c");
        if (WindowsCommandLineArgsSanitizer.containsAnySpecialChars(command)) {
            return c.addArgument("\"" + command + "\"");
        }
        return c.add(cmd.getArguments());
    }
}

