package ai.digital.deploy.task.steplog.queue

import ai.digital.deploy.task.steplog.TaskStepLogStoreHolder
import com.xebialabs.deployit.core.events.TaskStepLogEvent
import grizzled.slf4j.Logging
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty
import org.springframework.context.event.EventListener
import org.springframework.stereotype.Component
import org.springframework.scheduling.annotation.Async

@ConditionalOnProperty(prefix = "deploy.task", name = Array("resilient"), havingValue = "true", matchIfMissing = false)
@Component
class TaskStepLogListener extends Logging {

  @Async("simpleAsyncTaskExecutor")
  @EventListener
  def handleStepLogEvent(event: TaskStepLogEvent): Unit = {
    logger.debug(s"Received Application TaskStepLogEvent start " +
      s"taskId: ${event.taskId} " +
      s"path: ${event.stepPath} " +
      s"logLine: ${event.lineNumber} " +
      s"logLevel: ${event.logLevel} " +
      s"log: ${event.log}")
    TaskStepLogStoreHolder.getTaskStepLogJmsBean.sendStepLogEvent(event)
  }
}
