package ai.digital.deploy.profiling.web

import ai.digital.deploy.profiling.ApplicationProfiler.PROFILING
import ai.digital.deploy.profiling.web.CorrelationalIdListener.CORRELATION_ID
import org.slf4j.MDC
import org.springframework.context.annotation.Profile
import org.springframework.stereotype.Component
import org.springframework.web.context.request.RequestContextListener

import java.util.UUID
import jakarta.servlet.ServletRequestEvent
import jakarta.servlet.annotation.WebListener

object CorrelationalIdListener {
  val CORRELATION_ID = "correlationId"
}

@Component
@WebListener
@Profile(Array(PROFILING))
class CorrelationalIdListener extends RequestContextListener {

  override def requestInitialized(requestEvent: ServletRequestEvent): Unit = {
    super.requestInitialized(requestEvent)
    MDC.put(CORRELATION_ID, UUID.randomUUID().toString)
  }

  override def requestDestroyed(requestEvent: ServletRequestEvent): Unit = {
    super.requestDestroyed(requestEvent)
    MDC.remove(CORRELATION_ID)
  }
}

