package com.xebialabs.deployit.engine.tasker.log.elastic

import java.time.{Instant, ZonedDateTime}

import com.sksamuel.elastic4s.ElasticClient
import com.xebialabs.deployit.engine.tasker.log.{ExternalStepLogFactory, StepLog}
import com.xebialabs.deployit.engine.tasker.{BlockPath, TaskId, TaskStep}
import grizzled.slf4j.Logging

class ElasticStepLogFactory(client: ElasticClient, logIndex: String) extends ExternalStepLogFactory {
  override def create(taskId: TaskId, stepPath: BlockPath, step: TaskStep): StepLog = new ElasticStepLog(taskId, stepPath, step, client, logIndex)
  override def append(taskId: TaskId, stepPath: BlockPath, timestamp: Instant, failureCount: Int, message: String): Unit = doAppend(client, logIndex, taskId, stepPath, timestamp, failureCount, message)
}

class ElasticStepLog(taskId: TaskId, stepPath: BlockPath, step: TaskStep, client: ElasticClient, logIndex: String) extends StepLog with Logging {

  override def markNextAttempt(): Unit = {}

  protected def doAppendLog(s: String*): Unit = appendToIndex(s.mkString)

  private def appendToIndex(message: String): Unit = {
    val failureCount = step.getFailureCount
    doAppend(client, logIndex, taskId, stepPath, ZonedDateTime.now().toInstant, failureCount, message)
  }

}