package com.xebialabs.deployit.task.archive.queue

import com.xebialabs.deployit.task.archive.{BatchSecureCiMessage, BatchTaskArchiveRepository, SecureCiMessage, TaskArchiveRepository, TaskMessage}
import javax.jms.TextMessage
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.jms.annotation.JmsListener
import org.springframework.jms.support.converter.MessageConverter
import org.springframework.stereotype.Component

@Component
@Autowired
class DeploymentArchiveMessageConsumer(taskArchiveRepository: BatchTaskArchiveRepository,
                                       jacksonJmsMessageConverter: MessageConverter) {
  @JmsListener(destination = ArchiveTaskQueueing.ArchiveQueueSpELExpression,
    containerFactory = "xlJmsListenerContainerFactory")
  def receiveTextMessage(message: TextMessage): Unit = {
    jacksonJmsMessageConverter.fromMessage(message) match {
      case taskMessage: TaskMessage =>
        taskArchiveRepository.store(taskMessage)
      case secureCiMessage: SecureCiMessage if message.getBooleanProperty(ArchiveTaskQueueing.IsBatchProperty) =>
        taskArchiveRepository.updateSecureCi(secureCiMessage.securedCi,
                                            secureCiMessage.environmentIds,
                                            secureCiMessage.applicationIds,
                                            secureCiMessage.otherCiIds)
      case secureCiMessage: SecureCiMessage =>
        taskArchiveRepository.updateSecureCi(secureCiMessage.primaryKey.orNull, secureCiMessage.securedCi)
      case batch: BatchSecureCiMessage =>
        taskArchiveRepository.batchUpdateSecureCi(batch)
    }
  }
}
