package com.xebialabs.deployit.task.archive.compression

import com.xebialabs.deployit.task.archive.TaskMessage
import com.xebialabs.xlplatform.utils.ResourceManagement.using
import grizzled.slf4j.Logging
import org.fusesource.hawtbuf.ByteArrayOutputStream

import java.io.{ByteArrayInputStream, ObjectInputStream, ObjectOutputStream}
import java.util.zip.{GZIPInputStream, GZIPOutputStream}

object CompressionUtils extends Logging {

  def compressTaskMessage(taskMessage: TaskMessage): Array[Byte] = {
    try {
      val byteArrayOutputStream = new ByteArrayOutputStream()
      val gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream)
      using(new ObjectOutputStream(gzipOutputStream)) {
        _.writeObject(taskMessage)
      }
      logger.debug(s"Archive Message size for taskId [${taskMessage.taskId}] is [${byteArrayOutputStream.size}] bytes")
      byteArrayOutputStream.toByteArray
    } catch {
      case e: Exception =>
        logger.error(s"Could not compress task message [${taskMessage.taskId}]", e)
        throw e
    }
  }

  def decompressTaskMessage(bytes: Array[Byte]): TaskMessage = {
    try {
      val byteArrayInputStream = new ByteArrayInputStream(bytes)
      val gzipInputStream = new GZIPInputStream(byteArrayInputStream)
      using(new ObjectInputStream(gzipInputStream)) {
        _.readObject().asInstanceOf[TaskMessage]
      }
    } catch {
      case e: Exception =>
        logger.error(s"Could not decompress task message", e)
        throw e
    }
  }
}
