package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.engine.api.execution.TaskWithBlock
import com.xebialabs.deployit.task.TaskMetadata
import org.joda.time.DateTime

class ControlTaskArchiveSerializer(override val task: TaskWithBlock) extends DefaultTaskArchiveSerializer(task) {

  override def getTaskKind: String = ControlTaskArchiveSerializer.kind

  override def serialize(workerName: Option[String]): TaskMessage = {
    ControlTaskMessage(
      task.getId,
      archiveDetails(workerName),
      task.getMetadata.get(TaskMetadata.TASK_NAME),
      task.getMetadata.get(TaskMetadata.CONTROL_TASK_TARGET_CI),
      task.getMetadata.get(TaskMetadata.CONTROL_TASK_TARGET_INTERNAL_CI).toInt,
      Option(task.getMetadata.get(TaskMetadata.CONTROL_TASK_TARGET_SECURED_CI)).map(_.toInt),
      task.getMetadata.get(TaskMetadata.CONTROL_TASK_TARGET_DIRECTORY_REFERENCE),
      task.getOwner,
      task.getDescription,
      task.getState.toString,
      task.getFailureCount,
      task.getStartDate,
      task.getCompletionDate)
  }

}

object ControlTaskArchiveSerializer {
  val kind = "CONTROL_TASK"
}

case class ControlTaskMessage(override val taskId: String,
                              override val archiveDetails: ArchiveDetails,
                              taskName: String,
                              targetCi: String,
                              targetInternalId: Int,
                              targetSecuredId: Option[Int],
                              targetDirectoryReference: String,
                              owner: String,
                              description: String,
                              state: String,
                              failureCount: Integer,
                              override val startDate: DateTime,
                              completionDate: DateTime) extends TaskMessage
