package com.xebialabs.deployit.task.archive

import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.module.SimpleModule
import com.fasterxml.jackson.datatype.joda.JodaModule
import com.xebialabs.deployit.engine.api.execution.{BlockState, StepState, TaskPackageDependency, TaskWithBlock}
import com.xebialabs.deployit.engine.tasker.{ExecutableBlock, Phase, PhaseContainer}
import com.xebialabs.deployit.task.{ArchivedPhaseContainerMixin, ArchivedPhaseMixin, BlockStateMixin, ExecutableBlockMixin, PhaseContainerMixin, PhaseMixin, StepStateMixin, TaskPackageDependencyMixin, TaskWithBlockMixin}

object ArchiveObjectMapper {
  val mapper: ObjectMapper = {
    val m = new ObjectMapper
    m.registerModule(new JodaModule)
    m.setSerializationInclusion(Include.NON_NULL)
    val archiveModule = new SimpleModule("xld.archive")
    archiveModule.setMixInAnnotation(classOf[TaskWithBlock], classOf[TaskWithBlockMixin])
    archiveModule.setMixInAnnotation(classOf[BlockState], classOf[BlockStateMixin])
    archiveModule.setMixInAnnotation(classOf[PhaseContainer], classOf[PhaseContainerMixin])
    archiveModule.setMixInAnnotation(classOf[ArchivedPhaseContainer], classOf[ArchivedPhaseContainerMixin])
    archiveModule.setMixInAnnotation(classOf[Phase], classOf[PhaseMixin])
    archiveModule.setMixInAnnotation(classOf[ArchivedPhase], classOf[ArchivedPhaseMixin])
    archiveModule.setMixInAnnotation(classOf[ExecutableBlock], classOf[ExecutableBlockMixin])
    archiveModule.setMixInAnnotation(classOf[ArchivedCompositeBlock], classOf[ExecutableBlockMixin])
    archiveModule.setMixInAnnotation(classOf[ArchivedStepBlock], classOf[ExecutableBlockMixin])
    archiveModule.setMixInAnnotation(classOf[StepState], classOf[StepStateMixin])
    archiveModule.setMixInAnnotation(classOf[ArchivedStep], classOf[StepStateMixin])
    archiveModule.setMixInAnnotation(classOf[TaskPackageDependency], classOf[TaskPackageDependencyMixin])
    m.registerModule(archiveModule)
    m
  }
}
