package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.SatelliteConnectionState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;

public abstract class ArchivedAbstractBlock implements Block, BlockState {
    private String id;
    private String description;
    private BlockExecutionState state;
    private SatelliteConnectionState satelliteConnectionState;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public BlockExecutionState getState() {
        return state;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public void setState(final BlockExecutionState state) {
        this.state = state;
    }

    @Override
    public String description() {
        return getDescription();
    }

    @Override
    public void setSatelliteState(SatelliteConnectionState state) {
        this.satelliteConnectionState = state;
    }

    public void satelliteState_$eq(SatelliteConnectionState satelliteConnectionState) {
        setSatelliteState(satelliteConnectionState);
    }

    @Override
    public <A extends Block> void newState(BlockExecutionState state) {
        throw new UnsupportedOperationException("Does not work for archived blocks");
    }

    @Override
    public void recovered() {
        throw new UnsupportedOperationException("Does not work for archived blocks");
    }

    @Override
    public BlockPath id() {
        return BlockPath.apply(id);
    }

    @Override
    public SatelliteConnectionState getSatelliteConnectionState() {
        return satelliteConnectionState;
    }
}
